/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.state;

import java.util.concurrent.CompletableFuture;
import net.kuujo.copycat.cluster.ClusterConfig;
import net.kuujo.copycat.cluster.internal.coordinator.ClusterCoordinator;
import net.kuujo.copycat.cluster.internal.coordinator.CoordinatorConfig;
import net.kuujo.copycat.cluster.internal.coordinator.DefaultClusterCoordinator;
import net.kuujo.copycat.resource.Resource;
import net.kuujo.copycat.state.StateMachineConfig;
import net.kuujo.copycat.util.function.TriConsumer;

public interface StateMachine<T>
extends Resource<StateMachine<T>> {
    public static <T> StateMachine<T> create(String name, Class<T> stateType, Class<? extends T> initialState) {
        return StateMachine.create(name, new ClusterConfig(), new StateMachineConfig().withStateType(stateType).withInitialState(initialState));
    }

    public static <T> StateMachine<T> create(String name, Class<T> stateType, Class<? extends T> initialState, ClusterConfig cluster) {
        return StateMachine.create(name, cluster, new StateMachineConfig().withStateType(stateType).withInitialState(initialState));
    }

    public static <T> StateMachine<T> create(String name, ClusterConfig cluster, StateMachineConfig config) {
        DefaultClusterCoordinator coordinator = new DefaultClusterCoordinator(new CoordinatorConfig().withName(name).withClusterConfig(cluster));
        return (StateMachine)((StateMachine)((StateMachine)coordinator.getResource(name, config.resolve(cluster))).addStartupTask(() -> StateMachine.lambda$create$dea90c06$1((ClusterCoordinator)coordinator))).addShutdownTask(() -> ((ClusterCoordinator)coordinator).close());
    }

    public <U> U createProxy(Class<U> var1);

    public <U> U createProxy(Class<U> var1, ClassLoader var2);

    public void registerWatcher(TriConsumer<String, Object, Object> var1);

    public void unregisterWatcher(TriConsumer<String, Object, Object> var1);

    private static /* synthetic */ CompletableFuture lambda$create$dea90c06$1(ClusterCoordinator clusterCoordinator) {
        return clusterCoordinator.open().thenApply(v -> null);
    }
}

