/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.test;

import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jodah.concurrentunit.ConcurrentTestCase;
import net.kuujo.copycat.cluster.Cluster;
import net.kuujo.copycat.cluster.ClusterConfig;
import net.kuujo.copycat.cluster.MembershipEvent;
import net.kuujo.copycat.cluster.internal.coordinator.ClusterCoordinator;
import net.kuujo.copycat.cluster.internal.coordinator.CoordinatorConfig;
import net.kuujo.copycat.cluster.internal.coordinator.DefaultClusterCoordinator;
import net.kuujo.copycat.log.BufferedLog;
import net.kuujo.copycat.log.Log;
import net.kuujo.copycat.protocol.Protocol;
import net.kuujo.copycat.protocol.ProtocolClient;
import net.kuujo.copycat.protocol.ProtocolServer;
import net.kuujo.copycat.test.TestCluster;
import net.kuujo.copycat.test.TestResource;
import org.testng.annotations.Test;

@Test
public abstract class ProtocolTest
extends ConcurrentTestCase {
    protected abstract Protocol createProtocol();

    protected abstract String createUri(int var1);

    private TestResource createTestResource(ClusterConfig cluster) {
        DefaultClusterCoordinator coordinator = new DefaultClusterCoordinator(new CoordinatorConfig().withName("test").withClusterConfig(cluster));
        return (TestResource)((TestResource)((TestResource)coordinator.getResource("test", ((TestResource.Config)new TestResource.Config().withLog((Log)new BufferedLog())).resolve(cluster))).addStartupTask(() -> ProtocolTest.lambda$createTestResource$cbfc3e4$1((ClusterCoordinator)coordinator))).addShutdownTask(() -> ((ClusterCoordinator)coordinator).close());
    }

    private TestCluster<TestResource> createTestCluster() {
        return TestCluster.builder().withActiveMembers(3).withPassiveMembers(2).withUriFactory(this::createUri).withClusterFactory(members -> new ClusterConfig().withProtocol(this.createProtocol()).withMembers(members)).withResourceFactory(this::createTestResource).build();
    }

    public void testClusterJoinActiveMember() throws Throwable {
        TestCluster<TestResource> test = this.createTestCluster();
        TestResource active = test.activeResources().iterator().next();
        TestResource passive = test.passiveResources().iterator().next();
        this.expectResume();
        Cluster cluster = active.cluster();
        cluster.addMembershipListener(event -> {
            if (event.member().uri().equals(passive.cluster().member().uri())) {
                this.threadAssertTrue(event.type() == MembershipEvent.Type.JOIN);
                this.resume();
            }
        });
        test.open();
        this.await();
        test.close().get();
    }

    public void testClusterJoinPassiveMember() throws Throwable {
        TestCluster<TestResource> test = this.createTestCluster();
        Iterator<TestResource> iterator = test.passiveResources().iterator();
        TestResource passive1 = iterator.next();
        TestResource passive2 = iterator.next();
        this.expectResume();
        Cluster cluster = passive1.cluster();
        cluster.addMembershipListener(event -> {
            if (event.member().uri().equals(passive2.cluster().member().uri())) {
                this.threadAssertTrue(event.type() == MembershipEvent.Type.JOIN);
                this.resume();
            }
        });
        test.open();
        this.await();
        test.close().get();
    }

    public void testClusterLeaveActiveMember() throws Throwable {
        TestCluster<TestResource> test = this.createTestCluster();
        TestResource active = test.activeResources().iterator().next();
        TestResource passive = test.passiveResources().iterator().next();
        AtomicBoolean joined = new AtomicBoolean();
        this.expectResume();
        Cluster cluster = active.cluster();
        cluster.addMembershipListener(event -> {
            if (event.type() == MembershipEvent.Type.JOIN && event.member().uri().equals(passive.cluster().member().uri())) {
                this.threadAssertTrue(joined.compareAndSet(false, true));
            } else if (event.type() == MembershipEvent.Type.LEAVE && event.member().uri().equals(passive.cluster().member().uri())) {
                this.threadAssertTrue(joined.get());
                this.resume();
            }
        });
        test.open().thenRun(passive::close);
        this.await(10000L);
        test.close().get();
    }

    public void testClusterLeavePassiveMember() throws Throwable {
        TestCluster<TestResource> test = this.createTestCluster();
        Iterator<TestResource> iterator = test.passiveResources().iterator();
        TestResource passive1 = iterator.next();
        TestResource passive2 = iterator.next();
        AtomicBoolean joined = new AtomicBoolean();
        this.expectResume();
        Cluster cluster = passive1.cluster();
        cluster.addMembershipListener(event -> {
            if (event.type() == MembershipEvent.Type.JOIN && event.member().uri().equals(passive2.cluster().member().uri())) {
                this.threadAssertTrue(joined.compareAndSet(false, true));
            } else if (event.type() == MembershipEvent.Type.LEAVE && event.member().uri().equals(passive2.cluster().member().uri())) {
                this.threadAssertTrue(joined.get());
                this.resume();
            }
        });
        test.open().thenRun(passive2::close);
        this.await(15000L);
        test.close().get();
    }

    public void testSendReceive() throws Throwable {
        Protocol protocol = this.createProtocol();
        String uri = this.createUri(1);
        ProtocolServer server = protocol.createServer(new URI(uri));
        ProtocolClient client = protocol.createClient(new URI(uri));
        server.handler(buffer -> {
            byte[] bytes = new byte[buffer.remaining()];
            buffer.get(bytes);
            this.threadAssertEquals(new String(bytes), "Hello world!");
            return CompletableFuture.completedFuture(ByteBuffer.wrap("Hello world back!".getBytes()));
        });
        server.listen().thenRunAsync(() -> ((ProtocolTest)this).resume());
        this.await(5000L);
        client.connect().thenRunAsync(() -> ((ProtocolTest)this).resume());
        this.await(5000L);
        this.expectResume();
        client.write(ByteBuffer.wrap("Hello world!".getBytes())).thenAcceptAsync(buffer -> {
            byte[] bytes = new byte[buffer.remaining()];
            buffer.get(bytes);
            this.threadAssertEquals(new String(bytes), "Hello world back!");
            this.resume();
        });
        this.await(5000L);
        this.expectResume();
        client.write(ByteBuffer.wrap("Hello world!".getBytes())).thenAcceptAsync(buffer -> {
            byte[] bytes = new byte[buffer.remaining()];
            buffer.get(bytes);
            this.threadAssertEquals(new String(bytes), "Hello world back!");
            this.resume();
        });
        this.await(5000L);
        this.expectResume();
        client.write(ByteBuffer.wrap("Hello world!".getBytes())).thenAcceptAsync(buffer -> {
            byte[] bytes = new byte[buffer.remaining()];
            buffer.get(bytes);
            this.threadAssertEquals(new String(bytes), "Hello world back!");
            this.resume();
        });
        this.await(5000L);
        this.expectResume();
        client.close().thenRunAsync(() -> ((ProtocolTest)this).resume());
        this.await(2500L);
        this.expectResume();
        server.close().thenRunAsync(() -> ((ProtocolTest)this).resume());
        this.await(2500L);
    }

    private static /* synthetic */ CompletableFuture lambda$createTestResource$cbfc3e4$1(ClusterCoordinator clusterCoordinator) {
        return clusterCoordinator.open().thenApply(v -> null);
    }
}

