/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.kuujo.copycat.cluster.ClusterConfig;
import net.kuujo.copycat.protocol.LocalProtocol;
import net.kuujo.copycat.resource.Resource;

public class TestCluster<T extends Resource<T>> {
    private static int id;
    private final List<T> activeResources;
    private final List<T> passiveResources;

    private TestCluster(List<T> activeResources, List<T> passiveResources) {
        this.activeResources = activeResources;
        this.passiveResources = passiveResources;
    }

    public static <T extends Resource<T>> Builder<T> builder() {
        return new Builder();
    }

    public List<T> activeResources() {
        return this.activeResources;
    }

    public List<T> passiveResources() {
        return this.passiveResources;
    }

    public CompletableFuture<Void> open() {
        CompletableFuture[] futures = new CompletableFuture[this.activeResources.size() + this.passiveResources.size()];
        int i = 0;
        for (Resource resource : this.activeResources) {
            futures[i++] = ((CompletableFuture)resource.open().thenRun(() -> System.out.println(resource.cluster().member().uri() + " started successfully!"))).thenApply(v -> null);
        }
        for (Resource resource : this.passiveResources) {
            futures[i++] = ((CompletableFuture)resource.open().thenRun(() -> System.out.println(resource.cluster().member().uri() + " started successfully!"))).thenApply(v -> null);
        }
        return CompletableFuture.allOf(futures);
    }

    public CompletableFuture<Void> close() {
        CompletableFuture[] futures = new CompletableFuture[this.activeResources.size() + this.passiveResources.size()];
        int i = 0;
        for (Resource resource : this.passiveResources) {
            futures[i++] = resource.close();
        }
        for (Resource resource : this.activeResources) {
            futures[i++] = resource.close();
        }
        return CompletableFuture.allOf(futures);
    }

    public static class Builder<T extends Resource<T>> {
        private int activeMembers = 3;
        private int passiveMembers = 2;
        private Function<Integer, String> uriFactory;
        private Function<Collection<String>, ClusterConfig> clusterFactory;
        private Function<ClusterConfig, T> resourceFactory;

        public Builder<T> withActiveMembers(int activeMembers) {
            this.activeMembers = activeMembers;
            return this;
        }

        public Builder<T> withPassiveMembers(int passiveMembers) {
            this.passiveMembers = passiveMembers;
            return this;
        }

        public Builder<T> withUriFactory(Function<Integer, String> uriFactory) {
            this.uriFactory = uriFactory;
            return this;
        }

        public Builder<T> withClusterFactory(Function<Collection<String>, ClusterConfig> clusterFactory) {
            this.clusterFactory = clusterFactory;
            return this;
        }

        public Builder<T> withResourceFactory(Function<ClusterConfig, T> resourceFactory) {
            this.resourceFactory = resourceFactory;
            return this;
        }

        public TestCluster<T> build() {
            LocalProtocol.reset();
            ArrayList<T> activeResources = new ArrayList<T>(this.activeMembers);
            HashSet<Object> members = new HashSet<Object>(this.activeMembers);
            int activeCount = this.activeMembers + id;
            while (id <= activeCount) {
                String uri = this.uriFactory.apply(id++);
                members.add(uri);
            }
            for (String string : members) {
                ClusterConfig cluster = this.clusterFactory.apply(members).withLocalMember(string);
                activeResources.add(this.resourceFactory.apply(cluster));
            }
            ArrayList<T> passiveResources = new ArrayList<T>(this.passiveMembers);
            int n = this.passiveMembers + id;
            while (id <= n) {
                String member = this.uriFactory.apply(id++);
                ClusterConfig cluster = this.clusterFactory.apply(members).withLocalMember(member);
                passiveResources.add(this.resourceFactory.apply(cluster));
            }
            return new TestCluster(activeResources, passiveResources);
        }
    }
}

