/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.vertx;

import com.typesafe.config.ConfigValueFactory;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import java.net.URI;
import java.util.Map;
import net.kuujo.copycat.protocol.AbstractProtocol;
import net.kuujo.copycat.protocol.ProtocolClient;
import net.kuujo.copycat.protocol.ProtocolServer;
import net.kuujo.copycat.util.internal.Assert;
import net.kuujo.copycat.vertx.VertxEventBusProtocolClient;
import net.kuujo.copycat.vertx.VertxEventBusProtocolServer;

public class VertxEventBusProtocol
extends AbstractProtocol {
    private static final String VERTX_HOST = "host";
    private static final String VERTX_PORT = "port";
    private static final String CONFIGURATION = "eventbus";
    private static final String DEFAULT_CONFIGURATION = "eventbus-defaults";
    private static Vertx vertx;

    public VertxEventBusProtocol() {
        super(new String[]{CONFIGURATION, DEFAULT_CONFIGURATION});
    }

    public VertxEventBusProtocol(String resource) {
        super(new String[]{resource, CONFIGURATION, DEFAULT_CONFIGURATION});
    }

    public VertxEventBusProtocol(Map<String, Object> config) {
        super(config, new String[]{CONFIGURATION, DEFAULT_CONFIGURATION});
    }

    public VertxEventBusProtocol(String host, int port) {
        this();
        this.setHost(host);
        this.setPort(port);
    }

    public VertxEventBusProtocol(Vertx vertx) {
        this();
        this.setVertx(vertx);
    }

    public VertxEventBusProtocol copy() {
        return (VertxEventBusProtocol)super.copy();
    }

    public void setVertx(Vertx vertx) {
        VertxEventBusProtocol.vertx = vertx;
    }

    public Vertx getVertx() {
        return vertx;
    }

    public VertxEventBusProtocol withVertx(Vertx vertx) {
        this.setVertx(vertx);
        return this;
    }

    public void setHost(String host) {
        this.config = this.config.withValue(VERTX_HOST, ConfigValueFactory.fromAnyRef((Object)Assert.isNotNull((Object)host, (String)VERTX_HOST)));
    }

    public String getHost() {
        return this.config.getString(VERTX_HOST);
    }

    public VertxEventBusProtocol withHost(String host) {
        this.setHost(host);
        return this;
    }

    public void setPort(int port) {
        this.config = this.config.withValue(VERTX_PORT, ConfigValueFactory.fromAnyRef((Object)Assert.arg((Object)port, (port > -1 ? 1 : 0) != 0, (String)"port must be positive", (Object[])new Object[0])));
    }

    public int getPort() {
        return this.config.getInt(VERTX_PORT);
    }

    public VertxEventBusProtocol withPort(int port) {
        this.setPort(port);
        return this;
    }

    private Vertx createVertx() {
        VertxOptions options = new VertxOptions();
        options.setClusterPort(this.getPort());
        options.setClusterHost(this.getHost());
        Vertx vertx = Vertx.vertx((VertxOptions)options);
        this.setVertx(vertx);
        return vertx;
    }

    public synchronized ProtocolServer createServer(URI uri) {
        Vertx vertx = this.getVertx();
        if (vertx != null) {
            return new VertxEventBusProtocolServer(uri.getAuthority(), vertx);
        }
        return new VertxEventBusProtocolServer(uri.getAuthority(), this.createVertx());
    }

    public synchronized ProtocolClient createClient(URI uri) {
        Vertx vertx = this.getVertx();
        if (vertx != null) {
            return new VertxEventBusProtocolClient(uri.getAuthority(), vertx);
        }
        return new VertxEventBusProtocolClient(uri.getAuthority(), this.createVertx());
    }

    public String toString() {
        return String.format("EventBusProtocol[host=%s, port=%d]", this.getHost(), this.getPort());
    }
}

