/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.vertx;

import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.ReplyException;
import io.vertx.core.eventbus.ReplyFailure;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import net.kuujo.copycat.CopycatException;
import net.kuujo.copycat.protocol.ProtocolClient;
import net.kuujo.copycat.protocol.ProtocolException;
import net.kuujo.copycat.util.internal.Assert;

public class VertxEventBusProtocolClient
implements ProtocolClient {
    private final String address;
    private final Vertx vertx;
    private final Context context;

    public VertxEventBusProtocolClient(String address, Vertx vertx) {
        this.address = (String)Assert.isNotNull((Object)address, (String)"Vert.x event bus address cannot be null");
        this.vertx = (Vertx)Assert.isNotNull((Object)vertx, (String)"Vert.x instance cannot be null");
        this.context = vertx.getOrCreateContext();
    }

    public CompletableFuture<ByteBuffer> write(ByteBuffer request) {
        CompletableFuture<ByteBuffer> future = new CompletableFuture<ByteBuffer>();
        this.context.runOnContext(v -> {
            DeliveryOptions options = new DeliveryOptions().setSendTimeout(5000L);
            byte[] bytes = new byte[request.remaining()];
            request.get(bytes);
            this.vertx.eventBus().send(this.address, (Object)bytes, options, result -> {
                if (result.succeeded()) {
                    future.complete(ByteBuffer.wrap((byte[])((Message)result.result()).body()));
                } else {
                    ReplyException exception = (ReplyException)result.cause();
                    if (exception.failureType() == ReplyFailure.NO_HANDLERS || exception.failureType() == ReplyFailure.TIMEOUT) {
                        future.completeExceptionally((Throwable)new ProtocolException((Throwable)exception));
                    } else {
                        future.completeExceptionally((Throwable)new CopycatException(exception.getMessage(), new Object[0]));
                    }
                }
            });
        });
        return future;
    }

    public CompletableFuture<Void> connect() {
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> close() {
        return CompletableFuture.completedFuture(null);
    }

    public String toString() {
        return String.format("%s[address=%s]", this.getClass().getSimpleName(), this.address);
    }
}

