/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.vertx;

import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.eventbus.ReplyFailure;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import net.kuujo.copycat.protocol.ProtocolHandler;
import net.kuujo.copycat.protocol.ProtocolServer;

public class VertxEventBusProtocolServer
implements ProtocolServer,
Handler<Message<byte[]>> {
    private final String address;
    private final Vertx vertx;
    private final Context context;
    private MessageConsumer<byte[]> consumer;
    private ProtocolHandler handler;

    public VertxEventBusProtocolServer(String address, Vertx vertx) {
        this.address = address;
        this.vertx = vertx;
        this.context = vertx.getOrCreateContext();
    }

    public void handle(Message<byte[]> message) {
        if (this.handler != null) {
            ((CompletableFuture)this.handler.apply((Object)ByteBuffer.wrap((byte[])message.body()))).whenComplete((reply, error) -> this.context.runOnContext(v -> {
                if (error != null) {
                    message.fail(0, error.getMessage());
                } else {
                    byte[] bytes = new byte[reply.remaining()];
                    reply.get(bytes);
                    message.reply((Object)bytes);
                }
            }));
        } else {
            message.fail(ReplyFailure.NO_HANDLERS.toInt(), "No message handler registered");
        }
    }

    public void handler(ProtocolHandler handler) {
        this.handler = handler;
    }

    public CompletableFuture<Void> listen() {
        this.consumer = this.vertx.eventBus().consumer(this.address).handler((Handler)this);
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> close() {
        if (this.consumer != null) {
            this.consumer.unregister();
        }
        return CompletableFuture.completedFuture(null);
    }

    public String toString() {
        return String.format("%s[address=%s]", this.getClass().getSimpleName(), this.address);
    }
}

