/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.vertx;

import com.typesafe.config.ConfigValueFactory;
import io.vertx.core.Vertx;
import java.net.URI;
import java.util.Map;
import net.kuujo.copycat.protocol.AbstractProtocol;
import net.kuujo.copycat.protocol.ProtocolClient;
import net.kuujo.copycat.protocol.ProtocolServer;
import net.kuujo.copycat.util.internal.Assert;
import net.kuujo.copycat.vertx.VertxTcpProtocolClient;
import net.kuujo.copycat.vertx.VertxTcpProtocolServer;

public class VertxTcpProtocol
extends AbstractProtocol {
    private static final String VERTX_TCP_SEND_BUFFER_SIZE = "send.buffer.size";
    private static final String VERTX_TCP_RECEIVE_BUFFER_SIZE = "receive.buffer.size";
    private static final String VERTX_TCP_USE_SSL = "ssl.enabled";
    private static final String VERTX_TCP_CLIENT_TRUST_ALL = "ssl.trust-all";
    private static final String VERTX_TCP_CLIENT_AUTH_REQUIRED = "ssl.auth-required";
    private static final String VERTX_TCP_ACCEPT_BACKLOG = "accept.backlog";
    private static final String VERTX_TCP_CONNECT_TIMEOUT = "connect.timeout";
    private static final String CONFIGURATION = "tcp";
    private static final String DEFAULT_CONFIGURATION = "tcp-defaults";
    private static Vertx vertx;

    public VertxTcpProtocol() {
        super(new String[]{CONFIGURATION, DEFAULT_CONFIGURATION});
    }

    public VertxTcpProtocol(Vertx vertx) {
        this();
        this.setVertx(vertx);
    }

    public VertxTcpProtocol(Map<String, Object> config) {
        super(config, new String[]{CONFIGURATION, DEFAULT_CONFIGURATION});
    }

    public VertxTcpProtocol(String resource) {
        super(new String[]{resource, CONFIGURATION, DEFAULT_CONFIGURATION});
    }

    public VertxTcpProtocol copy() {
        return (VertxTcpProtocol)super.copy();
    }

    public void setVertx(Vertx vertx) {
        VertxTcpProtocol.vertx = vertx;
    }

    public Vertx getVertx() {
        return vertx;
    }

    public VertxTcpProtocol withVertx(Vertx vertx) {
        this.setVertx(vertx);
        return this;
    }

    public void setSendBufferSize(int bufferSize) {
        this.config = this.config.withValue(VERTX_TCP_SEND_BUFFER_SIZE, ConfigValueFactory.fromAnyRef((Object)Assert.arg((Object)bufferSize, (bufferSize > 0 ? 1 : 0) != 0, (String)"buffer size must be positive", (Object[])new Object[0])));
    }

    public int getSendBufferSize() {
        return this.config.getInt(VERTX_TCP_SEND_BUFFER_SIZE);
    }

    public VertxTcpProtocol withSendBufferSize(int bufferSize) {
        this.setSendBufferSize(bufferSize);
        return this;
    }

    public void setReceiveBufferSize(int bufferSize) {
        this.config = this.config.withValue(VERTX_TCP_RECEIVE_BUFFER_SIZE, ConfigValueFactory.fromAnyRef((Object)Assert.arg((Object)bufferSize, (bufferSize > 0 ? 1 : 0) != 0, (String)"buffer size must be positive", (Object[])new Object[0])));
    }

    public int getReceiveBufferSize() {
        return this.config.getInt(VERTX_TCP_RECEIVE_BUFFER_SIZE);
    }

    public VertxTcpProtocol withReceiveBufferSize(int bufferSize) {
        this.setReceiveBufferSize(bufferSize);
        return this;
    }

    public void setSsl(boolean useSsl) {
        this.config = this.config.withValue(VERTX_TCP_USE_SSL, ConfigValueFactory.fromAnyRef((Object)useSsl));
    }

    public boolean isSsl() {
        return this.config.getBoolean(VERTX_TCP_USE_SSL);
    }

    public VertxTcpProtocol withSsl(boolean useSsl) {
        this.setSsl(useSsl);
        return this;
    }

    public void setClientTrustAll(boolean trustAll) {
        this.config = this.config.withValue(VERTX_TCP_CLIENT_TRUST_ALL, ConfigValueFactory.fromAnyRef((Object)trustAll));
    }

    public boolean isClientTrustAll() {
        return this.config.getBoolean(VERTX_TCP_CLIENT_TRUST_ALL);
    }

    public VertxTcpProtocol withClientTrustAll(boolean trustAll) {
        this.setClientTrustAll(trustAll);
        return this;
    }

    public void setClientAuthRequired(boolean required) {
        this.config = this.config.withValue(VERTX_TCP_CLIENT_AUTH_REQUIRED, ConfigValueFactory.fromAnyRef((Object)required));
    }

    public boolean isClientAuthRequired() {
        return this.config.getBoolean(VERTX_TCP_CLIENT_AUTH_REQUIRED);
    }

    public VertxTcpProtocol withClientAuthRequired(boolean required) {
        this.setClientAuthRequired(required);
        return this;
    }

    public void setAcceptBacklog(int backlog) {
        this.config = this.config.withValue(VERTX_TCP_ACCEPT_BACKLOG, ConfigValueFactory.fromAnyRef((Object)Assert.arg((Object)backlog, (backlog > -1 ? 1 : 0) != 0, (String)"backlog must be positive", (Object[])new Object[0])));
    }

    public int getAcceptBacklog() {
        return this.config.getInt(VERTX_TCP_ACCEPT_BACKLOG);
    }

    public VertxTcpProtocol withAcceptBacklog(int backlog) {
        this.setAcceptBacklog(backlog);
        return this;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.config = this.config.withValue(VERTX_TCP_CONNECT_TIMEOUT, ConfigValueFactory.fromAnyRef((Object)Assert.arg((Object)connectTimeout, (connectTimeout > 0 ? 1 : 0) != 0, (String)"connect timeout must be greater than zero", (Object[])new Object[0])));
    }

    public int getConnectTimeout() {
        return this.config.getInt(VERTX_TCP_CONNECT_TIMEOUT);
    }

    public VertxTcpProtocol withConnectTimeout(int connectTimeout) {
        this.setConnectTimeout(connectTimeout);
        return this;
    }

    public ProtocolServer createServer(URI uri) {
        return new VertxTcpProtocolServer(uri.getHost(), uri.getPort(), this);
    }

    public ProtocolClient createClient(URI uri) {
        return new VertxTcpProtocolClient(uri.getHost(), uri.getPort(), this);
    }
}

