/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.vertx;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.parsetools.RecordParser;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.kuujo.copycat.protocol.ProtocolClient;
import net.kuujo.copycat.protocol.ProtocolException;
import net.kuujo.copycat.vertx.VertxTcpProtocol;

public class VertxTcpProtocolClient
implements ProtocolClient {
    private Vertx vertx;
    private final String host;
    private final int port;
    private final VertxTcpProtocol protocol;
    private NetClient client;
    private NetSocket socket;
    private final Map<Object, ResponseHolder> responses = new HashMap<Object, ResponseHolder>(1000);
    private long requestId;

    public VertxTcpProtocolClient(String host, int port, VertxTcpProtocol protocol) {
        this.host = host;
        this.port = port;
        this.protocol = protocol;
    }

    public CompletableFuture<ByteBuffer> write(ByteBuffer request) {
        CompletableFuture<ByteBuffer> future = new CompletableFuture<ByteBuffer>();
        if (this.socket != null) {
            long requestId = this.requestId++;
            byte[] bytes = new byte[request.remaining()];
            request.get(bytes);
            this.socket.write(Buffer.buffer().appendInt(bytes.length).appendLong(requestId).appendBytes(bytes));
            this.storeFuture(requestId, future);
        } else {
            future.completeExceptionally((Throwable)new ProtocolException("Client not connected", new Object[0]));
        }
        return future;
    }

    private void handleResponse(long id, ByteBuffer response) {
        ResponseHolder holder = this.responses.remove(id);
        if (holder != null) {
            this.vertx.cancelTimer(holder.timer);
            holder.future.complete(response);
        }
    }

    private void handleError(long id, Throwable error) {
        ResponseHolder holder = this.responses.remove(id);
        if (holder != null) {
            this.vertx.cancelTimer(holder.timer);
            holder.future.completeExceptionally(error);
        }
    }

    private void storeFuture(long id, CompletableFuture<ByteBuffer> future) {
        long timerId = this.vertx.setTimer(5000L, timer -> this.handleError(id, (Throwable)new ProtocolException("Request timed out", new Object[0])));
        ResponseHolder holder = new ResponseHolder(timerId, future);
        this.responses.put(id, holder);
    }

    public CompletableFuture<Void> connect() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (this.vertx == null) {
            this.vertx = this.protocol.getVertx();
        }
        if (this.vertx == null) {
            this.vertx = Vertx.vertx();
        }
        if (this.client == null) {
            NetClientOptions options = new NetClientOptions().setTcpKeepAlive(true).setTcpNoDelay(true).setSendBufferSize(this.protocol.getSendBufferSize()).setReceiveBufferSize(this.protocol.getReceiveBufferSize()).setSsl(this.protocol.isSsl()).setTrustAll(this.protocol.isClientTrustAll()).setUsePooledBuffers(true);
            this.client = this.vertx.createNetClient(options);
            this.client.connect(this.port, this.host, result -> {
                if (result.failed()) {
                    future.completeExceptionally(result.cause());
                } else {
                    this.socket = (NetSocket)result.result();
                    final RecordParser parser = RecordParser.newFixed((int)4, null);
                    Handler<Buffer> handler = new Handler<Buffer>(){
                        int length = -1;

                        public void handle(Buffer buffer) {
                            if (this.length == -1) {
                                this.length = buffer.getInt(0);
                                parser.fixedSizeMode(this.length + 8);
                            } else {
                                VertxTcpProtocolClient.this.handleResponse(buffer.getLong(0), buffer.getBuffer(8, this.length + 8).getByteBuf().nioBuffer());
                                this.length = -1;
                                parser.fixedSizeMode(4);
                            }
                        }
                    };
                    parser.setOutput((Handler)handler);
                    this.socket.handler((Handler)parser);
                    future.complete(null);
                }
            });
        } else {
            future.complete(null);
        }
        return future;
    }

    public CompletableFuture<Void> close() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (this.client != null) {
            this.client.close();
            this.client = null;
            future.complete(null);
        } else {
            future.complete(null);
        }
        return future;
    }

    public String toString() {
        return String.format("%s[host=%s, port=%d]", this.getClass().getSimpleName(), this.host, this.port);
    }

    private static class ResponseHolder {
        private final CompletableFuture<ByteBuffer> future;
        private final long timer;

        private ResponseHolder(long timerId, CompletableFuture<ByteBuffer> future) {
            this.timer = timerId;
            this.future = future;
        }
    }
}

