/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.vertx;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.parsetools.RecordParser;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import net.kuujo.copycat.protocol.ProtocolHandler;
import net.kuujo.copycat.protocol.ProtocolServer;
import net.kuujo.copycat.vertx.VertxTcpProtocol;

public class VertxTcpProtocolServer
implements ProtocolServer {
    private Vertx vertx = Vertx.vertx();
    private final String host;
    private final int port;
    private final VertxTcpProtocol protocol;
    private NetServer server;
    private ProtocolHandler handler;

    public VertxTcpProtocolServer(String host, int port, VertxTcpProtocol protocol) {
        this.host = host;
        this.port = port;
        this.protocol = protocol;
    }

    public void handler(ProtocolHandler handler) {
        this.handler = handler;
    }

    public CompletableFuture<Void> listen() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (this.vertx == null) {
            this.vertx = this.protocol.getVertx();
        }
        if (this.vertx == null) {
            this.vertx = Vertx.vertx();
        }
        if (this.server == null) {
            NetServerOptions options = new NetServerOptions().setTcpKeepAlive(true).setTcpNoDelay(true).setReuseAddress(true).setAcceptBacklog(this.protocol.getAcceptBacklog()).setSendBufferSize(this.protocol.getSendBufferSize()).setReceiveBufferSize(this.protocol.getReceiveBufferSize()).setSsl(this.protocol.isSsl()).setClientAuthRequired(this.protocol.isClientAuthRequired()).setUsePooledBuffers(true);
            this.server = this.vertx.createNetServer(options);
            this.server.connectHandler(socket -> {
                final RecordParser parser = RecordParser.newFixed((int)4, null);
                Handler<Buffer> handler = new Handler<Buffer>(){
                    int length = -1;

                    public void handle(Buffer buffer) {
                        if (this.length == -1) {
                            this.length = buffer.getInt(0);
                            parser.fixedSizeMode(this.length + 8);
                        } else {
                            VertxTcpProtocolServer.this.handleRequest(buffer.getLong(0), socket, buffer.getBuffer(8, this.length + 8).getByteBuf().nioBuffer());
                            this.length = -1;
                            parser.fixedSizeMode(4);
                        }
                    }
                };
                parser.setOutput((Handler)handler);
                socket.handler((Handler)parser);
            }).listen(this.port, this.host, result -> {
                if (result.failed()) {
                    future.completeExceptionally(result.cause());
                } else {
                    future.complete(null);
                }
            });
        } else {
            future.complete(null);
        }
        return future;
    }

    private void handleRequest(long id, NetSocket socket, ByteBuffer request) {
        if (this.handler != null) {
            ((CompletableFuture)this.handler.apply((Object)request)).whenComplete((response, error) -> {
                if (error == null) {
                    this.respond(socket, id, (ByteBuffer)response);
                }
            });
        }
    }

    private void respond(NetSocket socket, long id, ByteBuffer response) {
        int length = response.remaining();
        byte[] bytes = new byte[length];
        response.get(bytes);
        socket.write(Buffer.buffer().appendInt(length).appendLong(id).appendBytes(bytes));
    }

    public CompletableFuture<Void> close() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (this.server != null) {
            this.server.close(result -> {
                if (result.failed()) {
                    future.completeExceptionally(result.cause());
                } else {
                    future.complete(null);
                }
            });
        } else {
            future.complete(null);
        }
        return future;
    }

    public String toString() {
        return String.format("%s[host=%s, port=%d]", this.getClass().getSimpleName(), this.host, this.port);
    }
}

