package com.tailf.jnc;

import org.xml.sax.InputSource;

/**
 * A SAX parser, for parsing for example NETCONF messages, into a simple
 * {@link YangElement YangElement} tree.
 * <p>
 * This parser is data model aware and will try to construct classes that are
 * generated by the JNC pyang plugin.
 * <p>
 */
public class YangXMLParser extends XMLParser {

    /**
     * Constructor. Initializes the parser instance.
     */
    public YangXMLParser() throws JNCException {
        super();
    }

    /**
     * Read in an XML file, parse it using an ElementHandler as content
     * handler, and return the parsed YangElement tree.
     */
    @Override
    public YangElement readFile(String filename) throws JNCException {
        try {
            final ElementHandler handler = new ElementHandler();
            parser.setContentHandler(handler);
            parser.parse(filename);
            return (YangElement) handler.top;
        } catch (final Exception e) {
            throw new JNCException(JNCException.PARSER_ERROR, "parse file: "
                    + filename + " error: " + e);
        }
    }

    /**
     * Parses an XML string returning a configuration tree from it,
     * instantiating an ElementHandler to use as content handler.
     * 
     * @param is Input source (byte stream) where the XML text is read from
     */
    @Override
    public Element parse(InputSource is) throws JNCException {
        try {
            final ElementHandler handler = new ElementHandler();
            parser.setContentHandler(handler);
            parser.parse(is);
            return handler.top;
        } catch (final Exception e) {
            e.printStackTrace();
            throw new JNCException(JNCException.PARSER_ERROR, "parse error: "
                    + e);
        }
    }

}
