/*
 * Decompiled with CFR 0.152.
 */
package com.tailf.jnc;

import com.tailf.jnc.Element;
import com.tailf.jnc.JNCException;
import com.tailf.jnc.NodeSet;
import java.util.ArrayList;

public class Capabilities {
    public static final String NS_NETCONF = "urn:ietf:params:xml:ns:netconf:base:1.0";
    public static final String URN_IETF_PARAMS_XML_NS_NETCONF = "urn:ietf:params:xml:ns:netconf:";
    public static final String NS_NOTIFICATION = "urn:ietf:params:xml:ns:netconf:notification:1.0";
    public static final String NS_PARTIAL_LOCK = "urn:ietf:params:xml:ns:netconf:partial-lock:1.0";
    public static final String URN_IETF_PARAMS = "urn:ietf:params:";
    public static final String NETCONF_BASE_CAPABILITY = "urn:ietf:params:netconf:base:1.0";
    public static final String WRITABLE_RUNNING_CAPABILITY = "urn:ietf:params:netconf:capability:writable-running:1.0";
    public static final String URN_IETF_PARAMS_NETCONF = "urn:ietf:params:netconf:";
    public static final String CANDIDATE_CAPABILITY = "urn:ietf:params:netconf:capability:candidate:1.0";
    public static final String CONFIRMED_COMMIT_CAPABILITY = "urn:ietf:params:netconf:capability:confirmed-commit:1.0";
    public static final String ROLLBACK_ON_ERROR_CAPABILITY = "urn:ietf:params:netconf:capability:rollback-on-error:1.0";
    public static final String VALIDATE_CAPABILITY = "urn:ietf:params:netconf:capability:validate:1.0";
    public static final String STARTUP_CAPABILITY = "urn:ietf:params:netconf:capability:startup:1.0";
    public static final String URL_CAPABILITY = "urn:ietf:params:netconf:capability:url:1.0";
    public static final String URL_CAPABILITY_SCHEME = "urn:ietf:params:netconf:capability:url:1.0?scheme=";
    public static final String XPATH_CAPABILITY = "urn:ietf:params:netconf:capability:xpath:1.0";
    public static final String NOTIFICATION_CAPABILITY = "urn:ietf:params:netconf:capability:notification:1.0";
    public static final String INTERLEAVE_CAPABILITY = "urn:ietf:params:netconf:capability:interleave:1.0";
    public static final String PARTIAL_LOCK_CAPABILITY = "urn:ietf:params:netconf:capability:partial-lock:1.0";
    public static final String HTTP_TAIL_F_COM = "http://tail-f.com/";
    public static final String NS_ACTIONS = "http://tail-f.com/ns/netconf/actions/1.0";
    public static final String NS_TRANSACTIONS = "http://tail-f.com/ns/netconf/transactions/1.0";
    public static final String ACTIONS_CAPABILITY = "http://tail-f.com/ns/netconf/actions/1.0";
    public static final String TRANSACTIONS_CAPABILITY = "http://tail-f.com/ns/netconf/transactions/1.0";
    public static final String WITH_DEFAULTS_CAPABILITY = "http://tail-f.com/ns/netconf/with-defaults/1.0";
    protected boolean baseCapability = false;
    protected boolean writableRunningCapability = false;
    protected boolean candidateCapability = false;
    protected boolean confirmedCommitCapability = false;
    protected boolean rollbackOnErrorCapability = false;
    protected boolean validateCapability = false;
    protected boolean startupCapability = false;
    protected boolean notificationCapability = false;
    protected boolean interleaveCapability = false;
    protected boolean urlCapability = false;
    protected boolean xpathCapability = false;
    protected boolean partialLockCapability = false;
    protected boolean actionsCapability = false;
    protected boolean transactionsCapability = false;
    protected boolean withDefaultsCapability = false;
    protected String[] urlSchemes;
    private final ArrayList<Capa> capas;
    private final ArrayList<Capa> data_capas;

    public boolean hasWritableRunning() {
        return this.writableRunningCapability;
    }

    public boolean hasCandidate() {
        return this.candidateCapability;
    }

    public boolean hasConfirmedCommit() {
        return this.confirmedCommitCapability;
    }

    public boolean hasRollbackOnError() {
        return this.rollbackOnErrorCapability;
    }

    public boolean hasValidate() {
        return this.validateCapability;
    }

    public boolean hasStartup() {
        return this.startupCapability;
    }

    public boolean hasNotification() {
        return this.notificationCapability;
    }

    public boolean hasInterleave() {
        return this.interleaveCapability;
    }

    public boolean hasUrl() {
        return this.urlCapability;
    }

    public String[] urlSchemes() {
        return this.urlSchemes;
    }

    public boolean hasXPath() {
        return this.xpathCapability;
    }

    public boolean hasPartialLock() {
        return this.partialLockCapability;
    }

    public boolean hasActions() {
        return this.actionsCapability;
    }

    public boolean hasTransactions() {
        return this.transactionsCapability;
    }

    public boolean hasWithDefaults() {
        return this.withDefaultsCapability;
    }

    public String[] getUrlSchemes() {
        return this.urlSchemes;
    }

    protected Capabilities(Element element) throws JNCException {
        NodeSet nodeSet = element.get("capability");
        this.capas = new ArrayList(nodeSet.size());
        this.data_capas = new ArrayList(nodeSet.size());
        for (int i = 0; i < nodeSet.size(); ++i) {
            String string;
            Element element2 = nodeSet.getElement(i);
            String[] stringArray = element2.value.toString().split("\\?");
            String string2 = null;
            String string3 = stringArray[0];
            if (stringArray.length == 2) {
                String[] stringArray2;
                string = stringArray[1];
                for (String string4 : stringArray2 = string.split("&")) {
                    String[] stringArray3 = string4.split("=");
                    if (!stringArray3[0].equals("revision")) continue;
                    string2 = stringArray3[1];
                }
            }
            this.capas.add(new Capa(string3, string2));
            if (string3.equals(NETCONF_BASE_CAPABILITY)) {
                this.baseCapability = true;
                continue;
            }
            if (string3.equals(WRITABLE_RUNNING_CAPABILITY)) {
                this.writableRunningCapability = true;
                continue;
            }
            if (string3.equals(CANDIDATE_CAPABILITY)) {
                this.candidateCapability = true;
                continue;
            }
            if (string3.equals(CONFIRMED_COMMIT_CAPABILITY)) {
                this.confirmedCommitCapability = true;
                continue;
            }
            if (string3.equals(ROLLBACK_ON_ERROR_CAPABILITY)) {
                this.rollbackOnErrorCapability = true;
                continue;
            }
            if (string3.equals(VALIDATE_CAPABILITY)) {
                this.validateCapability = true;
                continue;
            }
            if (string3.equals(NOTIFICATION_CAPABILITY)) {
                this.notificationCapability = true;
                continue;
            }
            if (string3.equals(INTERLEAVE_CAPABILITY)) {
                this.interleaveCapability = true;
                continue;
            }
            if (string3.equals(STARTUP_CAPABILITY)) {
                this.startupCapability = true;
                continue;
            }
            if (element2.value.toString().startsWith(URL_CAPABILITY_SCHEME)) {
                this.urlCapability = true;
                string = element2.value.toString().substring(URL_CAPABILITY_SCHEME.length());
                this.urlSchemes = string.split(",");
                continue;
            }
            if (string3.equals(XPATH_CAPABILITY)) {
                this.xpathCapability = true;
                continue;
            }
            if (string3.equals(PARTIAL_LOCK_CAPABILITY)) {
                this.partialLockCapability = true;
                continue;
            }
            if (string3.equals(NS_NETCONF)) {
                this.baseCapability = true;
                continue;
            }
            if (string3.equals("urn:ietf:params:xml:ns:netconf:capability:candidate:1.0")) {
                this.candidateCapability = true;
                continue;
            }
            if (string3.equals("urn:ietf:params:xml:ns:netconf:capability:confirmed-commit:1.0")) {
                this.confirmedCommitCapability = true;
                continue;
            }
            if (string3.equals("urn:ietf:params:xml:ns:netconf:capability:validate:1.0")) {
                this.validateCapability = true;
                continue;
            }
            if (string3.equals("urn:ietf:params:xml:ns:netconf:capability:url:1.0")) {
                this.urlCapability = true;
                if (stringArray[1] == null) continue;
                this.urlSchemes = stringArray[1].split(",");
                continue;
            }
            if (string3.equals(WITH_DEFAULTS_CAPABILITY)) {
                this.withDefaultsCapability = true;
                continue;
            }
            if (string3.equals("http://tail-f.com/ns/netconf/actions/1.0")) {
                this.actionsCapability = true;
                continue;
            }
            if (string3.equals("http://tail-f.com/ns/netconf/transactions/1.0")) {
                this.transactionsCapability = true;
                continue;
            }
            this.data_capas.add(new Capa(string3, string2));
        }
    }

    public boolean hasCapability(String string) {
        for (Capa capa : this.capas) {
            if (!capa.uri.equals(string)) continue;
            return true;
        }
        return false;
    }

    public String getRevision(String string) {
        for (Capa capa : this.data_capas) {
            if (!capa.uri.equals(string)) continue;
            return capa.revision;
        }
        return null;
    }

    private static class Capa {
        String uri;
        String revision;

        Capa(String string, String string2) {
            this.uri = string;
            this.revision = string2;
        }
    }
}

