/*
 * Decompiled with CFR 0.152.
 */
package com.tailf.jnc;

import com.tailf.jnc.Attribute;
import com.tailf.jnc.Capabilities;
import com.tailf.jnc.ElementChildrenIterator;
import com.tailf.jnc.JNCException;
import com.tailf.jnc.NodeSet;
import com.tailf.jnc.Path;
import com.tailf.jnc.PathCreate;
import com.tailf.jnc.Prefix;
import com.tailf.jnc.PrefixMap;
import com.tailf.jnc.Tagpath;
import com.tailf.jnc.Transport;
import com.tailf.jnc.XMLParser;
import com.tailf.jnc.YangBaseType;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class Element
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String NETCONF_NAMESPACE = "urn:ietf:params:xml:ns:netconf:base:1.0";
    public static final String OPERATION = "operation";
    public String namespace;
    public String name;
    public Object value;
    ArrayList<Attribute> attrs;
    public PrefixMap prefixes;
    public static final PrefixMap defaultPrefixes = new PrefixMap(new Prefix[]{new Prefix("nc", "urn:ietf:params:xml:ns:netconf:base:1.0"), new Prefix("pl", "urn:ietf:params:xml:ns:netconf:partial-lock:1.0"), new Prefix("ncn", "urn:ietf:params:xml:ns:netconf:notification:1.0")});
    protected NodeSet children = null;
    protected Element parent = null;
    public static final int CREATE_NEW = 1;
    public static final int CREATE_MERGE = 2;
    public static final int CREATE_MERGE_MULTI = 3;
    public static final int OP_CREATE = 1;
    public static final int OP_DELETE = 2;
    public static final int OP_REPLACE = 3;
    public static final int OP_MERGE = 4;
    static final int DEBUG_LEVEL_ELEMENT = 1;
    static final int DEBUG_LEVEL_ATTRIBUTE = 1;
    static final int DEBUG_LEVEL_SESSION = 2;
    static final int DEBUG_LEVEL_TRANSPORT = 2;
    static final int DEBUG_LEVEL_PATH = 3;
    static final int DEBUG_LEVEL_PATHCREATE = 3;
    static final int DEBUG_LEVEL_EXPR = 3;
    static final int DEBUG_LEVEL_LOCATIONSTEP = 3;
    static final int DEBUG_LEVEL_PARSER = 3;
    static final int DEBUG_LEVEL_PREFIX = 4;
    static final int DEBUG_LEVEL_PREFIXMAP = 4;
    static int debugLevel = 0;

    public Element(String string, String string2) {
        this.namespace = string;
        this.name = string2;
    }

    public Element getRootElement() {
        Element element = this;
        while (element.parent != null) {
            element = element.parent;
        }
        return element;
    }

    public static Element create(String string, String string2) throws JNCException {
        PrefixMap prefixMap = new PrefixMap();
        prefixMap.add(new Prefix("", string));
        return Element.create(prefixMap, string2);
    }

    public static Element create(Prefix prefix, String string) throws JNCException {
        PrefixMap prefixMap = new PrefixMap();
        prefixMap.add(prefix);
        return Element.create(prefixMap, string);
    }

    public static Element create(PrefixMap prefixMap, String string) throws JNCException {
        Element.trace("create: \"" + string + "\"");
        PathCreate pathCreate = new PathCreate(string);
        Element element = pathCreate.eval(prefixMap);
        element.setPrefix(prefixMap);
        return element;
    }

    public Element createChild(String string) {
        Element element = new Element(this.namespace, string);
        this.addChild(element);
        return element;
    }

    public Element createChild(String string, Object object) {
        Element element = new Element(this.namespace, string);
        element.setValue(object);
        this.addChild(element);
        return element;
    }

    public Element createChild(String string, String string2, Object object) {
        Element element = new Element(string, string2);
        element.setValue(object);
        this.addChild(element);
        return element;
    }

    public String getElementPath(String string) {
        return this.getElementPath() + "/" + string;
    }

    public Element createPath(String string) throws JNCException {
        return this.createPath(2, null, string);
    }

    public Element createPath(int n, String string) throws JNCException {
        return this.createPath(n, null, string);
    }

    public Element createPath(String string, String string2) throws JNCException {
        PrefixMap prefixMap = new PrefixMap();
        prefixMap.add(new Prefix("", string));
        return this.createPath(2, prefixMap, string2);
    }

    public Element createPath(Prefix prefix, String string) throws JNCException {
        PrefixMap prefixMap = new PrefixMap();
        prefixMap.add(prefix);
        return this.createPath(2, prefixMap, string);
    }

    public Element createPath(PrefixMap prefixMap, String string) throws JNCException {
        return this.createPath(2, prefixMap, string);
    }

    public Element createPath(int n, PrefixMap prefixMap, String string) throws JNCException {
        Element.trace("createPath: \"" + string + "\"");
        PathCreate pathCreate = new PathCreate(string);
        if (prefixMap != null) {
            this.setPrefix(prefixMap);
        }
        if (n == 2 || n == 3) {
            int n2;
            NodeSet nodeSet = new NodeSet();
            Element element = null;
            nodeSet.add(this);
            NodeSet nodeSet2 = nodeSet;
            int n3 = pathCreate.steps();
            for (n2 = 0; nodeSet.size() > 0 && n2 < n3; ++n2) {
                if ((nodeSet = pathCreate.evalStep(nodeSet, n2)).size() <= 0) continue;
                nodeSet2 = nodeSet;
                if (element != null) continue;
                element = nodeSet.getElement(0);
            }
            if (n2 == n3 && nodeSet.size() > 0) {
                return element;
            }
            if (n == 2 && nodeSet2.size() > 1) {
                throw new JNCException(-4, "multiple nodes found by path: \"" + string + "\"");
            }
            --n2;
            for (Element element2 : nodeSet2) {
                PrefixMap prefixMap2 = element2.getContextPrefixMap();
                for (int i = n2; i < n3; ++i) {
                    Element element3 = pathCreate.evalStep(prefixMap2, i, element2);
                    element2.addChild(element3);
                    element2 = element3;
                    if (element != null) continue;
                    element = element3;
                }
            }
            return element;
        }
        PrefixMap prefixMap3 = this.getContextPrefixMap();
        Element element = pathCreate.eval(prefixMap3);
        this.addChild(element);
        return element;
    }

    public void setDefaultPrefix() {
        this.setPrefix(new Prefix("", this.namespace));
    }

    public void removeDefaultPrefix() {
        this.removePrefix("");
    }

    public void setPrefix(String string) {
        this.setPrefix(new Prefix(string, this.namespace));
    }

    public void setPrefix(Prefix prefix) {
        this.setPrefix(new PrefixMap(prefix));
    }

    public void setPrefix(PrefixMap prefixMap) {
        if (this.prefixes == null) {
            this.prefixes = new PrefixMap();
        }
        this.prefixes.set(prefixMap);
    }

    public void removePrefix(String string) {
        if (this.prefixes == null) {
            return;
        }
        this.prefixes.remove(string);
    }

    public Element getParent() {
        return this.parent;
    }

    public void addChild(Element element) {
        if (this.children == null) {
            this.children = new NodeSet();
        }
        this.children.add(element);
        element.parent = this;
    }

    public int insertChild(Element element) throws JNCException {
        if (element.parent != null || element == this) {
            throw new JNCException(-8, this);
        }
        this.addChild(element);
        return this.children.indexOf(element);
    }

    public int insertChild(Element element, int n) throws JNCException {
        if (element.parent != null) {
            throw new JNCException(-8, this);
        }
        if (this.children == null) {
            this.children = new NodeSet();
        }
        element.parent = this;
        this.children.add(n, element);
        return this.children.indexOf(element);
    }

    public int insertChild(Element element, String[] stringArray) throws JNCException {
        if (element.parent != null) {
            throw new JNCException(-8, this);
        }
        if (this.children == null) {
            this.children = new NodeSet();
        }
        element.parent = this;
        int n = 0;
        int n2 = 0;
        while (n < this.children.size()) {
            if (this.children.getElement((int)n).name.equals(stringArray[n2])) {
                ++n;
                continue;
            }
            if (element.name.equals(stringArray[n2])) break;
            ++n2;
        }
        this.children.add(n, element);
        return n;
    }

    public int insertFirst(Element element) throws JNCException {
        return this.insertChild(element, 0);
    }

    public int insertLast(Element element) throws JNCException {
        return this.insertChild(element);
    }

    public int position() {
        return this.parent == null ? -1 : this.parent.children.indexOf(this);
    }

    public NodeSet delete(String string) throws JNCException {
        NodeSet nodeSet = this.get(string);
        if (nodeSet != null) {
            for (int i = 0; i < nodeSet.size(); ++i) {
                nodeSet.getElement(i).delete();
            }
        }
        return nodeSet;
    }

    public void delete() {
        if (this.parent != null) {
            this.parent.deleteChild(this);
        }
    }

    public void deleteChild(Element element) {
        if (this.children == null) {
            return;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            if (element != this.children.getElement(i)) continue;
            this.children.remove(i);
            element.parent = null;
            break;
        }
    }

    public boolean hasChildren() {
        return this.children != null && this.children.size() > 0;
    }

    public void addAttr(Attribute attribute) {
        if (this.attrs == null) {
            this.attrs = new ArrayList();
        }
        this.attrs.add(attribute);
    }

    public Attribute[] getAttrs() {
        if (this.attrs != null) {
            return this.attrs.toArray(new Attribute[this.attrs.size()]);
        }
        return null;
    }

    public String getAttrValue(String string) {
        return this.getAttr(string).getValue();
    }

    public Attribute getAttr(String string) {
        if (this.attrs != null) {
            for (Attribute attribute : this.attrs) {
                if (!attribute.name.equals(string)) continue;
                return attribute;
            }
        }
        return null;
    }

    public Attribute setAttr(String string, String string2) {
        Element.trace("setAttr: " + string + "=\"" + string2 + "\"");
        if (string.equals("xmlns")) {
            Prefix prefix = new Prefix("", string2);
            this.setPrefix(prefix);
            return prefix;
        }
        if (string.startsWith("xmlns:")) {
            String string3 = string.substring(6);
            Prefix prefix = new Prefix(string3, string2);
            this.setPrefix(prefix);
            return prefix;
        }
        if (this.attrs == null) {
            this.attrs = new ArrayList();
        } else {
            for (Attribute attribute : this.attrs) {
                if (!attribute.name.equals(string)) continue;
                attribute.setValue(string2);
                return attribute;
            }
        }
        Attribute attribute = new Attribute(this.namespace, string, string2);
        this.addAttr(attribute);
        return attribute;
    }

    public Attribute setAttr(String string, String string2, String string3) {
        Element.trace("setAttr: (" + string + ") " + string2 + "=\"" + string3 + "\"");
        if (string2.startsWith("xmlns") && string.startsWith("http://www.w3.org/2000/xmlns/")) {
            return this.setAttr(string2, string3);
        }
        if (this.attrs == null) {
            this.attrs = new ArrayList();
        } else {
            for (Attribute attribute : this.attrs) {
                if (!attribute.ns.equals(string) || !attribute.name.equals(string2)) continue;
                attribute.setValue(string3);
                return attribute;
            }
        }
        Attribute attribute = new Attribute(string, string2, string3);
        this.addAttr(attribute);
        return attribute;
    }

    public void removeAttr(String string) {
        if (this.attrs != null) {
            for (int i = 0; i < this.attrs.size(); ++i) {
                Attribute attribute = this.attrs.get(i);
                if (!attribute.name.equals(string)) continue;
                Element.trace("removeAttr: " + string);
                this.attrs.remove(i);
                return;
            }
        }
    }

    public void removeAttr(String string, String string2) {
        if (this.attrs != null) {
            for (int i = 0; i < this.attrs.size(); ++i) {
                Attribute attribute = this.attrs.get(i);
                if (!attribute.name.equals(string2) || !attribute.ns.equals(string)) continue;
                Element.trace("removeAttr: (" + string + ") " + string2);
                this.attrs.remove(i);
            }
        }
    }

    public Object getValueOfChild(String string) {
        for (Element element : this.children) {
            if (!element.name.equals(string)) continue;
            return element.getValue();
        }
        return null;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean exists(String string) throws JNCException {
        NodeSet nodeSet = this.get(string);
        return nodeSet != null && !nodeSet.isEmpty();
    }

    public Object getValue(String string) throws JNCException {
        NodeSet nodeSet = this.get(string);
        return nodeSet != null && !nodeSet.isEmpty() ? nodeSet.getElement(0).getValue() : null;
    }

    public Object[] getValues(String string) throws JNCException {
        NodeSet nodeSet = this.get(string);
        String[] stringArray = null;
        if (nodeSet != null) {
            stringArray = new String[nodeSet.size()];
            for (int i = 0; i < nodeSet.size(); ++i) {
                stringArray[i] = nodeSet.getElement(i).getValue();
            }
        }
        return stringArray;
    }

    public Set<String> getValuesAsSet(String string) throws JNCException {
        String[] stringArray = (String[])this.getValues(string);
        return new HashSet<String>(Arrays.asList(stringArray));
    }

    public void setValue(Object object) {
        Element.trace("setValue: " + this.name + "=\"" + object + "\"");
        this.value = object;
    }

    public void setValue(String string, Object object) throws JNCException {
        for (Element element : this.get(string)) {
            element.setValue(object);
        }
    }

    public void deleteValue(String string) throws JNCException {
        for (Element element : this.get(string)) {
            element.deleteValue();
        }
    }

    public void deleteValue() {
        this.value = null;
    }

    public Element getFirst(String string) throws JNCException {
        NodeSet nodeSet = this.get(string);
        if (nodeSet == null || nodeSet.isEmpty()) {
            return null;
        }
        return nodeSet.getElement(0);
    }

    public Element getLast(String string) throws JNCException {
        NodeSet nodeSet = this.get(string);
        if (nodeSet == null || nodeSet.isEmpty()) {
            return null;
        }
        return (Element)nodeSet.get(nodeSet.size() - 1);
    }

    public NodeSet get(String string) throws JNCException {
        Path path = new Path(string);
        return path.eval(this);
    }

    public NodeSet getChildren() {
        return this.children;
    }

    public NodeSet getChildren(String string) {
        NodeSet nodeSet = new NodeSet();
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                Element element = this.children.getElement(i);
                if (!element.name.equals(string)) continue;
                nodeSet.add(element);
            }
        }
        return nodeSet;
    }

    public Element getChild(String string) {
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                Element element = this.children.getElement(i);
                if (!element.name.equals(string)) continue;
                return element;
            }
        }
        return null;
    }

    public Object clone() {
        Element element = new Element(this.namespace, this.name);
        if (this.children != null) {
            if (element.children == null) {
                element.children = new NodeSet();
            }
            for (int i = 0; i < this.children.size(); ++i) {
                Element element2 = this.children.getElement(i);
                Element element3 = (Element)element2.clone();
                element.addChild(element3);
            }
        }
        this.cloneAttrs(element);
        this.cloneValue(element);
        return element;
    }

    protected Element getChild(Element element) {
        if (this.children != null) {
            for (Element element2 : this.children) {
                if (element.compare(element2) < 0) continue;
                return element2;
            }
        }
        return null;
    }

    protected Element cloneShallow() {
        Element element = new Element(this.namespace, this.name);
        this.cloneAttrs(element);
        this.cloneValue(element);
        return element;
    }

    public Element merge(Element element, int n) throws JNCException {
        Element element2;
        NodeSet nodeSet = new NodeSet();
        Element element3 = this;
        while (element3 != null) {
            nodeSet.add(0, element3);
            element3 = element3.parent;
        }
        Element element4 = nodeSet.getElement(0);
        nodeSet.remove(0);
        if (element == null) {
            if (nodeSet.size() >= 1) {
                element = element4.cloneShallow();
            } else {
                if (n == 1) {
                    Element element5 = (Element)element4.clone();
                    element5.markCreate();
                    return element5;
                }
                if (n == 2) {
                    Element element6 = element4.cloneShallow();
                    element6.markDelete();
                    return element6;
                }
                if (n == 3) {
                    Element element7 = (Element)element4.clone();
                    element7.markReplace();
                    return element7;
                }
                if (n == 4) {
                    Element element8 = (Element)element4.clone();
                    element8.markMerge();
                    return element8;
                }
            }
        }
        if (element4.compare(element) == -1) {
            System.err.println(" x= " + element4);
            System.err.println(" root= " + element);
            System.err.println(" compare: " + element4.compare(element));
            throw new JNCException(-9, element4.getElementPath() + ", " + (element != null ? element.getElementPath() : null));
        }
        Element element9 = element;
        while (nodeSet.size() > 1) {
            element4 = nodeSet.getElement(0);
            nodeSet.remove(0);
            Element element10 = element2 = element9 != null ? element9.getChild(element4) : null;
            if (element2 == null) {
                element2 = element4.cloneShallow();
                element9.addChild(element2);
            }
            element9 = element2;
        }
        if (nodeSet.size() > 0) {
            element4 = nodeSet.getElement(0);
            if (n == 1) {
                element2 = (Element)element4.clone();
                element2.markCreate();
                element9.addChild(element2);
            } else if (n == 2) {
                element2 = element4.cloneShallow();
                element2.markDelete();
                element9.addChild(element2);
            } else if (n == 4) {
                element2 = (Element)element4.clone();
                element2.markMerge();
                element9.addChild(element2);
            } else {
                element2 = (Element)element4.clone();
                element2.markReplace();
                element9.addChild(element2);
            }
        }
        return element;
    }

    protected Element cloneAttrs(Element element) {
        if (this.attrs != null) {
            element.attrs = new ArrayList();
            for (int i = 0; i < this.attrs.size(); ++i) {
                Attribute attribute = this.attrs.get(i);
                Attribute attribute2 = (Attribute)attribute.clone();
                element.attrs.add(attribute2);
            }
        }
        if (this.prefixes != null) {
            element.prefixes = (PrefixMap)this.prefixes.clone();
        }
        return element;
    }

    protected Element cloneValue(Element element) {
        if (this.value instanceof YangBaseType) {
            element.value = ((YangBaseType)this.value).clone();
        } else if (this.value != null) {
            element.value = this.value;
        }
        return element;
    }

    public void removeMark() {
        this.removeAttr(NETCONF_NAMESPACE, OPERATION);
    }

    public void removeMarks() {
        this.removeMark();
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                this.children.getElement(i).removeMarks();
            }
        }
    }

    public void markDelete() {
        this.setAttr(NETCONF_NAMESPACE, OPERATION, "delete");
    }

    public void markDelete(String string) throws JNCException {
        Path path = new Path(string);
        NodeSet nodeSet = path.eval(this);
        if (nodeSet != null) {
            for (int i = 0; i < nodeSet.size(); ++i) {
                nodeSet.getElement(i).markDelete();
            }
        }
    }

    public void markReplace() {
        this.setAttr(NETCONF_NAMESPACE, OPERATION, "replace");
    }

    public void markReplace(String string) throws JNCException {
        Path path = new Path(string);
        NodeSet nodeSet = path.eval(this);
        if (nodeSet != null) {
            for (int i = 0; i < nodeSet.size(); ++i) {
                nodeSet.getElement(i).markReplace();
            }
        }
    }

    public void markMerge() {
        this.setAttr(NETCONF_NAMESPACE, OPERATION, "merge");
    }

    public void markMerge(String string) throws JNCException {
        Path path = new Path(string);
        NodeSet nodeSet = path.eval(this);
        if (nodeSet != null) {
            for (int i = 0; i < nodeSet.size(); ++i) {
                nodeSet.getElement(i).markMerge();
            }
        }
    }

    public void markCreate() {
        this.setAttr(NETCONF_NAMESPACE, OPERATION, "create");
    }

    public void markCreate(String string) throws JNCException {
        Path path = new Path(string);
        NodeSet nodeSet = path.eval(this);
        if (nodeSet != null) {
            for (int i = 0; i < nodeSet.size(); ++i) {
                nodeSet.getElement(i).markCreate();
            }
        }
    }

    public String qualifiedName() {
        String string = this.prefix();
        if (string == null) {
            string = "";
        }
        String string2 = string.equals("") ? this.name : string + ":" + this.name;
        return string2;
    }

    public String prefix() {
        return this.nsToPrefix(this.namespace);
    }

    public PrefixMap getContextPrefixMap() {
        PrefixMap prefixMap = new PrefixMap();
        Element element = this;
        while (element != null) {
            if (element.prefixes != null) {
                prefixMap.merge(element.prefixes);
            }
            element = element.parent;
        }
        prefixMap.merge(defaultPrefixes);
        return prefixMap;
    }

    public String lookupContextPrefix(String string) {
        Element element = this;
        while (element != null) {
            String string2;
            if (element.prefixes != null && (string2 = element.prefixes.prefixToNs(string)) != null) {
                return string2;
            }
            element = element.parent;
        }
        return defaultPrefixes.prefixToNs(string);
    }

    public String nsToPrefix(String string) {
        Element element = this;
        String string2 = null;
        while (string2 == null && element != null) {
            if (element.prefixes != null) {
                string2 = element.prefixes.nsToPrefix(string);
            }
            element = element.parent;
        }
        if (string2 != null) {
            return string2;
        }
        return defaultPrefixes.nsToPrefix(string);
    }

    public String getElementPath() {
        Element element = this;
        String string = null;
        while (element != null) {
            string = element.namespace == null ? this.strConcat(element.name, string) : (element.parent != null && element.parent.namespace != null && element.namespace.equals(element.parent.namespace) ? this.strConcat(element.name, string) : this.strConcat(element.qualifiedName(), string));
            element = element.parent;
        }
        return "/" + string;
    }

    private String strConcat(String string, String string2) {
        if (string2 != null) {
            return string + "/" + string2;
        }
        return string;
    }

    public boolean equals(Object object) {
        if (object instanceof Element) {
            Element element = (Element)object;
            boolean bl = this.name.equals(element.name);
            boolean bl2 = this.namespace.equals(element.namespace);
            if (bl && bl2) {
                if (this.value != null) {
                    return this.value.equals(element.value);
                }
                return element.value == null;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode() + this.namespace.hashCode() + this.value.hashCode();
    }

    public int compare(Element element) {
        boolean bl = this.name.equals(element.name);
        boolean bl2 = this.namespace.equals(element.namespace);
        if (bl && bl2) {
            return this.equals(element) ? 0 : 1;
        }
        return -1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer("Element{name=").append(this.name);
        if (this.value != null) {
            stringBuffer3.append(", value=").append(this.value);
        }
        stringBuffer3.append(", ns=").append(this.namespace);
        if (this.prefixes != null) {
            for (Prefix serializable : this.prefixes) {
                stringBuffer.append(serializable.toXMLString());
                stringBuffer.append(", ");
            }
        }
        if (this.attrs != null) {
            for (Attribute attribute : this.attrs) {
                stringBuffer.append(attribute.toXMLString(this));
                stringBuffer.append(", ");
            }
        }
        if (stringBuffer.length() >= ", ".length()) {
            stringBuffer.delete(stringBuffer.length() - 3, stringBuffer.length());
            stringBuffer3.append(", attrs=[").append(stringBuffer);
        }
        if (this.children != null) {
            for (Element element : this.children) {
                stringBuffer2.append(element.name);
                stringBuffer2.append(", ");
            }
        }
        if (stringBuffer2.length() >= ", ".length()) {
            stringBuffer2.delete(stringBuffer2.length() - 3, stringBuffer2.length());
            stringBuffer3.append("], children=[").append(stringBuffer2);
        }
        stringBuffer3.append("], path=").append(this.getElementPath()).append("}");
        return stringBuffer3.toString();
    }

    public String toXMLString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toXMLString(0, stringBuffer);
        return stringBuffer.toString();
    }

    private void toXMLString(int n, StringBuffer stringBuffer) {
        boolean bl = this.hasChildren();
        String string = this.qualifiedName();
        stringBuffer.append(new String(new char[n * 2]).replace("\u0000", " "));
        stringBuffer.append("<").append(string);
        if (this.prefixes != null) {
            for (Prefix serializable : this.prefixes) {
                stringBuffer.append(" ").append(serializable.toXMLString());
            }
        }
        if (this.attrs != null) {
            for (Attribute attribute : this.attrs) {
                stringBuffer.append(" ").append(attribute.toXMLString(this));
            }
        }
        ++n;
        if (bl) {
            stringBuffer.append(">").append("\n");
            for (Element element : this.children) {
                element.toXMLString(n, stringBuffer);
            }
        } else if (this.value != null) {
            stringBuffer.append(">").append("");
            String string2 = this.value.toString().replaceAll("&", "&amp;");
            stringBuffer.append(this.getIndentationSpacing(false, n));
            stringBuffer.append(string2).append("");
        } else {
            stringBuffer.append("/>").append("");
            return;
        }
        stringBuffer.append(this.getIndentationSpacing(bl, --n)).append("</").append(string).append(">\n");
    }

    private String getIndentationSpacing(boolean bl, int n) {
        if (bl) {
            return new String(new char[n * 2]).replace("\u0000", " ");
        }
        return "";
    }

    protected void encode(Transport transport) throws JNCException {
        this.encode(transport, true, null);
    }

    protected void encode(Transport transport, Capabilities capabilities) throws JNCException {
        this.encode(transport, true, capabilities);
    }

    protected void encode(Transport transport, boolean bl) throws JNCException {
        this.encode(transport, bl, null);
    }

    protected void encode(Transport transport, boolean bl, Capabilities capabilities) throws JNCException {
        String string = this.qualifiedName();
        transport.print("<" + string);
        if (this.prefixes != null) {
            for (Prefix serializable : this.prefixes) {
                transport.print(" ");
                serializable.encode(transport);
            }
        }
        if (this.attrs != null) {
            for (Attribute attribute : this.attrs) {
                transport.print(" ");
                attribute.encode(transport, this);
            }
        }
        if (this.hasChildren()) {
            transport.println(">");
            for (Element element : this.children) {
                element.encode(transport, true, capabilities);
            }
        } else if (this.value != null) {
            transport.print(">" + this.value.toString());
        } else {
            transport.print("/>" + (bl ? "\n" : ""));
            return;
        }
        transport.print("</" + string + ">" + (bl ? "\n" : ""));
    }

    public Tagpath tagpath() {
        Element element = this;
        int n = 0;
        while (element != null) {
            element = element.parent;
            ++n;
        }
        Tagpath tagpath = new Tagpath(n);
        element = this;
        while (element != null) {
            tagpath.p[--n] = element.name;
            element = element.parent;
        }
        return tagpath;
    }

    public ElementChildrenIterator iterator() {
        return new ElementChildrenIterator(this.children);
    }

    public ElementChildrenIterator iterator(String string) {
        return new ElementChildrenIterator(this.children, string);
    }

    public void writeFile(String string) throws IOException {
        File file = new File(string);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
        dataOutputStream.writeBytes(this.toXMLString());
        dataOutputStream.close();
    }

    public static Element readFile(String string) throws JNCException {
        XMLParser xMLParser = new XMLParser();
        return xMLParser.readFile(string);
    }

    public static void setDebugLevel(int n) {
        debugLevel = n;
    }

    private static void trace(String string) {
        if (debugLevel >= 1) {
            System.err.println("*Element: " + string);
        }
    }
}

