/*
 * Decompiled with CFR 0.152.
 */
package com.tailf.jnc;

import com.tailf.jnc.Element;
import com.tailf.jnc.NodeSet;
import java.util.Iterator;

public class ElementChildrenIterator
implements Iterator<Element> {
    private Iterator<Element> childrenIterator;
    private Element nextChild;
    private boolean hasNextChild = false;
    private final String name;

    public ElementChildrenIterator(NodeSet nodeSet) {
        this.childrenIterator = nodeSet != null ? nodeSet.iterator() : null;
        this.name = null;
    }

    public ElementChildrenIterator(NodeSet nodeSet, String string) {
        this.childrenIterator = nodeSet != null ? nodeSet.iterator() : null;
        this.name = string;
    }

    @Override
    public boolean hasNext() {
        if (this.hasNextChild) {
            return true;
        }
        if (this.childrenIterator == null) {
            return false;
        }
        while (this.childrenIterator.hasNext()) {
            if (this.name == null) {
                return true;
            }
            Element element = this.childrenIterator.next();
            if (!element.name.equals(this.name)) continue;
            this.hasNextChild = true;
            this.nextChild = element;
            return true;
        }
        this.hasNextChild = false;
        return false;
    }

    public Element nextElement() {
        if (this.hasNextChild) {
            this.hasNextChild = false;
            return this.nextChild;
        }
        while (this.childrenIterator.hasNext()) {
            Element element = this.childrenIterator.next();
            if (this.name == null) {
                return element;
            }
            if (!element.name.equals(this.name)) continue;
            return element;
        }
        return null;
    }

    @Override
    public Element next() {
        return this.nextElement();
    }

    @Override
    public void remove() {
    }
}

