/*
 * Decompiled with CFR 0.152.
 */
package com.tailf.jnc;

import com.tailf.jnc.Attribute;
import com.tailf.jnc.Element;
import com.tailf.jnc.JNCException;
import com.tailf.jnc.NodeSet;
import com.tailf.jnc.PrefixMap;
import java.util.ArrayList;

public class Path {
    static final int AXIS_CHILD = 1;
    static final int AXIS_SELF = 2;
    static final int AXIS_PARENT = 3;
    static final int AXIS_ROOT = 4;
    boolean create = false;
    ArrayList<LocationStep> locationSteps;
    String pathStr;
    static final int AND = 1;
    static final int OR = 2;
    static final int EQ = 3;
    static final int NEQ = 4;
    static final int GT = 5;
    static final int GTE = 6;
    static final int LT = 7;
    static final int LTE = 8;
    static final int PLUS = 9;
    static final int MINUS = 10;
    static final int FUN_BOOLEAN = 11;
    static final int FUN_NUMBER = 12;
    static final int FUN_STRING = 13;
    static final int FUN_POSITION = 14;
    static final int FUN_LAST = 15;
    static final int FUN_COUNT = 16;
    static final int FUN_CONCAT = 17;
    static final int FUN_NOT = 18;
    static final int FUN_TRUE = 19;
    static final int FUN_FALSE = 20;
    static final int FUN_NEG = 21;
    static final int ATTR_VALUE = 22;
    static final int CHILD_VALUE = 23;
    static final int SLASH = 1;
    static final int SLASHSLASH = 2;
    static final int DOT = 3;
    static final int DOTDOT = 4;
    static final int COLON = 5;
    static final int COLONCOLON = 6;
    static final int OP = 7;
    static final int COMPARE = 8;
    static final int ATOM = 9;
    static final int ATTR = 10;
    static final int NUMBER = 11;
    static final int STRING = 12;
    static final int LBRACER = 13;
    static final int RBRACER = 14;
    static final int LPRED = 15;
    static final int RPRED = 16;
    static final int COMMA = 17;

    public Path(String string) throws JNCException {
        this.create = false;
        this.pathStr = string;
        this.locationSteps = this.parse(this.tokenize(string));
    }

    Path() {
    }

    public NodeSet eval(Element element) throws JNCException {
        Path.trace("eval(): " + this);
        NodeSet nodeSet = new NodeSet();
        nodeSet.add(element);
        for (LocationStep locationStep : this.locationSteps) {
            nodeSet = locationStep.step(nodeSet);
        }
        return nodeSet;
    }

    NodeSet evalStep(NodeSet nodeSet, int n) throws JNCException {
        if (n < 0 || n >= this.locationSteps.size()) {
            throw new JNCException(-3, "cannot eval location step: " + n + " in path");
        }
        LocationStep locationStep = this.locationSteps.get(n);
        Path.trace("evalStep(): step=" + n + ", " + locationStep);
        nodeSet = locationStep.step(nodeSet);
        return nodeSet;
    }

    int steps() {
        return this.locationSteps.size();
    }

    ArrayList<LocationStep> parse(TokenList tokenList) throws JNCException {
        ArrayList<LocationStep> arrayList = new ArrayList<LocationStep>();
        try {
            int n = tokenList.size();
            while (n > 0) {
                LocationStep locationStep;
                Path.trace("parse(): " + tokenList);
                Token token = n >= 1 ? tokenList.getToken(0) : new Token();
                Token token2 = n >= 2 ? tokenList.getToken(1) : new Token();
                Token token3 = n >= 3 ? tokenList.getToken(2) : new Token();
                Token token4 = n >= 4 ? tokenList.getToken(3) : new Token();
                Token token5 = n >= 5 ? tokenList.getToken(4) : new Token();
                if (token.type == 1) {
                    locationStep = new LocationStep(4);
                    arrayList.add(locationStep);
                    tokenList.remove(0);
                } else if (token.type == 9 && token2.type == 6 && token3.type == 9 && token4.type == 5 && token5.type == 9) {
                    locationStep = new LocationStep(this.parseAxis(token.value), token3.value, token5.value);
                    arrayList.add(locationStep);
                    tokenList.removeRange(0, 5);
                    this.parsePredicates(tokenList, locationStep);
                } else if (token.type == 9 && token2.type == 6 && token3.type == 9) {
                    locationStep = new LocationStep(this.parseAxis(token.value), token3.value);
                    arrayList.add(locationStep);
                    tokenList.removeRange(0, 3);
                    this.parsePredicates(tokenList, locationStep);
                } else if (token.type == 9 && token2.type == 5 && token3.type == 9) {
                    locationStep = new LocationStep(1, token.value, token3.value);
                    arrayList.add(locationStep);
                    tokenList.removeRange(0, 3);
                    this.parsePredicates(tokenList, locationStep);
                } else if (token.type == 9) {
                    locationStep = new LocationStep(1, token.value);
                    arrayList.add(locationStep);
                    tokenList.remove(0);
                    this.parsePredicates(tokenList, locationStep);
                } else if (token.type == 2) {
                    tokenList.add(0, new Token(1, "/"));
                    tokenList.add(1, new Token(9, "descendant-or-self"));
                    tokenList.add(2, new Token(6, "::"));
                    tokenList.add(3, new Token(9, "node"));
                    tokenList.add(4, new Token(13, "("));
                    tokenList.add(5, new Token(14, ")"));
                    tokenList.add(6, new Token(1, "/"));
                } else {
                    this.parseError(tokenList);
                }
                n = tokenList.size();
            }
        }
        catch (Exception exception) {
            throw new JNCException(-3, "parse error: " + exception);
        }
        Path.trace("parse() -> " + arrayList);
        return arrayList;
    }

    int parseAxis(String string) throws JNCException {
        if (string.equals("child")) {
            return 1;
        }
        if (string.equals("self")) {
            return 2;
        }
        throw new JNCException(-3, "unsupported or unknown axis: " + string);
    }

    void parsePredicates(TokenList tokenList, LocationStep locationStep) throws JNCException {
        Path.trace("parsePredicates(): " + tokenList);
        int n = tokenList.size();
        if (n >= 1) {
            Token token = tokenList.getToken(0);
            if (token.type == 15) {
                int n2 = 1;
                try {
                    while (tokenList.getToken((int)n2).type != 16) {
                        ++n2;
                    }
                }
                catch (Exception exception) {
                    throw new JNCException(-3, "unmatched '[' in expression");
                }
                if (locationStep.predicates == null) {
                    locationStep.predicates = new ArrayList();
                }
                int n3 = 1;
                int n4 = 1;
                while (n4 + 1 < n2) {
                    token = tokenList.getToken(n4);
                    Token token2 = tokenList.getToken(n4 + 1);
                    if (token.type == 17 && token2.type != 17) {
                        Expr expr = this.parsePredicate(tokenList, n3, n4);
                        locationStep.predicates.add(expr);
                        n3 = n4 + 1;
                    }
                    ++n4;
                }
                Expr expr = this.parsePredicate(tokenList, n3, n2);
                locationStep.predicates.add(expr);
                tokenList.removeRange(0, n2 + 1);
                this.parsePredicates(tokenList, locationStep);
            } else if (token.type == 1) {
                tokenList.remove(0);
            } else if (token.type != 2) {
                this.parseError(tokenList);
            }
        }
    }

    Expr parsePredicate(TokenList tokenList, int n, int n2) throws JNCException {
        int n3 = n;
        while (n3 < n2) {
            Token token = tokenList.getToken(n3);
            Token token2 = n3 + 1 < n2 ? tokenList.getToken(n3 + 1) : null;
            Token token3 = n3 + 2 < n2 ? tokenList.getToken(n3 + 2) : null;
            Path.trace("parsePredicate(): from=" + n + " to=" + n2 + " [" + token + "," + token2 + "," + token3 + ", ...]");
            if (token.type == 9 && (token2 != null ? token2.type : 0) == 8 && token3 != null) {
                Object object = this.parsePredicate_rvalue(tokenList, n3 + 2, n2);
                return new Expr(token2.op, new Expr(23, token.value), object);
            }
            if (token.type == 10 && (token2 != null ? token2.type : 0) == 8 && token3 != null) {
                Object object = this.parsePredicate_rvalue(tokenList, n3 + 2, n2);
                return new Expr(token2.op, new Expr(22, token.value), object);
            }
            this.parseError(tokenList, n, n2);
        }
        return null;
    }

    Object parsePredicate_rvalue(TokenList tokenList, int n, int n2) throws JNCException {
        int n3 = n;
        while (n3 < n2) {
            Token token = tokenList.getToken(n3);
            Token token2 = n3 + 1 < n2 ? tokenList.getToken(n3 + 1) : null;
            Token token3 = n3 + 2 < n2 ? tokenList.getToken(n3 + 2) : null;
            Path.trace("parsePredicate_rvalue(): from=" + n + " to=" + n2 + " [" + token + "," + token2 + "," + token3 + ", ...]");
            if (token.type == 9 && token2 == null) {
                return new Expr(23, token.value);
            }
            if (token.type == 10 && token2 == null) {
                return new Expr(22, token.value);
            }
            if (token.type == 12 && token2 == null) {
                return token.value;
            }
            if (token.type == 11 && token2 == null) {
                return token.value;
            }
            this.parseError(tokenList, n, n2);
        }
        return null;
    }

    void parseError(TokenList tokenList) throws JNCException {
        this.parseError(tokenList, 0, 5);
    }

    void parseError(TokenList tokenList, int n, int n2) throws JNCException {
        String string = "parse error: \"";
        int n3 = tokenList.size();
        for (int i = n; i < n2 && i < n3; ++i) {
            string = string + tokenList.getToken((int)i).value;
        }
        string = string + "...\"";
        throw new JNCException(-3, string);
    }

    TokenList tokenize(String string) throws JNCException {
        TokenList tokenList = new TokenList();
        byte[] byArray = string.getBytes();
        int n = 0;
        while (n < string.length()) {
            Object object;
            int n2;
            byte by = n + 1 < byArray.length ? byArray[n + 1] : (byte)0;
            byte by2 = byArray[n];
            if (by2 == 32 || by2 == 9 || by2 == 10) {
                ++n;
                continue;
            }
            if (by2 >= 97 && by2 <= 122 || by2 >= 65 && by2 <= 90 || by2 == 92) {
                boolean bl = by2 == 92;
                for (n2 = n + 1; n2 < byArray.length && (byArray[n2] >= 97 && byArray[n2] <= 122 || byArray[n2] >= 65 && byArray[n2] <= 90 || byArray[n2] >= 48 && byArray[n2] <= 57 || byArray[n2] == 45 || byArray[n2] == 95 || byArray[n2] == 92 || bl); ++n2) {
                    if (byArray[n2] == 92) {
                        bl = true;
                        continue;
                    }
                    if (!bl) continue;
                    bl = false;
                }
                object = new String(byArray, n, n2 - n);
                tokenList.add(new Token(9, ((String)object).replaceAll("\\\\", "")));
                n = n2;
                continue;
            }
            if (by2 == 64 && (by >= 97 && by <= 122 || by >= 65 && by <= 90)) {
                for (n2 = ++n + 1; n2 < byArray.length && (byArray[n2] >= 97 && byArray[n2] <= 122 || byArray[n2] >= 65 && byArray[n2] <= 90 || byArray[n2] >= 48 && byArray[n2] <= 57 || byArray[n2] == 45 || byArray[n2] == 95); ++n2) {
                }
                tokenList.add(new Token(10, new String(byArray, n, n2 - n)));
                n = n2;
                continue;
            }
            if (by2 == 39) {
                for (n2 = ++n; n2 < byArray.length && byArray[n2] != 39; ++n2) {
                }
                if (n2 == byArray.length) {
                    throw new JNCException(-3, "unterminated value: " + new String(byArray, n, byArray.length - n));
                }
                tokenList.add(new Token(12, new String(byArray, n, n2 - n)));
                n = n2 + 1;
                continue;
            }
            if (by2 == 34) {
                for (n2 = ++n; n2 < byArray.length && byArray[n2] != 34; ++n2) {
                }
                if (n2 == byArray.length) {
                    throw new JNCException(-3, "unterminated value: " + new String(byArray, n, byArray.length - n));
                }
                tokenList.add(new Token(12, new String(byArray, n, n2 - n)));
                n = n2 + 1;
                continue;
            }
            if (by2 >= 48 && by2 <= 57) {
                String string2;
                for (n2 = n + 1; n2 < byArray.length && byArray[n2] >= 48 && byArray[n2] <= 57; ++n2) {
                }
                if (n2 + 1 < byArray.length && byArray[n2] == 46 && byArray[n2 + 1] >= 48 && byArray[n2 + 1] <= 57) {
                    ++n2;
                    while (n2 < byArray.length && byArray[n2] >= 48 && byArray[n2] <= 57) {
                        ++n2;
                    }
                    string2 = new String(byArray, n, n2 - n);
                    object = new Float(string2);
                } else {
                    string2 = new String(byArray, n, n2 - n);
                    object = Integer.valueOf(string2);
                }
                tokenList.add(new Token(11, string2, (Number)object));
                n = n2;
                continue;
            }
            if (by2 == 33 && by == 61) {
                tokenList.add(new Token(8, "!="));
                n += 2;
                continue;
            }
            switch (by2) {
                case 91: {
                    tokenList.add(new Token(15, "["));
                    break;
                }
                case 93: {
                    tokenList.add(new Token(16, "]"));
                    break;
                }
                case 47: {
                    if (by == 47) {
                        tokenList.add(new Token(2, "//"));
                        ++n;
                        break;
                    }
                    tokenList.add(new Token(1, "/"));
                    break;
                }
                case 58: {
                    if (by == 58) {
                        tokenList.add(new Token(6, "::"));
                        ++n;
                        break;
                    }
                    tokenList.add(new Token(5, ":"));
                    break;
                }
                case 46: {
                    if (by == 46) {
                        tokenList.add(new Token(4, ".."));
                        ++n;
                        break;
                    }
                    tokenList.add(new Token(3, "."));
                    break;
                }
                case 44: {
                    tokenList.add(new Token(17, ","));
                    break;
                }
                case 42: 
                case 43: 
                case 45: {
                    tokenList.add(new Token(7, new String(new byte[]{by2})));
                    break;
                }
                case 61: {
                    if (by == 62) {
                        tokenList.add(new Token(8, 6, ">="));
                        ++n;
                        break;
                    }
                    if (by == 60) {
                        tokenList.add(new Token(8, 8, "<="));
                        ++n;
                        break;
                    }
                    tokenList.add(new Token(8, 3, "="));
                    break;
                }
                case 62: {
                    if (by == 61) {
                        tokenList.add(new Token(8, 6, ">="));
                        ++n;
                        break;
                    }
                    tokenList.add(new Token(8, 5, ">"));
                    break;
                }
                case 60: {
                    if (by == 61) {
                        tokenList.add(new Token(8, 8, "<="));
                        ++n;
                        break;
                    }
                    tokenList.add(new Token(8, 7, "="));
                    break;
                }
                default: {
                    throw new JNCException(-3, "illegal character in expression: " + by2);
                }
            }
            ++n;
        }
        Path.trace("tokenize() -> " + tokenList);
        return tokenList;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Path[");
        for (LocationStep locationStep : this.locationSteps) {
            stringBuffer.append(locationStep);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private static void trace(String string) {
        if (Element.debugLevel >= 3) {
            System.err.println("*Path: " + string);
        }
    }

    class Token {
        int type;
        int op;
        String value;
        Number number;

        Token() {
        }

        Token(int n, String string) {
            this.type = n;
            this.value = string;
        }

        Token(int n, String string, Number number) {
            this.type = n;
            this.value = string;
            this.number = number;
        }

        Token(int n, int n2, String string) {
            this.type = n;
            this.op = n2;
            this.value = string;
        }

        public String toString() {
            switch (this.type) {
                case 1: {
                    return "SLASH";
                }
                case 2: {
                    return "SLASHSLASH";
                }
                case 3: {
                    return "DOT";
                }
                case 4: {
                    return "DOTDOT";
                }
                case 5: {
                    return "COLON";
                }
                case 6: {
                    return "COLONCOLON";
                }
                case 7: {
                    return "OP(" + this.value + ")";
                }
                case 8: {
                    return "COMPARE(" + this.value + ")";
                }
                case 9: {
                    return "ATOM(" + this.value + ")";
                }
                case 10: {
                    return "ATTR(" + this.value + ")";
                }
                case 11: {
                    return "NUMBER(" + this.value + ")";
                }
                case 12: {
                    return "STRING(" + this.value + ")";
                }
                case 13: {
                    return "LBRACER";
                }
                case 14: {
                    return "RBRACER";
                }
                case 15: {
                    return "LPRED";
                }
                case 16: {
                    return "RPRED";
                }
                case 17: {
                    return "COMMA";
                }
            }
            return "UNKOWN(type=" + this.type + ",value=" + this.value + ")";
        }
    }

    class TokenList
    extends ArrayList<Token> {
        private static final long serialVersionUID = 1L;

        TokenList() {
        }

        public Token getToken(int n) {
            return (Token)super.get(n);
        }

        @Override
        public void removeRange(int n, int n2) {
            super.removeRange(n, n2);
        }

        @Override
        public String toString() {
            String string = "TokenList[";
            boolean bl = false;
            for (int i = 0; i < this.size(); ++i) {
                if (bl) {
                    string = string + ",";
                }
                string = string + this.getToken(i);
                bl = true;
            }
            string = string + "]";
            return string;
        }
    }

    class Expr {
        int op;
        Object lvalue;
        Object rvalue;

        Expr(int n, Object object) {
            this.op = n;
            this.lvalue = object;
        }

        Expr(int n, Object object, Object object2) {
            this.op = n;
            this.lvalue = object;
            this.rvalue = object2;
        }

        public Boolean eval(Element element, NodeSet nodeSet) throws JNCException {
            return this.f_boolean(this.eval2(element, nodeSet));
        }

        private Object eval2(Element element, NodeSet nodeSet) throws JNCException {
            Object object = this.lvalue;
            Object object2 = this.rvalue;
            if (object instanceof Expr) {
                object = ((Expr)object).eval2(element, nodeSet);
            }
            if (object2 instanceof Expr) {
                object2 = ((Expr)object2).eval(element, nodeSet);
            }
            switch (this.op) {
                case 22: {
                    return element.getAttrValue((String)object);
                }
                case 23: {
                    return element.getValueOfChild((String)object);
                }
                case 2: {
                    if (this.f_boolean(object).booleanValue()) {
                        return true;
                    }
                    return this.f_boolean(object2);
                }
                case 1: {
                    if (!this.f_boolean(object).booleanValue()) {
                        return false;
                    }
                    return this.f_boolean(object2);
                }
                case 3: 
                case 4: {
                    if (this.isBoolean(object)) {
                        object2 = this.f_boolean(object2);
                    } else if (this.isBoolean(object2)) {
                        object = this.f_boolean(object);
                    } else if (this.isNumber(object)) {
                        object2 = this.f_number(object2);
                    } else if (this.isNumber(object2)) {
                        object = this.f_number(object);
                    } else {
                        object = this.f_string(object);
                        object2 = this.f_string(object2);
                    }
                    if (this.op == 3) {
                        return this.compare(object, object2) == 0;
                    }
                    return this.compare(object, object2) != 0;
                }
                case 5: {
                    return this.compare(this.f_number(object), this.f_number(object2)) > 0;
                }
                case 6: {
                    return this.compare(this.f_number(object), this.f_number(object2)) >= 0;
                }
                case 7: {
                    return this.compare(this.f_number(object), this.f_number(object2)) < 0;
                }
                case 8: {
                    return this.compare(this.f_number(object), this.f_number(object2)) <= 0;
                }
                case 13: {
                    return this.f_string(object);
                }
                case 12: {
                    return this.f_number(object);
                }
                case 11: {
                    return this.f_boolean(object);
                }
                case 14: {
                    return nodeSet.indexOf(element) + 1;
                }
                case 15: {
                    return nodeSet.size();
                }
                case 16: {
                    return this.f_nodeSet(object).size();
                }
                case 17: {
                    return this.f_string(object) + this.f_string(object2);
                }
                case 18: {
                    return this.f_boolean(object) == false;
                }
                case 19: {
                    return true;
                }
                case 20: {
                    return false;
                }
                case 21: {
                    return this.neg(this.f_number(object));
                }
                case 10: {
                    return this.minus(this.f_number(object), this.f_number(object2));
                }
                case 9: {
                    return this.plus(this.f_number(object), this.f_number(object2));
                }
            }
            throw new JNCException(-3, "illegal operator: " + this.op);
        }

        private int compare(Object object, Object object2) throws JNCException {
            if (object instanceof Boolean && object2 instanceof Boolean) {
                if (((Boolean)object).booleanValue() == ((Boolean)object2).booleanValue()) {
                    return 0;
                }
                return -1;
            }
            if (object instanceof Integer && object2 instanceof Integer) {
                return ((Integer)object).compareTo((Integer)object2);
            }
            if (object instanceof Number) {
                return ((Float)object).compareTo(this.f_float(object2));
            }
            if (object instanceof String && object2 instanceof String) {
                if (((String)object).equals(object2)) {
                    return 0;
                }
                return -1;
            }
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            throw new JNCException(-3, "badarg to compare (not of same type): " + object + ", " + object2);
        }

        private boolean isBoolean(Object object) {
            return object instanceof Boolean;
        }

        private boolean isNumber(Object object) {
            return object instanceof Float || object instanceof Integer;
        }

        private Boolean f_boolean(Object object) throws JNCException {
            if (object instanceof Float) {
                float f = ((Float)object).floatValue();
                return (double)f > 1.0E-6 || (double)f < 1.0E-6;
            }
            if (object instanceof Integer) {
                int n = (Integer)object;
                return n != 0;
            }
            if (object instanceof String) {
                return ((String)object).length() > 0;
            }
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            if (object == null) {
                return null;
            }
            throw new JNCException(-3, "badarg to function boolean(): " + object);
        }

        private Number f_number(Object object) throws JNCException {
            if (object instanceof Float) {
                return (Float)object;
            }
            if (object instanceof Integer) {
                return (Integer)object;
            }
            if (object instanceof Boolean) {
                return (Boolean)object != false ? 1 : 0;
            }
            if (object instanceof String) {
                String string = (String)object;
                try {
                    return Integer.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        return new Float(string);
                    }
                    catch (NumberFormatException numberFormatException2) {
                        return new Float(Float.NaN);
                    }
                }
            }
            if (object instanceof NodeSet) {
                return this.f_number(this.f_string(object));
            }
            if (object == null) {
                return null;
            }
            throw new JNCException(-3, "badarg to function number(): " + object);
        }

        private NodeSet f_nodeSet(Object object) throws JNCException {
            if (object instanceof NodeSet) {
                return (NodeSet)object;
            }
            if (object == null) {
                return null;
            }
            throw new JNCException(-3, "badarg to function nodeset(): " + object);
        }

        private Number neg(Object object) throws JNCException {
            if (object instanceof Integer) {
                return -((Integer)object).intValue();
            }
            if (object instanceof Float) {
                return new Float(-((Float)object).floatValue());
            }
            throw new JNCException(-3, "badarg to function neg(): " + object);
        }

        private Number minus(Number number, Number number2) throws JNCException {
            if (number instanceof Integer && number2 instanceof Integer) {
                return (Integer)number - (Integer)number2;
            }
            Float f = this.f_float(number);
            Float f2 = this.f_float(number2);
            return new Float(f.floatValue() - f2.floatValue());
        }

        private Number plus(Number number, Number number2) throws JNCException {
            if (number instanceof Integer && number2 instanceof Integer) {
                return (Integer)number + (Integer)number2;
            }
            Float f = this.f_float(number);
            Float f2 = this.f_float(number2);
            return new Float(f.floatValue() + f2.floatValue());
        }

        private Float f_float(Object object) throws JNCException {
            if (object instanceof Float) {
                return (Float)object;
            }
            if (object instanceof Integer) {
                return new Float(((Integer)object).floatValue());
            }
            if (object == null) {
                return null;
            }
            throw new JNCException(-3, "badarg to function float(): " + object);
        }

        private String f_string(Object object) throws JNCException {
            if (object instanceof Integer) {
                return ((Integer)object).toString();
            }
            if (object instanceof Float) {
                return ((Float)object).toString();
            }
            if (object instanceof String) {
                return (String)object;
            }
            if (object instanceof Boolean) {
                return (Boolean)object != false ? "true" : "false";
            }
            if (object == null) {
                return null;
            }
            return object.toString();
        }

        Object evalCreate(Element element) throws JNCException {
            this.trace("evalCreate(): Expr= " + this);
            Object object = this.lvalue;
            Object object2 = this.rvalue;
            if (object instanceof Expr) {
                object = ((Expr)object).evalCreate(element);
            }
            switch (this.op) {
                case 23: {
                    String string = (String)object;
                    String string2 = element.namespace;
                    Element element2 = new Element(string2, string);
                    element.addChild(element2);
                    return element2;
                }
                case 22: {
                    String string = (String)object;
                    return element.setAttr(string, "");
                }
                case 3: {
                    if (object instanceof Element) {
                        Element element3 = (Element)object;
                        element3.setValue(this.f_string(object2));
                        return element3;
                    }
                    if (object instanceof Attribute) {
                        Attribute attribute = (Attribute)object;
                        attribute.setValue(this.f_string(object2));
                        return attribute;
                    }
                    throw new JNCException(-4, "illegal path create expr: " + this);
                }
            }
            throw new JNCException(-4, "illegal path create expr:" + this);
        }

        public String toString() {
            switch (this.op) {
                case 1: {
                    return "AND(" + this.lvalue + "," + this.rvalue + ")";
                }
                case 2: {
                    return "OR(" + this.lvalue + "," + this.rvalue + ")";
                }
                case 3: {
                    return "EQ(" + this.lvalue + "," + this.rvalue + ")";
                }
                case 4: {
                    return "NEQ(" + this.lvalue + "," + this.rvalue + ")";
                }
                case 5: {
                    return "GT(" + this.lvalue + "," + this.rvalue + ")";
                }
                case 6: {
                    return "GTE(" + this.lvalue + "," + this.rvalue + ")";
                }
                case 7: {
                    return "LT(" + this.lvalue + "," + this.rvalue + ")";
                }
                case 8: {
                    return "LTE(" + this.lvalue + "," + this.rvalue + ")";
                }
                case 9: {
                    return "PLUS(" + this.lvalue + "," + this.rvalue + ")";
                }
                case 10: {
                    return "MINUS(" + this.lvalue + "," + this.rvalue + ")";
                }
                case 11: {
                    return "FUN_BOOLEAN(" + this.lvalue + ")";
                }
                case 12: {
                    return "FUN_NUMBER(" + this.lvalue + ")";
                }
                case 13: {
                    return "FUN_STRING(" + this.lvalue + ")";
                }
                case 14: {
                    return "FUN_POSITION()";
                }
                case 15: {
                    return "FUN_LAST()";
                }
                case 16: {
                    return "FUN_COUNT(" + this.lvalue + ")";
                }
                case 17: {
                    return "FUN_COUNT(" + this.lvalue + "," + this.rvalue + ")";
                }
                case 18: {
                    return "FUN_NOT(" + this.lvalue + ")";
                }
                case 19: {
                    return "FUN_TRUE()";
                }
                case 20: {
                    return "FUN_FALSE()";
                }
                case 21: {
                    return "FUN_NEG(" + this.lvalue + ")";
                }
                case 22: {
                    return "ATTR_VALUE(" + this.lvalue + ")";
                }
                case 23: {
                    return "CHILD_VALUE(" + this.lvalue + ")";
                }
            }
            return "Expr{op=" + this.op + "," + this.lvalue + "," + this.rvalue + "}";
        }

        private void trace(String string) {
            if (Element.debugLevel >= 3) {
                System.err.println("*Expr: " + string);
            }
        }
    }

    class LocationStep {
        int axis;
        String name;
        String prefix;
        ArrayList<Expr> predicates;

        LocationStep(int n) {
            this.axis = n;
        }

        LocationStep(int n, String string) {
            this.axis = n;
            this.name = string;
        }

        LocationStep(int n, String string, String string2) {
            this.axis = n;
            this.prefix = string;
            this.name = string2;
        }

        NodeSet step(NodeSet nodeSet) throws JNCException {
            NodeSet nodeSet2 = new NodeSet();
            block5: for (int i = 0; i < nodeSet.size(); ++i) {
                Element element = nodeSet.getElement(i);
                switch (this.axis) {
                    case 1: {
                        if (element.children == null) continue block5;
                        nodeSet2.addAll(this.nodeTest(element.children));
                        continue block5;
                    }
                    case 3: {
                        if (element.parent == null) continue block5;
                        nodeSet2.addAll(this.nodeTest(new NodeSet(element.parent)));
                        continue block5;
                    }
                    case 2: {
                        nodeSet2.addAll(this.nodeTest(new NodeSet(element)));
                    }
                }
            }
            return nodeSet2;
        }

        private NodeSet nodeTest(NodeSet nodeSet) throws JNCException {
            Object object;
            NodeSet nodeSet2 = new NodeSet();
            for (int i = 0; i < nodeSet.size(); ++i) {
                Element element = nodeSet.getElement(i);
                if (!element.name.equals(this.name)) continue;
                if (this.prefix != null) {
                    object = element.lookupContextPrefix(this.prefix);
                    if (!element.namespace.equals(object)) continue;
                    nodeSet2.add(element);
                    continue;
                }
                nodeSet2.add(element);
            }
            if (nodeSet2.size() == 0) {
                return nodeSet2;
            }
            if (this.predicates != null) {
                for (int i = 0; i < this.predicates.size(); ++i) {
                    object = this.predicates.get(i);
                    NodeSet nodeSet3 = nodeSet2;
                    nodeSet2 = new NodeSet();
                    for (int j = 0; j < nodeSet3.size(); ++j) {
                        Element element = nodeSet3.getElement(j);
                        if (!((Expr)object).eval(element, nodeSet3).booleanValue()) continue;
                        nodeSet2.add(element);
                    }
                }
            }
            return nodeSet2;
        }

        Element createElem(PrefixMap prefixMap, Element element) throws JNCException {
            this.trace("createElem() from " + this);
            switch (this.axis) {
                case 4: {
                    return null;
                }
                case 1: {
                    String string = this.prefix == null ? (element != null ? element.namespace : prefixMap.prefixToNs("")) : prefixMap.prefixToNs(this.prefix);
                    if (string == null) {
                        throw new JNCException(-4, "missing namespace for prefix: \"" + this.prefix + "\"");
                    }
                    Element element2 = new Element(string, this.name);
                    if (this.predicates != null) {
                        for (int i = 0; i < this.predicates.size(); ++i) {
                            Expr expr = this.predicates.get(i);
                            expr.evalCreate(element2);
                        }
                    }
                    return element2;
                }
            }
            throw new JNCException(-4, "unknown axis in create path");
        }

        public String toString() {
            String string = "LocationStep{";
            switch (this.axis) {
                case 1: {
                    string = string + "AXIS_CHILD";
                    break;
                }
                case 3: {
                    string = string + "AXIS_PARENT";
                    break;
                }
                case 2: {
                    string = string + "AXIS_SELF";
                    break;
                }
                case 4: {
                    string = string + "AXIS_ROOT";
                    break;
                }
                default: {
                    string = string + "AXIS_UNKNOWN(" + this.axis + ")";
                }
            }
            if (this.prefix != null) {
                string = string + ",prefix=" + this.prefix;
            }
            if (this.name != null) {
                string = string + ",name=" + this.name;
            }
            if (this.predicates != null && this.predicates.size() > 0) {
                string = string + "," + this.predicates;
            }
            string = string + "}";
            return string;
        }

        private void trace(String string) {
            if (Element.debugLevel >= 3) {
                System.err.println("*LocationStep: " + string);
            }
        }
    }
}

