/*
 * Decompiled with CFR 0.152.
 */
package com.tailf.jnc;

import com.tailf.jnc.YangException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

final class Utils {
    public static final double EPSILON = 1.0E-17;

    Utils() {
    }

    public static BigDecimal bigDecimalValueOf(Number number) {
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof BigInteger) {
            return new BigDecimal((BigInteger)number);
        }
        if (number instanceof Double) {
            return new BigDecimal((Double)number);
        }
        if (number instanceof Float) {
            return new BigDecimal(((Float)number).floatValue());
        }
        return number == null ? null : new BigDecimal(number.longValue());
    }

    public static void restrict(Object object, Number number, Operator operator) throws YangException {
        if (object instanceof Number) {
            Utils.restrict((Number)object, Utils.bigDecimalValueOf(number), operator);
        } else if (object instanceof String) {
            Utils.restrict(((String)object).length(), Utils.bigDecimalValueOf(number), operator);
        } else {
            YangException.throwException(true, object);
        }
    }

    public static void restrict(Number number, BigDecimal bigDecimal, Operator operator) throws YangException {
        YangException.throwException(!operator.cmp(Utils.bigDecimalValueOf(number), bigDecimal), number);
    }

    public static String wsCollapse(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.replaceAll(" +", " ");
        int n = string2.startsWith(" ") ? 1 : 0;
        int n2 = string2.length() > 1 && string2.endsWith(" ") ? -1 : 0;
        return string2.substring(n, string2.length() + n2);
    }

    public static String wsReplace(String string) {
        return string == null ? null : string.replaceAll("[\t\n\r]", " ");
    }

    public static boolean matches(String string, String[] stringArray) throws YangException {
        boolean bl = true;
        try {
            for (int i = 0; i < stringArray.length && (bl = Pattern.matches(stringArray[i], string)); ++i) {
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            YangException.throwException(true, patternSyntaxException);
        }
        return bl;
    }

    public static enum Operator {
        EQ{

            @Override
            public boolean cmp(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
                return bigDecimal.subtract(bigDecimal2).abs().doubleValue() < 1.0E-17;
            }
        }
        ,
        GR{

            @Override
            public boolean cmp(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
                return bigDecimal.subtract(bigDecimal2).doubleValue() > 0.0;
            }
        }
        ,
        GE{

            @Override
            public boolean cmp(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
                return bigDecimal.subtract(bigDecimal2).doubleValue() > -1.0E-17;
            }
        }
        ,
        LT{

            @Override
            public boolean cmp(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
                return bigDecimal.subtract(bigDecimal2).doubleValue() < 0.0;
            }
        }
        ,
        LE{

            @Override
            public boolean cmp(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
                return bigDecimal.subtract(bigDecimal2).doubleValue() < 1.0E-17;
            }
        };


        public abstract boolean cmp(BigDecimal var1, BigDecimal var2);
    }
}

