/*
 * Decompiled with CFR 0.152.
 */
package com.tailf.jnc;

import com.tailf.jnc.Utils;
import com.tailf.jnc.YangException;
import com.tailf.jnc.YangType;
import java.io.Serializable;
import java.math.BigDecimal;

abstract class YangBaseType<T>
implements YangType<T> {
    private static final long serialVersionUID = 1L;
    protected T value;

    public YangBaseType() {
    }

    public YangBaseType(String string) throws YangException {
        this.setValue(string);
    }

    public YangBaseType(T t) throws YangException {
        this.setValue(t);
    }

    @Override
    public void setValue(String string) throws YangException {
        string = Utils.wsCollapse(string);
        this.setValue(this.fromString(string));
    }

    @Override
    public void setValue(T t) throws YangException {
        assert (!(t instanceof YangType)) : "Avoid circular value chain";
        YangException.throwException(t == null, new NullPointerException());
        this.value = t;
        this.check();
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void check() throws YangException {
        YangException.throwException(this.value == null, new NullPointerException());
    }

    public String toString() {
        return this.value.toString();
    }

    protected abstract T fromString(String var1) throws YangException;

    public boolean equals(Object object) {
        Serializable serializable;
        if (this.value == null || !this.canEqual(object)) {
            return false;
        }
        if (object instanceof YangBaseType) {
            serializable = (YangBaseType)object;
            if (!serializable.canEqual(this)) {
                return false;
            }
            object = ((YangBaseType)serializable).getValue();
        }
        if (this.value instanceof Number && object instanceof Number) {
            BigDecimal bigDecimal;
            serializable = Utils.bigDecimalValueOf((Number)this.value);
            return ((BigDecimal)serializable).compareTo(bigDecimal = Utils.bigDecimalValueOf((Number)object)) == 0;
        }
        return this.value.equals(object);
    }

    public int hashCode() {
        if (this.value == null) {
            return 0;
        }
        return this.value.hashCode();
    }

    protected abstract YangBaseType<T> cloneShallow() throws YangException;

    @Override
    public YangBaseType<T> clone() {
        YangBaseType<T> yangBaseType;
        try {
            yangBaseType = (YangBaseType<T>)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            try {
                yangBaseType = this.cloneShallow();
            }
            catch (YangException yangException) {
                return null;
            }
        }
        try {
            yangBaseType.setValue(this.toString());
        }
        catch (YangException yangException) {
            return null;
        }
        return yangBaseType;
    }
}

