/*
 * Decompiled with CFR 0.152.
 */
package com.tailf.jnc;

import com.tailf.jnc.Utils;
import com.tailf.jnc.YangBaseType;
import com.tailf.jnc.YangException;

public class YangBinary
extends YangBaseType<String> {
    private static final long serialVersionUID = 1L;

    public YangBinary(String string) throws YangException {
        this.setValue(string);
    }

    public YangBinary(byte[] byArray) {
        this.setValue(byArray);
    }

    @Override
    public void setValue(String string) throws YangException {
        string = Utils.wsCollapse(string);
        try {
            this.value = Base64Coder.encodeString(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            YangException.throwException(true, illegalArgumentException);
        }
    }

    @Override
    public void setValue(byte[] byArray) {
        this.value = new String(byArray);
    }

    @Override
    public void check() throws YangException {
    }

    @Override
    public String toString() {
        return Base64Coder.decodeString((String)this.value);
    }

    @Override
    protected String fromString(String string) throws YangException {
        return Base64Coder.encodeString(string);
    }

    @Override
    public boolean canEqual(Object object) {
        return object instanceof YangBinary;
    }

    protected YangBinary cloneShallow() throws YangException {
        return new YangBinary(this.toString());
    }

    protected void exact(int n) throws YangException {
        Utils.restrict(this.value, n, Utils.Operator.EQ);
    }

    protected void min(int n) throws YangException {
        Utils.restrict(this.value, n, Utils.Operator.GE);
    }

    protected void max(int n) throws YangException {
        Utils.restrict(this.value, n, Utils.Operator.LE);
    }

    private static class Base64Coder {
        private static char[] map1;
        private static byte[] map2;

        public static String encodeString(String string) {
            return new String(Base64Coder.encode(string.getBytes()));
        }

        public static char[] encode(byte[] byArray) {
            return Base64Coder.encode(byArray, byArray.length);
        }

        public static char[] encode(byte[] byArray, int n) {
            int n2 = (n * 4 + 2) / 3;
            int n3 = (n + 2) / 3 * 4;
            char[] cArray = new char[n3];
            int n4 = 0;
            int n5 = 0;
            while (n4 < n) {
                int n6 = byArray[n4++] & 0xFF;
                int n7 = n4 < n ? byArray[n4++] & 0xFF : 0;
                int n8 = n4 < n ? byArray[n4++] & 0xFF : 0;
                int n9 = n6 >>> 2;
                int n10 = (n6 & 3) << 4 | n7 >>> 4;
                int n11 = (n7 & 0xF) << 2 | n8 >>> 6;
                int n12 = n8 & 0x3F;
                cArray[n5++] = map1[n9];
                cArray[n5++] = map1[n10];
                cArray[n5] = n5 < n2 ? map1[n11] : 61;
                int n13 = ++n5 < n2 ? map1[n12] : 61;
                cArray[n5] = n13;
                ++n5;
            }
            return cArray;
        }

        public static String decodeString(String string) {
            return new String(Base64Coder.decode(string));
        }

        public static byte[] decode(String string) {
            return Base64Coder.decode(string.toCharArray());
        }

        public static byte[] decode(char[] cArray) {
            int n = cArray.length;
            if (n % 4 != 0) {
                throw new IllegalArgumentException("Length of Base64 encoded input string is not a multiple of 4.");
            }
            while (n > 0 && cArray[n - 1] == '=') {
                --n;
            }
            int n2 = n * 3 / 4;
            byte[] byArray = new byte[n2];
            int n3 = 0;
            int n4 = 0;
            while (n3 < n) {
                int n5;
                char c = cArray[n3++];
                char c2 = cArray[n3++];
                int n6 = n3 < n ? cArray[n3++] : 65;
                int n7 = n5 = n3 < n ? cArray[n3++] : 65;
                if (c > '\u007f' || c2 > '\u007f' || n6 > 127 || n5 > 127) {
                    throw new IllegalArgumentException("Illegal character in Base64 encoded data.");
                }
                byte by = map2[c];
                byte by2 = map2[c2];
                byte by3 = map2[n6];
                byte by4 = map2[n5];
                if (by < 0 || by2 < 0 || by3 < 0 || by4 < 0) {
                    throw new IllegalArgumentException("Illegal character in Base64 encoded data.");
                }
                int n8 = by << 2 | by2 >>> 4;
                int n9 = (by2 & 0xF) << 4 | by3 >>> 2;
                int n10 = (by3 & 3) << 6 | by4;
                byArray[n4++] = (byte)n8;
                if (n4 < n2) {
                    byArray[n4++] = (byte)n9;
                }
                if (n4 >= n2) continue;
                byArray[n4++] = (byte)n10;
            }
            return byArray;
        }

        private Base64Coder() {
        }

        static {
            int n;
            map1 = new char[64];
            int n2 = 0;
            for (n = 65; n <= 90; n = (int)((char)(n + 1))) {
                Base64Coder.map1[n2++] = n;
            }
            for (n = 97; n <= 122; n = (int)((char)(n + 1))) {
                Base64Coder.map1[n2++] = n;
            }
            for (n = 48; n <= 57; n = (int)((char)(n + 1))) {
                Base64Coder.map1[n2++] = n;
            }
            Base64Coder.map1[n2++] = 43;
            Base64Coder.map1[n2] = 47;
            map2 = new byte[128];
            for (n2 = 0; n2 < map2.length; ++n2) {
                Base64Coder.map2[n2] = -1;
            }
            for (n2 = 0; n2 < 64; ++n2) {
                Base64Coder.map2[Base64Coder.map1[n2]] = (byte)n2;
            }
        }
    }
}

