/*
 * Decompiled with CFR 0.152.
 */
package com.tailf.jnc;

import com.tailf.jnc.Utils;
import com.tailf.jnc.YangBaseInt;
import com.tailf.jnc.YangException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.StringTokenizer;

public class YangBits
extends YangBaseInt<BigInteger> {
    private static final long serialVersionUID = 1L;
    private String[] smap;
    private int[] imap;
    private BigInteger mask;

    public YangBits(String string, Number number, String[] stringArray, int[] nArray) throws YangException {
        super(string);
        YangException.throwException(stringArray.length != nArray.length, string);
        this.mask = Utils.bigDecimalValueOf(number).toBigIntegerExact();
        this.smap = stringArray;
        this.imap = nArray;
        this.setValue(string);
    }

    public YangBits(Number number, Number number2, String[] stringArray, int[] nArray) throws YangException {
        super(Utils.bigDecimalValueOf(number).toBigIntegerExact());
        YangException.throwException(stringArray.length != nArray.length, number);
        this.mask = Utils.bigDecimalValueOf(number2).toBigIntegerExact();
        this.smap = stringArray;
        this.imap = nArray;
        this.check();
    }

    @Override
    public void check() throws YangException {
        if (this.mask == null) {
            return;
        }
        super.check();
        boolean bl = this.mask.or((BigInteger)this.value).compareTo(this.mask) != 0;
        YangException.throwException(bl, this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.imap.length; ++i) {
            BigInteger bigInteger = BigInteger.ONE.shiftLeft(this.imap[i]);
            if (((BigInteger)this.value).and(bigInteger).equals(BigInteger.ZERO)) continue;
            stringBuffer.append(this.smap[i]);
            if (i >= this.imap.length - 1) continue;
            stringBuffer.append(" ");
        }
        return Utils.wsCollapse(stringBuffer.toString());
    }

    @Override
    public boolean canEqual(Object object) {
        return object instanceof YangBits;
    }

    @Override
    public int hashCode() {
        int n = Arrays.hashCode(this.smap) + Arrays.hashCode(this.imap);
        return super.hashCode() + this.mask.hashCode() + n;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        YangBits yangBits = (YangBits)object;
        if (!yangBits.mask.equals(this.mask) || yangBits.smap.length != this.smap.length || yangBits.imap.length != this.imap.length) {
            return false;
        }
        for (int i = 0; i < this.smap.length; ++i) {
            if (this.smap[i].equals(yangBits.smap[i]) && this.imap[i] == yangBits.imap[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    protected BigInteger decode(String string) throws NumberFormatException {
        if (this.smap == null || this.imap == null) {
            return BigInteger.ONE.negate();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        BigInteger bigInteger = BigInteger.ZERO;
        while (stringTokenizer.hasMoreTokens()) {
            boolean bl = false;
            String string2 = stringTokenizer.nextToken();
            for (int i = 0; i < this.smap.length; ++i) {
                if (string2.compareTo(this.smap[i]) != 0) continue;
                bl = true;
                bigInteger = bigInteger.add(BigInteger.ONE.shiftLeft(this.imap[i]));
            }
            if (bl) continue;
            throw new NumberFormatException(string2 + " not found");
        }
        return bigInteger;
    }

    protected YangBits cloneShallow() throws YangException {
        return new YangBits(((BigInteger)this.value).toString(), (Number)this.mask, this.smap, this.imap);
    }

    public void AND(YangBits yangBits) {
        this.value = ((BigInteger)this.value).and((BigInteger)yangBits.getValue());
    }

    public void OR(YangBits yangBits) {
        this.value = ((BigInteger)this.value).or((BigInteger)yangBits.getValue());
    }

    public void XOR(YangBits yangBits) {
        this.value = ((BigInteger)this.value).xor((BigInteger)yangBits.getValue());
    }
}

