/*
 * Decompiled with CFR 0.152.
 */
package com.tailf.jnc;

import com.tailf.jnc.Capabilities;
import com.tailf.jnc.DummyElement;
import com.tailf.jnc.Element;
import com.tailf.jnc.ElementHandler;
import com.tailf.jnc.JNCException;
import com.tailf.jnc.Leaf;
import com.tailf.jnc.NodeSet;
import com.tailf.jnc.RevisionInfo;
import com.tailf.jnc.SchemaNode;
import com.tailf.jnc.SchemaTree;
import com.tailf.jnc.Tagpath;
import com.tailf.jnc.Transport;
import com.tailf.jnc.YangException;
import com.tailf.jnc.YangXMLParser;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

public abstract class YangElement
extends Element {
    private static final long serialVersionUID = 1L;
    private static final String[] reservedWords = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"};
    public static final String COLON_UNEXPECTED_ELEMENT = ": Unexpected element";
    public static final String DUMMY = "DUMMY";
    public static final String DUMMY_LC = "dummy";
    static ArrayList<Package> packages = new ArrayList();
    private Tagpath tp = null;
    private SchemaNode n = null;

    protected abstract String[] childrenNames();

    protected abstract String[] keyNames();

    public YangElement(String string, String string2) {
        super(string, string2);
    }

    private static String getPackage(Element element) {
        if (element instanceof YangElement) {
            YangElement yangElement = (YangElement)element;
            if (yangElement.parent instanceof YangElement) {
                String string = YangElement.getPackage(yangElement.parent);
                if (!string.equals("")) {
                    string = string + ".";
                }
                return string + YangElement.camelize(yangElement.name);
            }
        }
        return "";
    }

    private static Element instantiate(Element element, String string, String string2) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String string3 = string2 + "." + YangElement.getPackage(element) + YangElement.normalize(string);
        Class<?> clazz = Class.forName(string3);
        return (Element)clazz.newInstance();
    }

    protected static Element createInstance(ElementHandler elementHandler, Element element, String string, String string2) throws YangException {
        String string3 = YangElement.getPackage(string);
        if (string3 == null) {
            Element element2 = new Element(string, string2);
            if (element != null) {
                element.addChild(element2);
            }
            return element2;
        }
        try {
            if (element == null) {
                return YangElement.instantiate(null, string2, string3);
            }
            if (element instanceof YangElement) {
                try {
                    String string4 = "add" + YangElement.normalize(string2);
                    Class<?> clazz = element.getClass();
                    Method method = clazz.getMethod(string4, new Class[0]);
                    return (Element)method.invoke((Object)element, new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (((YangElement)element).isChild(string2)) {
                        return null;
                    }
                    if (!RevisionInfo.newerRevisionSupportEnabled) {
                        throw new YangException(-1025, element.getElementPath(string2) + COLON_UNEXPECTED_ELEMENT);
                    }
                    elementHandler.unknownLevel = 1;
                    return null;
                }
            }
            Element element3 = YangElement.instantiate(element, string2, string3);
            element.addChild(element3);
            return element3;
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            throw new YangException(-1025, (element != null ? element.getElementPath(string2) : null) + COLON_UNEXPECTED_ELEMENT);
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
            throw new YangException(-1025, (element != null ? element.getElementPath(string2) : null) + COLON_UNEXPECTED_ELEMENT);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            throw new YangException(-1025, (element != null ? element.getElementPath(string2) : null) + COLON_UNEXPECTED_ELEMENT);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new YangException(-1025, element.getElementPath(string2) + COLON_UNEXPECTED_ELEMENT);
        }
    }

    public void setLeafValue(String string, String string2, String string3) throws YangException, JNCException {
        String string4 = "set" + YangElement.normalize(string2) + "Value";
        Class[] classArray = new Class[]{String.class};
        try {
            Method method = this.getClass().getMethod(string4, classArray);
            method.invoke((Object)this, string3);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (!RevisionInfo.newerRevisionSupportEnabled) {
                throw new YangException(-1025, this.getElementPath(string2) + COLON_UNEXPECTED_ELEMENT);
            }
            NodeSet nodeSet = this.get(string2);
            if (nodeSet.isEmpty()) {
                Element element = new Element(string, string2);
                element.setValue(string3);
                this.insertLast(element);
            } else {
                Element element = nodeSet.first();
                element.setValue(string3);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            if (!RevisionInfo.newerRevisionSupportEnabled) {
                throw new YangException(-1026, this.getElementPath(string2) + ": " + invocationTargetException.getCause().toString());
            }
            NodeSet nodeSet = this.get(string2);
            if (nodeSet.isEmpty()) {
                Element element = new Element(string, string2);
                element.setValue(string3);
                this.insertLast(element);
            } else {
                Element element = nodeSet.first();
                element.setValue(string3);
            }
        }
        catch (Exception exception) {
            throw new YangException(-1026, this.getElementPath(string2) + ": " + exception.getCause().toString());
        }
    }

    public static String getPackage(String string) {
        if (packages == null) {
            return null;
        }
        for (Package package_ : packages) {
            if (!package_.ns.equals(string)) continue;
            return package_.pkg;
        }
        return null;
    }

    public static void setPackage(String string, String string2) {
        if (packages == null) {
            packages = new ArrayList();
        }
        YangElement.removePackage(string);
        packages.add(new Package(string, string2));
    }

    public static void removePackage(String string) {
        if (packages == null) {
            return;
        }
        for (int i = 0; i < packages.size(); ++i) {
            Package package_ = packages.get(i);
            if (!package_.ns.equals(string)) continue;
            packages.remove(i);
            return;
        }
    }

    private static String capitalize(String string) {
        if (string.isEmpty()) {
            return string;
        }
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    private static boolean isReserved(String string) {
        for (String string2 : reservedWords) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    protected static String camelize(String string) {
        int n;
        int n2 = n = string == null ? 0 : string.length();
        if (n == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        stringBuilder.append(Character.toLowerCase(string.charAt(0)));
        for (int i = 1; i < n; ++i) {
            boolean bl = i == n - 1;
            char c = string.charAt(i);
            char c2 = bl ? c : string.charAt(i + 1);
            boolean bl2 = Character.isUpperCase(c);
            boolean bl3 = Character.isUpperCase(c2);
            boolean bl4 = Character.isLetter(c2);
            if (bl) {
                stringBuilder.append(Character.toLowerCase(c));
                continue;
            }
            if (c == '-' || c == '.') {
                stringBuilder.append(Character.toUpperCase(c2));
                ++i;
                continue;
            }
            if (bl2 && (bl3 || !bl4)) {
                stringBuilder.append(Character.toLowerCase(c));
                continue;
            }
            stringBuilder.append(c);
        }
        string = stringBuilder.toString();
        if (YangElement.isReserved(string)) {
            string = string + "_";
        } else if (string.matches("[0-9]")) {
            string = "_" + string;
        }
        return string;
    }

    protected static String normalize(String string) {
        String string2 = YangElement.camelize(string);
        int n = 0;
        int n2 = string2.length();
        if (string2.startsWith("_")) {
            ++n;
        }
        if (string2.endsWith("_")) {
            --n2;
        }
        if (n2 - n < 0) {
            return "";
        }
        if (n != 0 || n2 != string2.length()) {
            return "J" + YangElement.capitalize(string2.substring(n, n2));
        }
        return YangElement.capitalize(string2);
    }

    protected void setLeafValue(String string, String string2, Object object, String[] stringArray) throws JNCException {
        NodeSet nodeSet = this.get(string2);
        if (nodeSet.isEmpty()) {
            Leaf leaf = new Leaf(string, string2);
            leaf.setValue(object);
            this.insertChild((Element)leaf, stringArray);
        } else {
            Leaf leaf = (Leaf)nodeSet.first();
            leaf.setValue(object);
        }
    }

    protected void setLeafListValue(String string, String string2, Object object, String[] stringArray) throws JNCException {
        Element element = this.get(string2).last();
        if (element instanceof Leaf && element.value == null) {
            element.setValue(object);
        } else {
            Leaf leaf = new Leaf(string, string2);
            leaf.setValue(object);
            this.insertChild((Element)leaf, stringArray);
        }
    }

    protected boolean isLeafDefault(String string) throws JNCException {
        NodeSet nodeSet = this.get(string);
        return nodeSet.isEmpty();
    }

    protected void markLeafReplace(String string) throws JNCException {
        NodeSet nodeSet = this.get(string);
        if (nodeSet.isEmpty()) {
            throw new YangException(-1025, this.getElementPath(string));
        }
        nodeSet.first().markReplace();
    }

    protected void markLeafMerge(String string) throws JNCException {
        NodeSet nodeSet = this.get(string);
        if (nodeSet.isEmpty()) {
            throw new YangException(-1025, this.getElementPath(string));
        }
        nodeSet.first().markMerge();
    }

    protected void markLeafCreate(String string) throws JNCException {
        NodeSet nodeSet = this.get(string);
        if (nodeSet.isEmpty()) {
            throw new YangException(-1025, this.getElementPath(string));
        }
        nodeSet.first().markCreate();
    }

    protected void markLeafDelete(String string) throws JNCException {
        NodeSet nodeSet = this.get(string);
        if (nodeSet.isEmpty()) {
            throw new YangException(-1025, this.getElementPath(string));
        }
        nodeSet.first().markDelete();
    }

    protected YangElement searchOne(String string) throws JNCException {
        NodeSet nodeSet = this.get(string);
        if (nodeSet.isEmpty()) {
            throw new YangException(-1025, this.getElementPath(string));
        }
        return (YangElement)nodeSet.first();
    }

    public boolean keyCompare(YangElement yangElement) {
        if (!this.equals(yangElement)) {
            return false;
        }
        String[] stringArray = this.keyNames();
        if (stringArray == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            Element element;
            Element element2 = this.getChild(stringArray[i]);
            if (element2.equals(element = yangElement.getChild(stringArray[i]))) continue;
            return false;
        }
        return true;
    }

    public int compare(YangElement yangElement) {
        Serializable serializable;
        Object object;
        int n;
        if (!this.equals(yangElement)) {
            return -1;
        }
        String[] stringArray = this.keyNames();
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                object = this.getChild(stringArray[n]);
                if (((Element)object).equals(serializable = yangElement.getChild(stringArray[n]))) continue;
                return -1;
            }
        }
        object = this.childrenNames();
        while (n < ((String[])object).length) {
            serializable = this.getChildren(object[n]);
            NodeSet nodeSet = yangElement.getChildren(object[n]);
            int n2 = 0;
            block2: for (int i = 0; i < ((ArrayList)serializable).size(); ++i) {
                Element element = (Element)((ArrayList)serializable).get(i);
                for (int j = 0; j < nodeSet.size(); ++j) {
                    Element element2 = (Element)nodeSet.get(j);
                    if (!element.equals(element2)) continue;
                    ++n2;
                    continue block2;
                }
            }
            if (((ArrayList)serializable).size() != nodeSet.size() || ((ArrayList)serializable).size() != n2) {
                return 1;
            }
            ++n;
        }
        return 0;
    }

    @Override
    public int compare(Element element) {
        if (element instanceof YangElement) {
            return this.compare((YangElement)element);
        }
        return super.compare(element);
    }

    public static void getDiff(YangElement yangElement, YangElement yangElement2, NodeSet nodeSet, NodeSet nodeSet2, NodeSet nodeSet3, NodeSet nodeSet4) {
        if (yangElement.compare(yangElement2) >= 0) {
            NodeSet nodeSet5 = new NodeSet();
            if (yangElement.children == null || yangElement2.children == null) {
                if (yangElement2.children != null) {
                    nodeSet2.addAll(yangElement2.children);
                } else if (yangElement.children != null) {
                    nodeSet.addAll(yangElement.children);
                }
                return;
            }
            nodeSet5.addAll(yangElement2.children);
            for (int i = 0; i < yangElement.children.size(); ++i) {
                int n;
                Element element = yangElement.children.getElement(i);
                Element element2 = null;
                int n2 = -1;
                for (n = 0; n < nodeSet5.size() && (n2 = element.compare(element2 = nodeSet5.getElement(n))) < 0; ++n) {
                }
                if (n2 >= 0) {
                    nodeSet5.remove(n);
                    if (n2 == 1) {
                        nodeSet3.add(element);
                        nodeSet4.add(element2);
                        continue;
                    }
                    if (!(element instanceof YangElement)) continue;
                    YangElement.getDiff((YangElement)element, (YangElement)element2, nodeSet, nodeSet2, nodeSet3, nodeSet4);
                    continue;
                }
                nodeSet.add(element);
            }
            nodeSet2.addAll(nodeSet5);
        } else {
            nodeSet.add(yangElement);
            nodeSet2.add(yangElement2);
        }
    }

    public boolean checkSync(YangElement yangElement) {
        return YangElement.checkSync(this, yangElement);
    }

    public static boolean checkSync(NodeSet nodeSet, NodeSet nodeSet2) {
        int n;
        DummyElement dummyElement = new DummyElement(DUMMY, DUMMY_LC);
        DummyElement dummyElement2 = new DummyElement(DUMMY, DUMMY_LC);
        for (n = 0; n < nodeSet.size(); ++n) {
            dummyElement.addChild((Element)nodeSet.get(n));
        }
        for (n = 0; n < nodeSet2.size(); ++n) {
            dummyElement2.addChild((Element)nodeSet2.get(n));
        }
        return YangElement.checkSync(dummyElement, dummyElement2);
    }

    public static boolean checkSync(YangElement yangElement, YangElement yangElement2) {
        NodeSet nodeSet = new NodeSet();
        NodeSet nodeSet2 = new NodeSet();
        NodeSet nodeSet3 = new NodeSet();
        NodeSet nodeSet4 = new NodeSet();
        YangElement.getDiff(yangElement, yangElement2, nodeSet, nodeSet2, nodeSet3, nodeSet4);
        boolean bl = nodeSet.isEmpty() && nodeSet2.isEmpty();
        boolean bl2 = nodeSet3.isEmpty() && nodeSet4.isEmpty();
        return bl && bl2;
    }

    public YangElement sync(YangElement yangElement) throws JNCException {
        return YangElement.sync(this, yangElement);
    }

    public static YangElement sync(YangElement yangElement, YangElement yangElement2) throws JNCException {
        Element element;
        int n;
        NodeSet nodeSet = new NodeSet();
        NodeSet nodeSet2 = new NodeSet();
        NodeSet nodeSet3 = new NodeSet();
        NodeSet nodeSet4 = new NodeSet();
        YangElement.getDiff(yangElement, yangElement2, nodeSet, nodeSet2, nodeSet3, nodeSet4);
        Element element2 = null;
        for (n = 0; n < nodeSet.size(); ++n) {
            element = nodeSet.getElement(n);
            element2 = element.merge(element2, 2);
        }
        for (n = 0; n < nodeSet2.size(); ++n) {
            element = nodeSet2.getElement(n);
            element2 = element.merge(element2, 1);
        }
        for (n = 0; n < nodeSet4.size(); ++n) {
            element = nodeSet4.getElement(n);
            element2 = element.merge(element2, 3);
        }
        return (YangElement)element2;
    }

    public static NodeSet syncMerge(NodeSet nodeSet, NodeSet nodeSet2) throws JNCException {
        int n;
        DummyElement dummyElement = new DummyElement(DUMMY, DUMMY_LC);
        DummyElement dummyElement2 = new DummyElement(DUMMY, DUMMY_LC);
        for (n = 0; n < nodeSet.size(); ++n) {
            dummyElement.addChild((Element)nodeSet.get(n));
        }
        for (n = 0; n < nodeSet2.size(); ++n) {
            dummyElement2.addChild((Element)nodeSet2.get(n));
        }
        YangElement yangElement = YangElement.syncMerge(dummyElement, dummyElement2);
        return yangElement.getChildren();
    }

    public static YangElement syncMerge(YangElement yangElement, YangElement yangElement2) {
        YangElement yangElement3 = (YangElement)yangElement2.clone();
        NodeSet nodeSet = new NodeSet();
        YangElement.csync2((YangElement)yangElement.clone(), yangElement3, nodeSet);
        for (int i = 0; i < nodeSet.size(); ++i) {
            Element element = (Element)nodeSet.get(i);
            element.getParent().deleteChild(element);
        }
        return yangElement3;
    }

    private static int csync2(YangElement yangElement, YangElement yangElement2, NodeSet nodeSet) {
        Element element;
        Element element2;
        int n;
        int n2 = 0;
        for (n = 0; yangElement2.children != null && n < yangElement2.children.size(); ++n) {
            element2 = (Element)yangElement2.children.get(n);
            if (yangElement.keyNames() != null && element2 instanceof Leaf && ((Leaf)element2).isKey()) continue;
            element = null;
            if (yangElement.children != null) {
                element = YangElement.findDeleteChild(element2, yangElement.children);
            }
            if (element == null) {
                ++n2;
                continue;
            }
            if (element instanceof YangElement) {
                int n3 = YangElement.csync2((YangElement)element, (YangElement)element2, nodeSet);
                n2 += n3;
                if (n3 != 0) continue;
                nodeSet.add(element2);
                continue;
            }
            if (!(element instanceof Leaf)) continue;
            if (element.equals(element2)) {
                nodeSet.add(element2);
                continue;
            }
            ++n2;
        }
        for (n = 0; yangElement.children != null && n < yangElement.children.size(); ++n) {
            element2 = (Element)yangElement.children.get(n);
            if (element2 instanceof Leaf) {
                element = (Leaf)element2;
                if (((Leaf)element).isKey()) continue;
                ++n2;
                yangElement2.addChild(element2);
                element2.markDelete();
                continue;
            }
            if (!(element2 instanceof YangElement)) continue;
            ++n2;
            element = (YangElement)element2;
            YangElement yangElement3 = (YangElement)((YangElement)element).cloneShallow();
            yangElement2.addChild(yangElement3);
            yangElement3.markDelete();
        }
        return n2;
    }

    private static Element findDeleteChild(Element element, NodeSet nodeSet) {
        if (nodeSet == null) {
            return null;
        }
        if (element instanceof Leaf) {
            return YangElement.findDeleteChildLeaf((Leaf)element, nodeSet);
        }
        if (element instanceof YangElement) {
            return YangElement.deleteChild((YangElement)element, nodeSet);
        }
        return YangElement.findDeleteChildElement(element, nodeSet);
    }

    private static Element findDeleteChildElement(Element element, NodeSet nodeSet) {
        for (int i = 0; i < nodeSet.size(); ++i) {
            Element element2 = (Element)nodeSet.get(i);
            if (element2.compare(element) < 0) continue;
            nodeSet.remove(i);
            return element2;
        }
        return null;
    }

    private static Element deleteChild(YangElement yangElement, NodeSet nodeSet) {
        String[] stringArray = yangElement.keyNames();
        for (int i = 0; i < nodeSet.size(); ++i) {
            Element element = (Element)nodeSet.get(i);
            if (element instanceof Leaf) continue;
            YangElement yangElement2 = (YangElement)element;
            if (stringArray == null) {
                if (!yangElement.equals(element)) continue;
                nodeSet.remove(i);
                return yangElement2;
            }
            if (!yangElement.keyCompare(yangElement2)) continue;
            nodeSet.remove(i);
            return yangElement2;
        }
        return null;
    }

    private static Element findDeleteChildLeaf(Leaf leaf, NodeSet nodeSet) {
        for (int i = 0; i < nodeSet.size(); ++i) {
            Element element = (Element)nodeSet.get(i);
            if (!(element instanceof Leaf) || element.compare(leaf) < 0) continue;
            nodeSet.remove(i);
            return element;
        }
        return null;
    }

    public static NodeSet sync(NodeSet nodeSet, NodeSet nodeSet2) throws JNCException {
        int n;
        DummyElement dummyElement = new DummyElement(DUMMY, DUMMY_LC);
        DummyElement dummyElement2 = new DummyElement(DUMMY, DUMMY_LC);
        for (n = 0; n < nodeSet.size(); ++n) {
            dummyElement.addChild((Element)nodeSet.get(n));
        }
        for (n = 0; n < nodeSet2.size(); ++n) {
            dummyElement2.addChild((Element)nodeSet2.get(n));
        }
        YangElement yangElement = YangElement.sync(dummyElement, dummyElement2);
        return yangElement.getChildren();
    }

    @Override
    protected abstract Element cloneShallow();

    protected YangElement cloneShallowContent(YangElement yangElement) {
        this.cloneAttrs(yangElement);
        return yangElement;
    }

    protected YangElement cloneContent(YangElement yangElement) {
        if (this.children != null) {
            String[] stringArray = this.keyNames();
            int n = 0;
            if (stringArray != null) {
                n = stringArray.length;
            }
            while (n < this.children.size()) {
                Element element = this.children.getElement(n);
                Element element2 = (Element)element.clone();
                yangElement.addChild(element2);
                ++n;
            }
        }
        this.cloneAttrs(yangElement);
        this.cloneValue(yangElement);
        return yangElement;
    }

    public static YangElement readFile(String string) throws JNCException {
        YangXMLParser yangXMLParser = new YangXMLParser();
        return yangXMLParser.readFile(string);
    }

    @Override
    protected void encode(Transport transport, boolean bl, Capabilities capabilities) throws JNCException {
        if (RevisionInfo.olderRevisionSupportEnabled && capabilities != null) {
            if (this.tp == null) {
                this.tp = this.tagpath();
            }
            String string = this.getRootElement().namespace;
            if (this.n == null) {
                this.n = SchemaTree.lookup(string, this.tp);
            }
            String string2 = capabilities.getRevision(string);
            if (this.n.revInfo != null) {
                block5: for (int i = 0; i < this.n.revInfo.length; ++i) {
                    RevisionInfo revisionInfo = this.n.revInfo[i];
                    if (revisionInfo.introduced.compareTo(string2) <= 0) continue;
                    switch (revisionInfo.type) {
                        case 7: {
                            int n = revisionInfo.idata;
                            if (this.getChildren().size() <= n) continue block5;
                            throw new JNCException(-12, this.tp + "too many children for old node " + "with rev( " + string2 + ")");
                        }
                        case 6: {
                            continue block5;
                        }
                        case 8: {
                            return;
                        }
                    }
                }
            }
        }
        super.encode(transport, bl, capabilities);
    }

    public boolean isChild(String string) {
        String[] stringArray = this.childrenNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    static class Package {
        String pkg;
        String ns;

        Package(String string, String string2) {
            this.ns = string;
            this.pkg = string2;
        }
    }
}

