/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.graph;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.graph.AbstractGraphPathSearch;
import org.onlab.graph.AdjacencyListsGraph;
import org.onlab.graph.Graph;
import org.onlab.graph.GraphTest;
import org.onlab.graph.TestEdge;
import org.onlab.graph.TestVertex;
import org.onlab.graph.Vertex;

public abstract class AbstractGraphPathSearchTest
extends GraphTest {
    protected abstract AbstractGraphPathSearch<TestVertex, TestEdge> graphSearch();

    @Test(expected=IllegalArgumentException.class)
    public void noSuchSourceArgument() {
        this.graphSearch().search((Graph)new AdjacencyListsGraph((Set)ImmutableSet.of((Object)B, (Object)C), (Set)ImmutableSet.of((Object)((Object)new TestEdge(B, C, 1.0)))), (Vertex)A, (Vertex)H, this.weight);
    }

    @Test(expected=NullPointerException.class)
    public void nullGraphArgument() {
        this.graphSearch().search(null, (Vertex)A, (Vertex)H, this.weight);
    }

    @Test(expected=NullPointerException.class)
    public void nullSourceArgument() {
        this.graphSearch().search((Graph)new AdjacencyListsGraph((Set)ImmutableSet.of((Object)B, (Object)C), (Set)ImmutableSet.of((Object)((Object)new TestEdge(B, C, 1.0)))), null, (Vertex)H, this.weight);
    }

    @Test
    public void samenessThreshold() {
        AbstractGraphPathSearch<TestVertex, TestEdge> search = this.graphSearch();
        search.setSamenessThreshold(0.3);
        Assert.assertEquals((String)"incorrect threshold", (double)0.3, (double)search.samenessThreshold(), (double)0.01);
    }
}

