/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.graph;

import com.google.common.collect.ImmutableList;
import com.google.common.testing.EqualsTester;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.graph.DefaultPath;
import org.onlab.graph.GraphTest;
import org.onlab.graph.Path;
import org.onlab.graph.TestEdge;
import org.onlab.graph.TestVertex;

public class DefaultPathTest
extends GraphTest {
    @Test
    public void equality() {
        ImmutableList edges = ImmutableList.of((Object)((Object)new TestEdge(A, B, 1.0)), (Object)((Object)new TestEdge(B, C, 1.0)));
        new EqualsTester().addEqualityGroup(new Object[]{new DefaultPath((List)edges, 2.0), new DefaultPath((List)edges, 2.0)}).addEqualityGroup(new Object[]{new DefaultPath((List)edges, 3.0)}).testEquals();
    }

    @Test
    public void basics() {
        DefaultPath p = new DefaultPath((List)ImmutableList.of((Object)((Object)new TestEdge(A, B, 1.0)), (Object)((Object)new TestEdge(B, C, 1.0))), 2.0);
        this.validatePath((Path<TestVertex, TestEdge>)p, A, C, 2, 2.0);
    }

    protected void validatePath(Path<TestVertex, TestEdge> p, TestVertex src, TestVertex dst, int length, double cost) {
        Assert.assertEquals((String)"incorrect path length", (long)length, (long)p.edges().size());
        Assert.assertEquals((String)"incorrect source", (Object)src, (Object)p.src());
        Assert.assertEquals((String)"incorrect destination", (Object)dst, (Object)p.dst());
        Assert.assertEquals((String)"incorrect path cost", (double)cost, (double)p.cost(), (double)0.1);
    }
}

