/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.graph;

import java.util.HashSet;
import org.onlab.graph.AbstractGraphPathSearch;
import org.onlab.graph.Edge;
import org.onlab.graph.EdgeWeight;
import org.onlab.graph.Graph;
import org.onlab.graph.GraphPathSearch;
import org.onlab.graph.Vertex;

public class BreadthFirstSearch<V extends Vertex, E extends Edge<V>>
extends AbstractGraphPathSearch<V, E> {
    @Override
    public GraphPathSearch.Result<V, E> search(Graph<V, E> graph, V src, V dst, EdgeWeight<V, E> weight) {
        this.checkArguments(graph, src, dst);
        AbstractGraphPathSearch.DefaultResult result = new AbstractGraphPathSearch.DefaultResult((AbstractGraphPathSearch)this, src, dst);
        HashSet<V> frontier = new HashSet<V>();
        result.updateVertex(src, null, 0.0, true);
        frontier.add(src);
        boolean reachedEnd = false;
        while (!reachedEnd && !frontier.isEmpty()) {
            HashSet next = new HashSet();
            block1: for (Vertex vertex : frontier) {
                double cost = result.cost(vertex);
                for (Edge edge : graph.getEdgesFrom(vertex)) {
                    Object nextVertex = edge.dst();
                    if (!result.hasCost(nextVertex)) {
                        double newCost = cost + (weight == null ? 1.0 : weight.weight(edge));
                        result.updateVertex(nextVertex, edge, newCost, true);
                        if (nextVertex.equals(dst)) {
                            reachedEnd = true;
                            continue block1;
                        }
                        next.add(nextVertex);
                    }
                    if (!reachedEnd) continue;
                    continue block1;
                }
            }
            frontier = next;
        }
        result.buildPaths();
        return result;
    }
}

