/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.graph;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import org.onlab.graph.AbstractGraphPathSearch;
import org.onlab.graph.Edge;
import org.onlab.graph.EdgeWeight;
import org.onlab.graph.Graph;
import org.onlab.graph.GraphPathSearch;
import org.onlab.graph.Heap;
import org.onlab.graph.Vertex;

public class DijkstraGraphSearch<V extends Vertex, E extends Edge<V>>
extends AbstractGraphPathSearch<V, E> {
    @Override
    public GraphPathSearch.Result<V, E> search(Graph<V, E> graph, V src, V dst, EdgeWeight<V, E> weight) {
        Vertex nearest;
        this.checkArguments(graph, src, dst);
        AbstractGraphPathSearch.DefaultResult result = new AbstractGraphPathSearch.DefaultResult((AbstractGraphPathSearch)this, src, dst);
        result.updateVertex(src, null, 0.0, false);
        if (graph.getEdges().isEmpty()) {
            result.buildPaths();
            return result;
        }
        Heap<V> minQueue = this.createMinQueue(graph.getVertexes(), new PathCostComparator(result));
        while (!minQueue.isEmpty() && !(nearest = (Vertex)minQueue.extractExtreme()).equals(dst)) {
            double cost = result.cost(nearest);
            if (cost < Double.MAX_VALUE) {
                for (Edge e : graph.getEdgesFrom(nearest)) {
                    result.relaxEdge(e, cost, weight, true);
                }
            }
            minQueue.heapify();
        }
        result.buildPaths();
        return result;
    }

    private Heap<V> createMinQueue(Set<V> vertexes, Comparator<V> comparator) {
        return new Heap<V>(new ArrayList<V>(vertexes), comparator);
    }

    private final class PathCostComparator
    implements Comparator<V> {
        private final AbstractGraphPathSearch.DefaultResult result;

        private PathCostComparator(AbstractGraphPathSearch.DefaultResult result) {
            this.result = result;
        }

        @Override
        public int compare(V v1, V v2) {
            double delta = this.result.cost(v2) - this.result.cost(v1);
            return delta < 0.0 ? -1 : (delta > 0.0 ? 1 : 0);
        }
    }
}

