/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.graph;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.onlab.graph.DijkstraGraphSearch;
import org.onlab.graph.Edge;
import org.onlab.graph.EdgeWeight;
import org.onlab.graph.Graph;
import org.onlab.graph.MutableAdjacencyListsGraph;
import org.onlab.graph.MutableGraph;
import org.onlab.graph.Vertex;

public class KshortestPathSearch<V extends Vertex, E extends Edge<V>> {
    private Graph<V, E> immutableGraph;
    private MutableGraph<V, E> mutableGraph;
    private List<List<E>> pathResults = new ArrayList<List<E>>();
    private List<List<E>> pathCandidates = new ArrayList<List<E>>();
    private V source;
    private V sink;
    private int numK = 0;
    private EdgeWeight<V, E> weight = null;

    public KshortestPathSearch(Graph<V, E> graph) {
        this.immutableGraph = graph;
        this.mutableGraph = new MutableAdjacencyListsGraph<V, E>(graph.getVertexes(), graph.getEdges());
    }

    public List<List<E>> search(V src, V dst, EdgeWeight<V, E> wei, int k) {
        this.weight = wei;
        this.source = src;
        this.sink = dst;
        this.numK = k;
        this.pathResults.clear();
        this.pathCandidates.clear();
        this.checkArguments(this.immutableGraph, src, dst, this.numK);
        this.searchKShortestPaths();
        return this.pathResults;
    }

    private void checkArguments(Graph<V, E> graph, V src, V dst, int k) {
        if (graph == null) {
            throw new NullPointerException("graph is null");
        }
        if (!graph.getVertexes().contains(src)) {
            throw new NullPointerException("source node does not exist");
        }
        if (!graph.getVertexes().contains(dst)) {
            throw new NullPointerException("target node does not exist");
        }
        if (k <= 0) {
            throw new NullPointerException("K is negative or 0");
        }
        if (this.weight == null) {
            throw new NullPointerException("the cost matrix is null");
        }
    }

    private void searchKShortestPaths() {
        List<E> shortestPath = this.searchShortestPath(this.immutableGraph, this.source, this.sink);
        if (shortestPath == null) {
            return;
        }
        this.pathResults.add(shortestPath);
        while (this.pathResults.size() < this.numK) {
            List<E> lastPath = this.pathResults.get(this.pathResults.size() - 1);
            for (int i = 0; i < lastPath.size(); ++i) {
                this.convertGraph();
                List<E> rootPath = this.createSpurNode(lastPath, i);
                this.transformGraph(rootPath);
                V devNode = this.getDevNode(rootPath);
                List<E> spurPath = this.searchShortestPath(this.mutableGraph, devNode, this.sink);
                if (spurPath == null) continue;
                rootPath.addAll(spurPath);
                this.pathCandidates.add(rootPath);
            }
            if (this.pathCandidates.size() == 0) break;
            this.addPathResult();
        }
    }

    private List<E> searchShortestPath(Graph<V, E> graph, V src, V dst) {
        DijkstraGraphSearch<V, E> dijkstraAlg = new DijkstraGraphSearch<V, E>();
        Set paths = dijkstraAlg.search(graph, src, dst, this.weight).paths();
        Iterator itr = paths.iterator();
        if (!itr.hasNext()) {
            return null;
        }
        return itr.next().edges();
    }

    private void convertGraph() {
        if (this.mutableGraph != null) {
            ((MutableAdjacencyListsGraph)this.mutableGraph).clear();
        }
        Set<E> copyEa = this.immutableGraph.getEdges();
        Set<V> copyVa = this.immutableGraph.getVertexes();
        for (Vertex vertex : copyVa) {
            this.mutableGraph.addVertex(vertex);
        }
        for (Edge edge : copyEa) {
            this.mutableGraph.addEdge(edge);
        }
    }

    private V getDevNode(List<E> path) {
        if (path.size() == 0) {
            return this.source;
        }
        Edge temp1 = (Edge)path.get(path.size() - 1);
        Object srcA = temp1.src();
        Object dstB = temp1.dst();
        if (path.size() == 1) {
            if (srcA.equals(this.source)) {
                return dstB;
            }
            return srcA;
        }
        Edge temp2 = (Edge)path.get(path.size() - 2);
        if (srcA.equals(temp2.src()) || srcA.equals(temp2.dst())) {
            return dstB;
        }
        return srcA;
    }

    private List<E> createSpurNode(List<E> path, int n) {
        ArrayList<E> root = new ArrayList<E>();
        for (int i = 0; i < n; ++i) {
            root.add(path.get(i));
        }
        return root;
    }

    private void transformGraph(List<E> rootPath) {
        int i;
        int j;
        List<E> prePath;
        int i2;
        for (i2 = 0; i2 < this.pathResults.size(); ++i2) {
            prePath = this.pathResults.get(i2);
            if (prePath.size() == 1) {
                this.mutableGraph.removeEdge((Edge)prePath.get(0));
                continue;
            }
            if (!this.comparePath(rootPath, prePath)) continue;
            for (j = 0; j <= rootPath.size(); ++j) {
                this.mutableGraph.removeEdge((Edge)prePath.get(j));
            }
        }
        for (i2 = 0; i2 < this.pathCandidates.size(); ++i2) {
            prePath = this.pathCandidates.get(i2);
            if (prePath.size() == 1) {
                this.mutableGraph.removeEdge((Edge)prePath.get(0));
                continue;
            }
            if (!this.comparePath(rootPath, prePath)) continue;
            for (j = 0; j <= rootPath.size(); ++j) {
                this.mutableGraph.removeEdge((Edge)prePath.get(j));
            }
        }
        if (rootPath.size() == 0) {
            return;
        }
        ArrayList nodes = new ArrayList();
        nodes.add(this.source);
        V pre = this.source;
        for (i = 0; i < rootPath.size() - 1; ++i) {
            Edge temp = (Edge)rootPath.get(i);
            Object srcA = temp.src();
            Object dstB = temp.dst();
            if (srcA.equals(pre)) {
                nodes.add(dstB);
                pre = dstB;
                continue;
            }
            nodes.add(srcA);
            pre = srcA;
        }
        for (i = 0; i < nodes.size(); ++i) {
            this.mutableGraph.removeVertex((Vertex)nodes.get(i));
        }
    }

    private boolean comparePath(List<E> path1, List<E> path2) {
        if (path1.size() > path2.size()) {
            return false;
        }
        if (path1.size() == 0) {
            return true;
        }
        for (int i = 0; i < path1.size(); ++i) {
            if (path1.get(i) == path2.get(i)) continue;
            return false;
        }
        return true;
    }

    private void addPathResult() {
        List<E> sp = this.pathCandidates.get(0);
        for (int i = 1; i < this.pathCandidates.size(); ++i) {
            if (sp.size() <= this.pathCandidates.get(i).size()) continue;
            sp = this.pathCandidates.get(i);
        }
        this.pathResults.add(sp);
        this.pathCandidates.remove(sp);
    }
}

