/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

public class VlanId {
    private final short value;
    public static final short UNTAGGED = -1;
    public static final VlanId NONE = VlanId.vlanId((short)-1);
    public static final short MAX_VLAN = 4095;

    protected VlanId() {
        this.value = (short)-1;
    }

    protected VlanId(short value) {
        this.value = value;
    }

    public static VlanId vlanId() {
        return new VlanId(-1);
    }

    public static VlanId vlanId(short value) {
        if (value == -1) {
            return new VlanId();
        }
        if (value > 4095) {
            throw new IllegalArgumentException("value exceeds allowed maximum VLAN ID value (4095)");
        }
        return new VlanId(value);
    }

    public short toShort() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof VlanId) {
            VlanId other = (VlanId)obj;
            if (this.value == other.value) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

