/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.graph;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.onlab.graph.AbstractGraphPathSearch;
import org.onlab.graph.Edge;
import org.onlab.graph.EdgeWeight;
import org.onlab.graph.Graph;
import org.onlab.graph.Vertex;

public class DepthFirstSearch<V extends Vertex, E extends Edge<V>>
extends AbstractGraphPathSearch<V, E> {
    public SpanningTreeResult search(Graph<V, E> graph, V src, V dst, EdgeWeight<V, E> weight) {
        Vertex vertex;
        this.checkArguments(graph, src, dst);
        SpanningTreeResult result = new SpanningTreeResult(this, src, dst);
        result.updateVertex(src, null, 0.0, true);
        HashSet<Vertex> finished = new HashSet<Vertex>();
        Stack stack = new Stack();
        stack.push(src);
        while (!stack.isEmpty() && !(vertex = (Vertex)stack.peek()).equals(dst)) {
            double cost = result.cost(vertex);
            boolean tangent = false;
            for (Edge edge : graph.getEdgesFrom(vertex)) {
                if (result.isEdgeMarked(edge)) continue;
                Object nextVertex = edge.dst();
                if (!result.hasCost(nextVertex)) {
                    result.markEdge(edge, EdgeType.TREE_EDGE);
                    double newCost = cost + (weight == null ? 1.0 : weight.weight(edge));
                    result.updateVertex(nextVertex, edge, newCost, true);
                    stack.push(nextVertex);
                    tangent = true;
                    break;
                }
                if (!finished.contains(nextVertex)) {
                    result.markEdge(edge, EdgeType.BACK_EDGE);
                    continue;
                }
                result.markEdge(edge, this.isForwardEdge(result, edge) ? EdgeType.FORWARD_EDGE : EdgeType.CROSS_EDGE);
            }
            if (tangent) continue;
            finished.add(vertex);
            stack.pop();
        }
        result.buildPaths();
        return result;
    }

    protected boolean isForwardEdge(AbstractGraphPathSearch.DefaultResult result, E edge) {
        Set parentEdges;
        Object target = edge.src();
        Object vertex = edge.dst();
        while ((parentEdges = result.parents.get(vertex)) != null) {
            for (Edge parentEdge : parentEdges) {
                vertex = parentEdge.src();
                if (!vertex.equals(target)) continue;
                return true;
            }
        }
        return false;
    }

    public static class SpanningTreeResult
    extends AbstractGraphPathSearch.DefaultResult {
        protected final Map<E, EdgeType> edges;
        final /* synthetic */ DepthFirstSearch this$0;

        public SpanningTreeResult(V src, V dst) {
            this.this$0 = this$0;
            super((AbstractGraphPathSearch)this$0, src, dst);
            this.edges = new HashMap();
        }

        public Map<E, EdgeType> edges() {
            return this.edges;
        }

        boolean isEdgeMarked(E edge) {
            return this.edges.containsKey(edge);
        }

        void markEdge(E edge, EdgeType type) {
            this.edges.put(edge, type);
        }
    }

    public static enum EdgeType {
        TREE_EDGE,
        FORWARD_EDGE,
        BACK_EDGE,
        CROSS_EDGE;

    }
}

