/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.onlab.packet.LLDP;
import org.onlab.packet.LLDPTLV;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ONLabLddp
extends LLDP {
    private static final Logger LOG = LoggerFactory.getLogger(ONLabLddp.class);
    public static final byte[] ONLAB_OUI = new byte[]{-92, 35, 5};
    public static final String OVX_NAME = "OpenVirteX";
    public static final byte[] LLDP_NICIRA = new byte[]{1, 35, 32, 0, 0, 1};
    public static final byte[] LLDP_MULTICAST = new byte[]{1, -128, -62, 0, 0, 14};
    public static final byte[] BDDP_MULTICAST = new byte[]{-1, -1, -1, -1, -1, -1};
    public static final short ETHERTYPE_VLAN = -32512;
    private static final byte CHASSIS_TLV_TYPE = 1;
    private static final byte CHASSIS_TLV_SIZE = 7;
    private static final byte CHASSIS_TLV_SUBTYPE = 4;
    private static final byte PORT_TLV_TYPE = 2;
    private static final byte PORT_TLV_SIZE = 5;
    private static final byte PORT_TLV_SUBTYPE = 2;
    private static final byte TTL_TLV_TYPE = 3;
    private static final byte TTL_TLV_SIZE = 2;
    private static final byte NAME_TLV_TYPE = 127;
    private static final byte NAME_TLV_SIZE = (byte)(4 + "OpenVirteX".length());
    private static final byte NAME_TLV_SUBTYPE = 1;
    private static final short NAME_TLV_OFFSET = 34;
    private static final short NAME_TLV_HEADER = (short)(0xFE00 | NAME_TLV_SIZE);
    private static final byte[] NAME_TLV = ByteBuffer.allocate(NAME_TLV_SIZE + 2).putShort(NAME_TLV_HEADER).put(ONLAB_OUI).put((byte)1).put("OpenVirteX".getBytes(StandardCharsets.UTF_8)).array();
    private static final byte DPID_TLV_TYPE = 127;
    private static final byte DPID_TLV_SIZE = 12;
    private static final byte DPID_TLV_SUBTYPE = 2;
    private static final short DPID_TLV_HEADER = -500;
    private static final byte[] DPID_TLV = ByteBuffer.allocate(6).putShort((short)-500).put(ONLAB_OUI).put((byte)2).array();
    private static final byte[] OUI_TLV = ArrayUtils.addAll((byte[])NAME_TLV, (byte[])DPID_TLV);
    private static final byte[] DEFAULT_DPID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    private static final int DEFAULT_PORT = 0;
    private static final short DEFAULT_TTL = 120;
    private static final short MINIMUM_LLDP_SIZE = 61;
    private static final short OVX_LLDP_SIZE = (short)(14 + NAME_TLV_SIZE + 12 + 12);
    private static final short ETHERTYPE_OFFSET = 12;
    private static final short PORT_OFFSET = 26;
    private static final short DPID_OFFSET = 56;
    private ByteBuffer bb;
    private final byte[] chassisId = new byte[7];
    private final byte[] portId = new byte[5];
    private final byte[] ttl = new byte[2];
    private final byte[] ouiName = new byte[NAME_TLV_SIZE];
    private final byte[] ouiDpid = new byte[12];
    private final LLDPTLV chassisTLV = new LLDPTLV();
    private final LLDPTLV portTLV = new LLDPTLV();
    private final LLDPTLV ttlTLV = new LLDPTLV();
    private final LLDPTLV ouiNameTLV = new LLDPTLV();
    private final LLDPTLV ouiDpidTLV = new LLDPTLV();
    private final List<LLDPTLV> optionalTLVList = new LinkedList<LLDPTLV>();

    public ONLabLddp() {
        this.optionalTLVList.add(this.ouiNameTLV);
        this.optionalTLVList.add(this.ouiDpidTLV);
        this.setChassisId(this.chassisTLV);
        this.setPortId(this.portTLV);
        this.setTtl(this.ttlTLV);
        this.setOptionalTLVList(this.optionalTLVList);
        this.setChassisTLV(DEFAULT_DPID);
        this.setPortTLV(0);
        this.setTTLTLV((short)120);
        this.setOUIName(OVX_NAME);
        this.setOUIDpid(DEFAULT_DPID);
    }

    private void setChassisTLV(byte[] dpid) {
        this.bb = ByteBuffer.wrap(this.chassisId);
        this.bb.put((byte)4);
        for (int i = 2; i < 8; ++i) {
            this.bb.put(dpid[i]);
        }
        this.chassisTLV.setLength((short)7);
        this.chassisTLV.setType((byte)1);
        this.chassisTLV.setValue(this.chassisId);
    }

    private void setPortTLV(int portNumber) {
        this.bb = ByteBuffer.wrap(this.portId);
        this.bb.put((byte)2);
        this.bb.putInt(portNumber);
        this.portTLV.setLength((short)5);
        this.portTLV.setType((byte)2);
        this.portTLV.setValue(this.portId);
    }

    private void setTTLTLV(short time) {
        this.bb = ByteBuffer.wrap(this.ttl);
        this.bb.putShort(time);
        this.ttlTLV.setLength((short)2);
        this.ttlTLV.setType((byte)3);
        this.ttlTLV.setValue(this.ttl);
    }

    private void setOUIName(String name) {
        this.bb = ByteBuffer.wrap(this.ouiName);
        this.bb.put(ONLAB_OUI);
        this.bb.put((byte)1);
        this.bb.put(name.getBytes(StandardCharsets.UTF_8));
        this.ouiNameTLV.setLength(NAME_TLV_SIZE);
        this.ouiNameTLV.setType((byte)127);
        this.ouiNameTLV.setValue(this.ouiName);
    }

    private void setOUIDpid(byte[] dpid) {
        this.bb = ByteBuffer.wrap(this.ouiDpid);
        this.bb.put(ONLAB_OUI);
        this.bb.put((byte)2);
        this.bb.put(dpid);
        this.ouiDpidTLV.setLength((short)12);
        this.ouiDpidTLV.setType((byte)127);
        this.ouiDpidTLV.setValue(this.ouiDpid);
    }

    public void setSwitch(long dp) {
        byte[] dpid = ByteBuffer.allocate(8).putLong(dp).array();
        this.setChassisTLV(dpid);
        this.setOUIDpid(dpid);
    }

    public void setPort(int port) {
        this.setPortTLV(port);
    }

    @Override
    public byte[] serialize() {
        return super.serialize();
    }

    public static boolean isLLDP(byte[] packet) {
        if (packet == null || packet.length < 61) {
            return false;
        }
        ByteBuffer bb = ByteBuffer.wrap(packet);
        byte[] dst = new byte[6];
        bb.get(dst);
        if (!(Arrays.equals(dst, LLDP_NICIRA) || Arrays.equals(dst, LLDP_MULTICAST) || Arrays.equals(dst, BDDP_MULTICAST))) {
            return false;
        }
        short etherType = bb.getShort(12);
        if (etherType == -32512) {
            etherType = bb.getShort(16);
        }
        if (etherType == -30516) {
            return true;
        }
        return etherType == -30398;
    }

    public static short isOVXLLDP(byte[] packet) {
        if (packet.length < OVX_LLDP_SIZE) {
            return -1;
        }
        ByteBuffer bb = ByteBuffer.wrap(packet);
        int offset = 0;
        short ethType = bb.getShort(12);
        if (ethType != -30516 && ethType != -30398 && (ethType = bb.getShort(12 + (offset = 4))) != -30516 && ethType != -30398) {
            return -1;
        }
        for (int i = 0; i < OUI_TLV.length; ++i) {
            if (packet[34 + offset + i] == OUI_TLV[i]) continue;
            return -1;
        }
        return ethType;
    }

    public static DPIDandPort parseLLDP(byte[] packet) {
        ByteBuffer bb = ByteBuffer.wrap(packet);
        int offset = 0;
        if (bb.getShort(12) != -30516 && bb.getShort(12) != -30398) {
            offset = 4;
        }
        int port = bb.getInt(26 + offset);
        long dpid = bb.getLong(56 + offset);
        return new DPIDandPort(dpid, port);
    }

    public static class DPIDandPort {
        private final long dpid;
        private final int port;

        public DPIDandPort(long dpid, int port) {
            this.dpid = dpid;
            this.port = port;
        }

        public long getDpid() {
            return this.dpid;
        }

        public int getPort() {
            return this.port;
        }
    }
}

