/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.ByteBufferInput;
import com.esotericsoftware.kryo.io.ByteBufferOutput;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.pool.KryoCallback;
import com.esotericsoftware.kryo.pool.KryoFactory;
import com.esotericsoftware.kryo.pool.KryoPool;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public final class KryoNamespace
implements KryoFactory,
KryoPool {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final int MAX_BUFFER_SIZE = 100000000;
    public static final int FLOATING_ID = -1;
    public static final int INITIAL_ID = 11;
    private final KryoPool pool = new KryoPool.Builder((KryoFactory)this).softReferences().build();
    private final ImmutableList<RegistrationBlock> registeredBlocks;
    private final boolean registrationRequired;

    public static Builder newBuilder() {
        return new Builder();
    }

    private KryoNamespace(List<RegistrationBlock> registeredTypes, boolean registrationRequired) {
        this.registeredBlocks = ImmutableList.copyOf(registeredTypes);
        this.registrationRequired = registrationRequired;
    }

    public KryoNamespace populate(int instances) {
        for (int i = 0; i < instances; ++i) {
            this.release(this.create());
        }
        return this;
    }

    public byte[] serialize(Object obj) {
        return this.serialize(obj, 4096);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] serialize(Object obj, int bufferSize) {
        ByteBufferOutput out = new ByteBufferOutput(bufferSize, 100000000);
        Kryo kryo = this.borrow();
        try {
            kryo.writeClassAndObject((Output)out, obj);
            out.flush();
            byte[] byArray = out.toBytes();
            return byArray;
        }
        finally {
            this.release(kryo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(Object obj, ByteBuffer buffer) {
        ByteBufferOutput out = new ByteBufferOutput(buffer);
        Kryo kryo = this.borrow();
        try {
            kryo.writeClassAndObject((Output)out, obj);
            out.flush();
        }
        finally {
            this.release(kryo);
        }
    }

    public void serialize(Object obj, OutputStream stream) {
        this.serialize(obj, stream, 4096);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(Object obj, OutputStream stream, int bufferSize) {
        ByteBufferOutput out = new ByteBufferOutput(stream, bufferSize);
        Kryo kryo = this.borrow();
        try {
            kryo.writeClassAndObject((Output)out, obj);
            out.flush();
        }
        finally {
            this.release(kryo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T deserialize(byte[] bytes) {
        Input in = new Input(bytes);
        Kryo kryo = this.borrow();
        try {
            Object obj;
            Object object = obj = kryo.readClassAndObject(in);
            return (T)object;
        }
        finally {
            this.release(kryo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T deserialize(ByteBuffer buffer) {
        ByteBufferInput in = new ByteBufferInput(buffer);
        Kryo kryo = this.borrow();
        try {
            Object obj;
            Object object = obj = kryo.readClassAndObject((Input)in);
            return (T)object;
        }
        finally {
            this.release(kryo);
        }
    }

    public <T> T deserialize(InputStream stream) {
        return this.deserialize(stream, 4096);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T deserialize(InputStream stream, int bufferSize) {
        ByteBufferInput in = new ByteBufferInput(stream, bufferSize);
        Kryo kryo = this.borrow();
        try {
            Object obj;
            Object object = obj = kryo.readClassAndObject((Input)in);
            return (T)object;
        }
        finally {
            this.release(kryo);
        }
    }

    public Kryo create() {
        Kryo kryo = new Kryo();
        kryo.setRegistrationRequired(this.registrationRequired);
        for (RegistrationBlock block : this.registeredBlocks) {
            int id = block.begin();
            if (id == -1) {
                id = kryo.getNextRegistrationId();
            }
            for (Pair entry : block.types()) {
                Serializer serializer = (Serializer)entry.getRight();
                if (serializer == null) {
                    kryo.register((Class)entry.getLeft(), id++);
                    continue;
                }
                kryo.register((Class)entry.getLeft(), serializer, id++);
            }
        }
        return kryo;
    }

    public Kryo borrow() {
        return this.pool.borrow();
    }

    public void release(Kryo kryo) {
        this.pool.release(kryo);
    }

    public <T> T run(KryoCallback<T> callback) {
        return (T)this.pool.run(callback);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("registeredBlocks", this.registeredBlocks).toString();
    }

    static final class RegistrationBlock {
        private final int begin;
        private final ImmutableList<Pair<Class<?>, Serializer<?>>> types;

        public RegistrationBlock(int begin, List<Pair<Class<?>, Serializer<?>>> types) {
            this.begin = begin;
            this.types = ImmutableList.copyOf(types);
        }

        public int begin() {
            return this.begin;
        }

        public ImmutableList<Pair<Class<?>, Serializer<?>>> types() {
            return this.types;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("begin", this.begin).add("types", this.types).toString();
        }
    }

    public static final class Builder {
        private int blockHeadId = 11;
        private List<Pair<Class<?>, Serializer<?>>> types = new ArrayList();
        private List<RegistrationBlock> blocks = new ArrayList<RegistrationBlock>();
        private boolean registrationRequired = true;

        public KryoNamespace build() {
            if (!this.types.isEmpty()) {
                this.blocks.add(new RegistrationBlock(this.blockHeadId, this.types));
            }
            return new KryoNamespace(this.blocks, this.registrationRequired).populate(1);
        }

        public Builder nextId(int id) {
            if (!this.types.isEmpty()) {
                this.blocks.add(new RegistrationBlock(this.blockHeadId, this.types));
                this.types = new ArrayList();
            }
            this.blockHeadId = id;
            return this;
        }

        public Builder register(Class<?> ... expectedTypes) {
            for (Class<?> clazz : expectedTypes) {
                this.types.add(Pair.of(clazz, null));
            }
            return this;
        }

        public Builder register(Serializer<?> serializer, Class<?> ... classes) {
            for (Class<?> clazz : classes) {
                this.types.add(Pair.of(clazz, serializer));
            }
            return this;
        }

        private Builder register(RegistrationBlock block) {
            if (block.begin() != -1) {
                this.nextId(block.begin());
                this.blocks.add(block);
                this.nextId(block.begin() + block.types().size());
            } else {
                int addedBlockBegin = this.blockHeadId + this.types.size();
                this.nextId(addedBlockBegin);
                this.blocks.add(new RegistrationBlock(addedBlockBegin, (List<Pair<Class<?>, Serializer<?>>>)block.types()));
                this.nextId(addedBlockBegin + block.types().size());
            }
            return this;
        }

        public Builder register(KryoNamespace ns) {
            for (RegistrationBlock block : ns.registeredBlocks) {
                this.register(block);
            }
            return this;
        }

        public Builder setRegistrationRequired(boolean registrationRequired) {
            this.registrationRequired = registrationRequired;
            return this;
        }
    }
}

