/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.graph;

import com.google.common.collect.ImmutableSet;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.onlab.graph.AdjacencyListsGraph;
import org.onlab.graph.BreadthFirstSearchTest;
import org.onlab.graph.KshortestPathSearch;
import org.onlab.graph.TestEdge;
import org.onlab.graph.TestVertex;
import org.onlab.graph.Vertex;

public class KshortestPathSearchTest
extends BreadthFirstSearchTest {
    private final ByteArrayOutputStream outContent = new ByteArrayOutputStream();

    @Test
    public void noPath() {
        this.graph = new AdjacencyListsGraph((Set)ImmutableSet.of((Object)A, (Object)B, (Object)C, (Object)D), (Set)ImmutableSet.of((Object)((Object)new TestEdge(A, B, 1.0)), (Object)((Object)new TestEdge(B, A, 1.0)), (Object)((Object)new TestEdge(C, D, 1.0)), (Object)((Object)new TestEdge(D, C, 1.0))));
        KshortestPathSearch gs = new KshortestPathSearch(this.graph);
        List result = gs.search((Vertex)A, (Vertex)D, this.weight, 1);
        ArrayList paths = new ArrayList();
        Iterator itr = result.iterator();
        while (itr.hasNext()) {
            System.out.println(((List)itr.next()).toString());
        }
        Assert.assertEquals((String)"incorrect paths count", (long)0L, (long)result.size());
    }

    @Test
    public void test2Path() {
        this.graph = new AdjacencyListsGraph((Set)ImmutableSet.of((Object)A, (Object)B, (Object)C, (Object)D), (Set)ImmutableSet.of((Object)((Object)new TestEdge(A, B, 1.0)), (Object)((Object)new TestEdge(B, A, 1.0)), (Object)((Object)new TestEdge(B, D, 1.0)), (Object)((Object)new TestEdge(D, B, 1.0)), (Object)((Object)new TestEdge(A, C, 1.0)), (Object)((Object)new TestEdge(C, A, 1.0)), (Object[])new TestEdge[]{new TestEdge(C, D, 1.0), new TestEdge(D, C, 1.0)}));
        KshortestPathSearch gs = new KshortestPathSearch(this.graph);
        List result = gs.search((Vertex)A, (Vertex)D, this.weight, 2);
        ArrayList paths = new ArrayList();
        Iterator itr = result.iterator();
        while (itr.hasNext()) {
            System.out.println(((List)itr.next()).toString());
        }
        Assert.assertEquals((String)"incorrect paths count", (long)2L, (long)result.size());
    }

    @Test
    public void test3Path() {
        this.graph = new AdjacencyListsGraph((Set)ImmutableSet.of((Object)A, (Object)B, (Object)C, (Object)D), (Set)ImmutableSet.of((Object)((Object)new TestEdge(A, B, 1.0)), (Object)((Object)new TestEdge(B, A, 1.0)), (Object)((Object)new TestEdge(A, D, 1.0)), (Object)((Object)new TestEdge(D, A, 1.0)), (Object)((Object)new TestEdge(B, D, 1.0)), (Object)((Object)new TestEdge(D, B, 1.0)), (Object[])new TestEdge[]{new TestEdge(A, C, 1.0), new TestEdge(C, A, 1.0), new TestEdge(C, D, 1.0), new TestEdge(D, C, 1.0)}));
        KshortestPathSearch gs = new KshortestPathSearch(this.graph);
        List result = gs.search((Vertex)A, (Vertex)D, this.weight, 3);
        ArrayList paths = new ArrayList();
        Iterator itr = result.iterator();
        while (itr.hasNext()) {
            System.out.println(((List)itr.next()).toString());
        }
        Assert.assertEquals((String)"incorrect paths count", (long)3L, (long)result.size());
    }

    @Test
    public void test4Path() {
        this.graph = new AdjacencyListsGraph((Set)ImmutableSet.of((Object)A, (Object)B, (Object)C, (Object)D, (Object)E, (Object)F, (Object[])new TestVertex[0]), (Set)ImmutableSet.of((Object)((Object)new TestEdge(A, B, 1.0)), (Object)((Object)new TestEdge(B, A, 1.0)), (Object)((Object)new TestEdge(A, C, 1.0)), (Object)((Object)new TestEdge(C, A, 1.0)), (Object)((Object)new TestEdge(B, D, 1.0)), (Object)((Object)new TestEdge(D, B, 1.0)), (Object[])new TestEdge[]{new TestEdge(C, E, 1.0), new TestEdge(E, C, 1.0), new TestEdge(D, F, 1.0), new TestEdge(F, D, 1.0), new TestEdge(F, E, 1.0), new TestEdge(E, F, 1.0), new TestEdge(C, D, 1.0), new TestEdge(D, C, 1.0)}));
        KshortestPathSearch gs = new KshortestPathSearch(this.graph);
        List result = gs.search((Vertex)A, (Vertex)F, this.weight, 4);
        ArrayList paths = new ArrayList();
        Iterator itr = result.iterator();
        while (itr.hasNext()) {
            System.out.println(((List)itr.next()).toString());
        }
        Assert.assertEquals((String)"incorrect paths count", (long)4L, (long)result.size());
    }

    @Test
    public void test6Path() {
        this.graph = new AdjacencyListsGraph((Set)ImmutableSet.of((Object)A, (Object)B, (Object)C, (Object)D, (Object)E, (Object)F, (Object[])new TestVertex[0]), (Set)ImmutableSet.of((Object)((Object)new TestEdge(A, B, 1.0)), (Object)((Object)new TestEdge(B, A, 1.0)), (Object)((Object)new TestEdge(A, C, 1.0)), (Object)((Object)new TestEdge(C, A, 1.0)), (Object)((Object)new TestEdge(B, D, 1.0)), (Object)((Object)new TestEdge(D, B, 1.0)), (Object[])new TestEdge[]{new TestEdge(B, C, 1.0), new TestEdge(C, B, 1.0), new TestEdge(D, E, 1.0), new TestEdge(E, D, 1.0), new TestEdge(C, E, 1.0), new TestEdge(E, C, 1.0), new TestEdge(D, F, 1.0), new TestEdge(F, D, 1.0), new TestEdge(E, F, 1.0), new TestEdge(F, E, 1.0)}));
        KshortestPathSearch gs = new KshortestPathSearch(this.graph);
        List result = gs.search((Vertex)A, (Vertex)F, this.weight, 6);
        ArrayList paths = new ArrayList();
        Iterator itr = result.iterator();
        while (itr.hasNext()) {
            System.out.println(((List)itr.next()).toString());
        }
        Assert.assertEquals((String)"incorrect paths count", (long)6L, (long)result.size());
    }

    @Test
    public void dualEdgePath() {
        this.graph = new AdjacencyListsGraph((Set)ImmutableSet.of((Object)A, (Object)B, (Object)C, (Object)D, (Object)E, (Object)F, (Object[])new TestVertex[]{G, H}), (Set)ImmutableSet.of((Object)((Object)new TestEdge(A, B, 1.0)), (Object)((Object)new TestEdge(A, C, 3.0)), (Object)((Object)new TestEdge(B, D, 2.0)), (Object)((Object)new TestEdge(B, C, 1.0)), (Object)((Object)new TestEdge(B, E, 4.0)), (Object)((Object)new TestEdge(C, E, 1.0)), (Object[])new TestEdge[]{new TestEdge(D, H, 5.0), new TestEdge(D, E, 1.0), new TestEdge(E, F, 1.0), new TestEdge(F, D, 1.0), new TestEdge(F, G, 1.0), new TestEdge(F, H, 1.0), new TestEdge(A, E, 3.0), new TestEdge(B, D, 1.0)}));
        KshortestPathSearch gs = new KshortestPathSearch(this.graph);
        List result = gs.search((Vertex)A, (Vertex)G, this.weight, 6);
        ArrayList paths = new ArrayList();
        Iterator itr = result.iterator();
        while (itr.hasNext()) {
            System.out.println(((List)itr.next()).toString());
        }
        Assert.assertEquals((String)"incorrect paths count", (long)6L, (long)result.size());
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }
}

