/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.onlab.packet.BasePacket;
import org.onlab.packet.IPacket;

public class ARP
extends BasePacket {
    public static final short HW_TYPE_ETHERNET = 1;
    public static final short PROTO_TYPE_IP = 2048;
    public static final short OP_REQUEST = 1;
    public static final short OP_REPLY = 2;
    public static final short OP_RARP_REQUEST = 3;
    public static final short OP_RARP_REPLY = 4;
    protected short hardwareType;
    protected short protocolType;
    protected byte hardwareAddressLength;
    protected byte protocolAddressLength;
    protected short opCode;
    protected byte[] senderHardwareAddress;
    protected byte[] senderProtocolAddress;
    protected byte[] targetHardwareAddress;
    protected byte[] targetProtocolAddress;

    public short getHardwareType() {
        return this.hardwareType;
    }

    public ARP setHardwareType(short hwType) {
        this.hardwareType = hwType;
        return this;
    }

    public short getProtocolType() {
        return this.protocolType;
    }

    public ARP setProtocolType(short protoType) {
        this.protocolType = protoType;
        return this;
    }

    public byte getHardwareAddressLength() {
        return this.hardwareAddressLength;
    }

    public ARP setHardwareAddressLength(byte hwAddressLength) {
        this.hardwareAddressLength = hwAddressLength;
        return this;
    }

    public byte getProtocolAddressLength() {
        return this.protocolAddressLength;
    }

    public ARP setProtocolAddressLength(byte protoAddressLength) {
        this.protocolAddressLength = protoAddressLength;
        return this;
    }

    public short getOpCode() {
        return this.opCode;
    }

    public ARP setOpCode(short op) {
        this.opCode = op;
        return this;
    }

    public byte[] getSenderHardwareAddress() {
        return this.senderHardwareAddress;
    }

    public ARP setSenderHardwareAddress(byte[] senderHWAddress) {
        this.senderHardwareAddress = senderHWAddress;
        return this;
    }

    public byte[] getSenderProtocolAddress() {
        return this.senderProtocolAddress;
    }

    public ARP setSenderProtocolAddress(byte[] senderProtoAddress) {
        this.senderProtocolAddress = senderProtoAddress;
        return this;
    }

    public ARP setSenderProtocolAddress(int address) {
        this.senderProtocolAddress = ByteBuffer.allocate(4).putInt(address).array();
        return this;
    }

    public byte[] getTargetHardwareAddress() {
        return this.targetHardwareAddress;
    }

    public ARP setTargetHardwareAddress(byte[] targetHWAddress) {
        this.targetHardwareAddress = targetHWAddress;
        return this;
    }

    public byte[] getTargetProtocolAddress() {
        return this.targetProtocolAddress;
    }

    public boolean isGratuitous() {
        assert (this.senderProtocolAddress.length == this.targetProtocolAddress.length);
        for (int indx = 0; indx < this.senderProtocolAddress.length; ++indx) {
            if (this.senderProtocolAddress[indx] == this.targetProtocolAddress[indx]) continue;
            return false;
        }
        return true;
    }

    public ARP setTargetProtocolAddress(byte[] targetProtoAddress) {
        this.targetProtocolAddress = targetProtoAddress;
        return this;
    }

    public ARP setTargetProtocolAddress(int address) {
        this.targetProtocolAddress = ByteBuffer.allocate(4).putInt(address).array();
        return this;
    }

    @Override
    public byte[] serialize() {
        int length = 8 + 2 * (0xFF & this.hardwareAddressLength) + 2 * (0xFF & this.protocolAddressLength);
        byte[] data = new byte[length];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.putShort(this.hardwareType);
        bb.putShort(this.protocolType);
        bb.put(this.hardwareAddressLength);
        bb.put(this.protocolAddressLength);
        bb.putShort(this.opCode);
        bb.put(this.senderHardwareAddress, 0, 0xFF & this.hardwareAddressLength);
        bb.put(this.senderProtocolAddress, 0, 0xFF & this.protocolAddressLength);
        bb.put(this.targetHardwareAddress, 0, 0xFF & this.hardwareAddressLength);
        bb.put(this.targetProtocolAddress, 0, 0xFF & this.protocolAddressLength);
        return data;
    }

    @Override
    public IPacket deserialize(byte[] data, int offset, int length) {
        ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
        this.hardwareType = bb.getShort();
        this.protocolType = bb.getShort();
        this.hardwareAddressLength = bb.get();
        this.protocolAddressLength = bb.get();
        this.opCode = bb.getShort();
        this.senderHardwareAddress = new byte[0xFF & this.hardwareAddressLength];
        bb.get(this.senderHardwareAddress, 0, this.senderHardwareAddress.length);
        this.senderProtocolAddress = new byte[0xFF & this.protocolAddressLength];
        bb.get(this.senderProtocolAddress, 0, this.senderProtocolAddress.length);
        this.targetHardwareAddress = new byte[0xFF & this.hardwareAddressLength];
        bb.get(this.targetHardwareAddress, 0, this.targetHardwareAddress.length);
        this.targetProtocolAddress = new byte[0xFF & this.protocolAddressLength];
        bb.get(this.targetProtocolAddress, 0, this.targetProtocolAddress.length);
        return this;
    }

    @Override
    public int hashCode() {
        int prime = 13121;
        int result = super.hashCode();
        result = 13121 * result + this.hardwareAddressLength;
        result = 13121 * result + this.hardwareType;
        result = 13121 * result + this.opCode;
        result = 13121 * result + this.protocolAddressLength;
        result = 13121 * result + this.protocolType;
        result = 13121 * result + Arrays.hashCode(this.senderHardwareAddress);
        result = 13121 * result + Arrays.hashCode(this.senderProtocolAddress);
        result = 13121 * result + Arrays.hashCode(this.targetHardwareAddress);
        result = 13121 * result + Arrays.hashCode(this.targetProtocolAddress);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ARP)) {
            return false;
        }
        ARP other = (ARP)obj;
        if (this.hardwareAddressLength != other.hardwareAddressLength) {
            return false;
        }
        if (this.hardwareType != other.hardwareType) {
            return false;
        }
        if (this.opCode != other.opCode) {
            return false;
        }
        if (this.protocolAddressLength != other.protocolAddressLength) {
            return false;
        }
        if (this.protocolType != other.protocolType) {
            return false;
        }
        if (!Arrays.equals(this.senderHardwareAddress, other.senderHardwareAddress)) {
            return false;
        }
        if (!Arrays.equals(this.senderProtocolAddress, other.senderProtocolAddress)) {
            return false;
        }
        if (!Arrays.equals(this.targetHardwareAddress, other.targetHardwareAddress)) {
            return false;
        }
        return Arrays.equals(this.targetProtocolAddress, other.targetProtocolAddress);
    }

    public String toString() {
        return "ARP [hardwareType=" + this.hardwareType + ", protocolType=" + this.protocolType + ", hardwareAddressLength=" + this.hardwareAddressLength + ", protocolAddressLength=" + this.protocolAddressLength + ", opCode=" + this.opCode + ", senderHardwareAddress=" + Arrays.toString(this.senderHardwareAddress) + ", senderProtocolAddress=" + Arrays.toString(this.senderProtocolAddress) + ", targetHardwareAddress=" + Arrays.toString(this.targetHardwareAddress) + ", targetProtocolAddress=" + Arrays.toString(this.targetProtocolAddress) + "]";
    }
}

