/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.onlab.packet.BasePacket;
import org.onlab.packet.Data;
import org.onlab.packet.IPacket;
import org.onlab.packet.IPv6;
import org.onlab.packet.ipv6.IExtensionHeader;
import org.onlab.packet.ndp.NeighborAdvertisement;
import org.onlab.packet.ndp.NeighborSolicitation;
import org.onlab.packet.ndp.Redirect;
import org.onlab.packet.ndp.RouterAdvertisement;
import org.onlab.packet.ndp.RouterSolicitation;

public class ICMP6
extends BasePacket {
    public static final byte HEADER_LENGTH = 4;
    public static final byte ROUTER_SOLICITATION = -123;
    public static final byte ROUTER_ADVERTISEMENT = -122;
    public static final byte NEIGHBOR_SOLICITATION = -121;
    public static final byte NEIGHBOR_ADVERTISEMENT = -120;
    public static final byte REDIRECT = -119;
    public static final Map<Byte, Class<? extends IPacket>> PROTOCOL_CLASS_MAP = new HashMap<Byte, Class<? extends IPacket>>();
    protected byte icmpType;
    protected byte icmpCode;
    protected short checksum;
    private static final byte[] ZERO_ADDRESS;

    public byte getIcmpType() {
        return this.icmpType;
    }

    public ICMP6 setIcmpType(byte icmpType) {
        this.icmpType = icmpType;
        return this;
    }

    public byte getIcmpCode() {
        return this.icmpCode;
    }

    public ICMP6 setIcmpCode(byte icmpCode) {
        this.icmpCode = icmpCode;
        return this;
    }

    public short getChecksum() {
        return this.checksum;
    }

    public ICMP6 setChecksum(short checksum) {
        this.checksum = checksum;
        return this;
    }

    @Override
    public byte[] serialize() {
        byte[] payloadData = null;
        if (this.payload != null) {
            this.payload.setParent(this);
            payloadData = this.payload.serialize();
        }
        int payloadLength = 0;
        if (payloadData != null) {
            payloadLength = payloadData.length;
        }
        byte[] data = new byte[4 + payloadLength];
        ByteBuffer bbData = ByteBuffer.wrap(data);
        byte[] checksumData = new byte[44 + payloadLength];
        ByteBuffer bbChecksum = ByteBuffer.wrap(checksumData);
        IPv6 ipv6Parent = null;
        for (IPacket p = this.parent; p != null; p = p.getParent()) {
            if (!(p instanceof IPv6)) continue;
            ipv6Parent = (IPv6)p;
            break;
        }
        if (ipv6Parent != null) {
            bbChecksum.put(ipv6Parent.getSourceAddress());
            bbChecksum.put(ipv6Parent.getDestinationAddress());
        } else {
            bbChecksum.put(ZERO_ADDRESS);
            bbChecksum.put(ZERO_ADDRESS);
        }
        bbChecksum.putInt(4 + payloadLength);
        bbChecksum.put((byte)0);
        bbChecksum.put((byte)0);
        bbChecksum.put((byte)0);
        bbChecksum.put((byte)58);
        bbChecksum.put(this.icmpType);
        bbChecksum.put(this.icmpCode);
        bbChecksum.put((byte)0);
        bbChecksum.put((byte)0);
        bbData.put(this.icmpType);
        bbData.put(this.icmpCode);
        bbData.putShort(this.checksum);
        if (payloadData != null) {
            bbData.put(payloadData);
            bbChecksum.put(payloadData);
        }
        if (this.parent != null) {
            if (this.parent instanceof IPv6) {
                ((IPv6)this.parent).setNextHeader((byte)58);
            } else if (this.parent instanceof IExtensionHeader) {
                ((IExtensionHeader)((Object)this.parent)).setNextHeader((byte)58);
            }
        }
        if (this.checksum == 0) {
            bbData.rewind();
            bbChecksum.rewind();
            int accumulation = 0;
            for (int i = 0; i < checksumData.length / 2; ++i) {
                accumulation += 0xFFFF & bbChecksum.getShort();
            }
            if (checksumData.length % 2 > 0) {
                accumulation += (bbChecksum.get() & 0xFF) << 8;
            }
            accumulation = (accumulation >> 16 & 0xFFFF) + (accumulation & 0xFFFF);
            this.checksum = (short)(~accumulation & 0xFFFF);
            bbData.putShort(2, this.checksum);
        }
        return data;
    }

    @Override
    public int hashCode() {
        int prime = 5807;
        int result = super.hashCode();
        result = 5807 * result + this.icmpType;
        result = 5807 * result + this.icmpCode;
        result = 5807 * result + this.checksum;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ICMP6)) {
            return false;
        }
        ICMP6 other = (ICMP6)obj;
        if (this.icmpType != other.icmpType) {
            return false;
        }
        if (this.icmpCode != other.icmpCode) {
            return false;
        }
        return this.checksum == other.checksum;
    }

    @Override
    public IPacket deserialize(byte[] data, int offset, int length) {
        IPacket payload;
        ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
        this.icmpType = bb.get();
        this.icmpCode = bb.get();
        this.checksum = bb.getShort();
        if (PROTOCOL_CLASS_MAP.containsKey(this.icmpType)) {
            Class<? extends IPacket> clazz = PROTOCOL_CLASS_MAP.get(this.icmpType);
            try {
                payload = clazz.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Error parsing payload for ICMP6 packet", e);
            }
        } else {
            payload = new Data();
        }
        this.payload = payload.deserialize(data, bb.position(), bb.limit() - bb.position());
        this.payload.setParent(this);
        return this;
    }

    static {
        PROTOCOL_CLASS_MAP.put((byte)-123, RouterSolicitation.class);
        PROTOCOL_CLASS_MAP.put((byte)-122, RouterAdvertisement.class);
        PROTOCOL_CLASS_MAP.put((byte)-121, NeighborSolicitation.class);
        PROTOCOL_CLASS_MAP.put((byte)-120, NeighborAdvertisement.class);
        PROTOCOL_CLASS_MAP.put((byte)-119, Redirect.class);
        ZERO_ADDRESS = new byte[16];
    }
}

