/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.util.BestEffortSerialExecutor;
import org.onlab.util.SharedExecutors;

public class BestEffortSerialExecutorTest {
    @Test
    public void testSerialExecution() throws Throwable {
        BestEffortSerialExecutor executor = new BestEffortSerialExecutor((Executor)SharedExecutors.getPoolThreadExecutor());
        CountDownLatch latch = new CountDownLatch(2);
        executor.execute(latch::countDown);
        executor.execute(latch::countDown);
        latch.await();
        Assert.assertEquals((long)0L, (long)latch.getCount());
    }

    @Test
    public void testBlockedExecution() throws Throwable {
        BestEffortSerialExecutor executor = new BestEffortSerialExecutor((Executor)SharedExecutors.getPoolThreadExecutor());
        CountDownLatch latch = new CountDownLatch(3);
        executor.execute(() -> {
            try {
                Thread.sleep(2000L);
                latch.countDown();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        Thread.sleep(10L);
        executor.execute(() -> {
            try {
                new CompletableFuture().get(2L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                latch.countDown();
            }
        });
        Thread.sleep(10L);
        executor.execute(latch::countDown);
        latch.await(1L, TimeUnit.SECONDS);
        Assert.assertEquals((long)2L, (long)latch.getCount());
        latch.await(3L, TimeUnit.SECONDS);
        Assert.assertEquals((long)0L, (long)latch.getCount());
    }
}

