/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import com.google.common.net.InetAddresses;
import com.google.common.testing.EqualsTester;
import java.net.InetAddress;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onlab.packet.Ip6Address;
import org.onlab.packet.IpAddress;

public class Ip6AddressTest {
    @Test
    public void testImmutable() {
        ImmutableClassChecker.assertThatClassIsImmutable(Ip6Address.class);
    }

    @Test
    public void testAddressVersion() {
        Assert.assertThat((Object)Ip6Address.VERSION, (Matcher)Matchers.is((Object)IpAddress.Version.INET6));
    }

    @Test
    public void testAddrByteLength() {
        Assert.assertThat((Object)16, (Matcher)Matchers.is((Object)16));
    }

    @Test
    public void testAddrBitLength() {
        Assert.assertThat((Object)128, (Matcher)Matchers.is((Object)128));
    }

    @Test
    public void testVersion() {
        IpAddress ipAddress = IpAddress.valueOf((String)"::");
        Assert.assertThat((Object)ipAddress.version(), (Matcher)Matchers.is((Object)IpAddress.Version.INET6));
    }

    @Test
    public void testAddressToOctetsIPv6() {
        byte[] value = new byte[]{17, 17, 34, 34, 51, 51, 68, 68, 85, 85, 102, 102, 119, 119, -120, -120};
        Ip6Address ipAddress = Ip6Address.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8888");
        Assert.assertThat((Object)ipAddress.toOctets(), (Matcher)Matchers.is((Object)value));
        value = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        ipAddress = Ip6Address.valueOf((String)"::");
        Assert.assertThat((Object)ipAddress.toOctets(), (Matcher)Matchers.is((Object)value));
        value = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        ipAddress = Ip6Address.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff");
        Assert.assertThat((Object)ipAddress.toOctets(), (Matcher)Matchers.is((Object)value));
    }

    @Test
    public void testValueOfByteArrayIPv6() {
        byte[] value = new byte[]{17, 17, 34, 34, 51, 51, 68, 68, 85, 85, 102, 102, 119, 119, -120, -120};
        Ip6Address ipAddress = Ip6Address.valueOf((byte[])value);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"1111:2222:3333:4444:5555:6666:7777:8888"));
        value = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        ipAddress = Ip6Address.valueOf((byte[])value);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"::"));
        value = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        ipAddress = Ip6Address.valueOf((byte[])value);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff"));
    }

    @Test(expected=NullPointerException.class)
    public void testInvalidValueOfNullArrayIPv6() {
        byte[] value = null;
        Ip6Address ipAddress = Ip6Address.valueOf(value);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfShortArrayIPv6() {
        byte[] value = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        Ip6Address ipAddress = Ip6Address.valueOf((byte[])value);
    }

    @Test
    public void testValueOfByteArrayOffsetIPv6() {
        byte[] value = new byte[]{11, 22, 33, 17, 17, 34, 34, 51, 51, 68, 68, 85, 85, 102, 102, 119, 119, -120, -120, 44, 55};
        Ip6Address ipAddress = Ip6Address.valueOf((byte[])value, (int)3);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"1111:2222:3333:4444:5555:6666:7777:8888"));
        value = new byte[]{11, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33};
        ipAddress = Ip6Address.valueOf((byte[])value, (int)2);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"::"));
        value = new byte[]{11, 22, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 33};
        ipAddress = Ip6Address.valueOf((byte[])value, (int)2);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfArrayInvalidOffsetIPv6() {
        byte[] value = new byte[]{11, 22, 33, 17, 17, 34, 34, 51, 51, 68, 68, 85, 85, 102, 102, 119, 119, -120, -120, 44, 55};
        Ip6Address ipAddress = Ip6Address.valueOf((byte[])value, (int)6);
    }

    @Test
    public void testValueOfInetAddressIPv6() {
        InetAddress inetAddress = InetAddresses.forString((String)"1111:2222:3333:4444:5555:6666:7777:8888");
        Ip6Address ipAddress = Ip6Address.valueOf((InetAddress)inetAddress);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"1111:2222:3333:4444:5555:6666:7777:8888"));
        inetAddress = InetAddresses.forString((String)"::");
        ipAddress = Ip6Address.valueOf((InetAddress)inetAddress);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"::"));
        inetAddress = InetAddresses.forString((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff");
        ipAddress = Ip6Address.valueOf((InetAddress)inetAddress);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff"));
    }

    @Test
    public void testValueOfStringIPv6() {
        Ip6Address ipAddress = Ip6Address.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8888");
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"1111:2222:3333:4444:5555:6666:7777:8888"));
        ipAddress = Ip6Address.valueOf((String)"::");
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"::"));
        ipAddress = Ip6Address.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff");
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff"));
    }

    @Test(expected=NullPointerException.class)
    public void testInvalidValueOfNullString() {
        String fromString = null;
        Ip6Address ipAddress = Ip6Address.valueOf(fromString);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfEmptyString() {
        String fromString = "";
        Ip6Address ipAddress = Ip6Address.valueOf((String)fromString);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfIncorrectString() {
        String fromString = "NoSuchIpAddress";
        Ip6Address ipAddress = Ip6Address.valueOf((String)fromString);
    }

    @Test
    public void testMakeMaskPrefixIPv6() {
        Ip6Address ipAddress = Ip6Address.makeMaskPrefix((int)8);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"ff00::"));
        ipAddress = Ip6Address.makeMaskPrefix((int)120);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ff00"));
        ipAddress = Ip6Address.makeMaskPrefix((int)0);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"::"));
        ipAddress = Ip6Address.makeMaskPrefix((int)128);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff"));
        ipAddress = Ip6Address.makeMaskPrefix((int)64);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"ffff:ffff:ffff:ffff::"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidMakeNegativeMaskPrefixIPv6() {
        Ip6Address ipAddress = Ip6Address.makeMaskPrefix((int)-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidMakeTooLongMaskPrefixIPv6() {
        Ip6Address ipAddress = Ip6Address.makeMaskPrefix((int)129);
    }

    @Test
    public void testMakeMaskedAddressIPv6() {
        Ip6Address ipAddress = Ip6Address.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8885");
        Ip6Address ipAddressMasked = Ip6Address.makeMaskedAddress((Ip6Address)ipAddress, (int)8);
        Assert.assertThat((Object)ipAddressMasked.toString(), (Matcher)Matchers.is((Object)"1100::"));
        ipAddressMasked = Ip6Address.makeMaskedAddress((Ip6Address)ipAddress, (int)120);
        Assert.assertThat((Object)ipAddressMasked.toString(), (Matcher)Matchers.is((Object)"1111:2222:3333:4444:5555:6666:7777:8800"));
        ipAddressMasked = Ip6Address.makeMaskedAddress((Ip6Address)ipAddress, (int)0);
        Assert.assertThat((Object)ipAddressMasked.toString(), (Matcher)Matchers.is((Object)"::"));
        ipAddressMasked = Ip6Address.makeMaskedAddress((Ip6Address)ipAddress, (int)128);
        Assert.assertThat((Object)ipAddressMasked.toString(), (Matcher)Matchers.is((Object)"1111:2222:3333:4444:5555:6666:7777:8885"));
        ipAddressMasked = Ip6Address.makeMaskedAddress((Ip6Address)ipAddress, (int)64);
        Assert.assertThat((Object)ipAddressMasked.toString(), (Matcher)Matchers.is((Object)"1111:2222:3333:4444::"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidMakeNegativeMaskedAddressIPv6() {
        Ip6Address ipAddress = Ip6Address.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8885");
        Ip6Address ipAddressMasked = Ip6Address.makeMaskedAddress((Ip6Address)ipAddress, (int)-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidMakeTooLongMaskedAddressIPv6() {
        Ip6Address ipAddress = Ip6Address.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8885");
        Ip6Address ipAddressMasked = Ip6Address.makeMaskedAddress((Ip6Address)ipAddress, (int)129);
    }

    @Test
    public void testComparisonIPv6() {
        Ip6Address addr1 = Ip6Address.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8888");
        Ip6Address addr2 = Ip6Address.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8888");
        Ip6Address addr3 = Ip6Address.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8887");
        Ip6Address addr4 = Ip6Address.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8889");
        Assert.assertTrue((addr1.compareTo((IpAddress)addr2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((addr1.compareTo((IpAddress)addr3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((addr1.compareTo((IpAddress)addr4) < 0 ? 1 : 0) != 0);
        addr1 = Ip6Address.valueOf((String)"ffff:2222:3333:4444:5555:6666:7777:8888");
        addr2 = Ip6Address.valueOf((String)"ffff:2222:3333:4444:5555:6666:7777:8888");
        addr3 = Ip6Address.valueOf((String)"ffff:2222:3333:4444:5555:6666:7777:8887");
        addr4 = Ip6Address.valueOf((String)"ffff:2222:3333:4444:5555:6666:7777:8889");
        Assert.assertTrue((addr1.compareTo((IpAddress)addr2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((addr1.compareTo((IpAddress)addr3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((addr1.compareTo((IpAddress)addr4) < 0 ? 1 : 0) != 0);
        addr1 = Ip6Address.valueOf((String)"ffff:2222:3333:4444:5555:6666:7777:8888");
        addr2 = Ip6Address.valueOf((String)"ffff:2222:3333:4444:5555:6666:7777:8888");
        addr3 = Ip6Address.valueOf((String)"ffff:2222:3333:4443:5555:6666:7777:8888");
        addr4 = Ip6Address.valueOf((String)"ffff:2222:3333:4445:5555:6666:7777:8888");
        Assert.assertTrue((addr1.compareTo((IpAddress)addr2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((addr1.compareTo((IpAddress)addr3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((addr1.compareTo((IpAddress)addr4) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEqualityIPv6() {
        new EqualsTester().addEqualityGroup(new Object[]{Ip6Address.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8888"), Ip6Address.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8888")}).addEqualityGroup(new Object[]{Ip6Address.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:888a"), Ip6Address.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:888a")}).addEqualityGroup(new Object[]{Ip6Address.valueOf((String)"::"), Ip6Address.valueOf((String)"::")}).addEqualityGroup(new Object[]{Ip6Address.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff"), Ip6Address.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff")}).testEquals();
    }

    @Test
    public void testToStringIPv6() {
        Ip6Address ipAddress = Ip6Address.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8888");
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"1111:2222:3333:4444:5555:6666:7777:8888"));
        ipAddress = Ip6Address.valueOf((String)"1111::8888");
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"1111::8888"));
        ipAddress = Ip6Address.valueOf((String)"1111::");
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"1111::"));
        ipAddress = Ip6Address.valueOf((String)"::8888");
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"::8888"));
        ipAddress = Ip6Address.valueOf((String)"::");
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"::"));
        ipAddress = Ip6Address.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff");
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff"));
    }
}

