/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.ndp;

import java.nio.ByteBuffer;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Deserializer;
import org.onlab.packet.MacAddress;
import org.onlab.packet.PacketTestUtils;
import org.onlab.packet.ndp.NeighborAdvertisement;
import org.onlab.packet.ndp.NeighborDiscoveryOptions;

public class NeighborAdvertisementTest {
    private static final byte[] TARGET_ADDRESS = new byte[]{32, 1, 15, 24, 1, 19, 2, 21, -54, 42, 20, -1, -2, 53, 38, -50};
    private static final MacAddress MAC_ADDRESS = MacAddress.valueOf((String)"11:22:33:44:55:66");
    private static byte[] bytePacket;
    private Deserializer<NeighborAdvertisement> deserializer = NeighborAdvertisement.deserializer();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        byte[] byteHeader = new byte[]{-32, 0, 0, 0, 32, 1, 15, 24, 1, 19, 2, 21, -54, 42, 20, -1, -2, 53, 38, -50, 2, 1, 17, 34, 51, 68, 85, 102};
        bytePacket = new byte[byteHeader.length];
        System.arraycopy(byteHeader, 0, bytePacket, 0, byteHeader.length);
    }

    @Test
    public void testSerialize() {
        NeighborAdvertisement na = new NeighborAdvertisement();
        na.setRouterFlag((byte)1);
        na.setSolicitedFlag((byte)1);
        na.setOverrideFlag((byte)1);
        na.setTargetAddress(TARGET_ADDRESS);
        na.addOption((byte)2, MAC_ADDRESS.toBytes());
        Assert.assertArrayEquals((byte[])na.serialize(), (byte[])bytePacket);
    }

    @Test
    public void testDeserializeBadInput() throws Exception {
        PacketTestUtils.testDeserializeBadInput(NeighborAdvertisement.deserializer());
    }

    @Test
    public void testDeserializeTruncated() throws Exception {
        byte[] naHeader = new byte[20];
        ByteBuffer.wrap(bytePacket).get(naHeader);
        PacketTestUtils.testDeserializeTruncated(NeighborAdvertisement.deserializer(), naHeader);
    }

    @Test
    public void testDeserialize() throws DeserializationException {
        NeighborAdvertisement na = (NeighborAdvertisement)this.deserializer.deserialize(bytePacket, 0, bytePacket.length);
        Assert.assertThat((Object)na.getRouterFlag(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)na.getSolicitedFlag(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)na.getOverrideFlag(), (Matcher)Matchers.is((Object)1));
        Assert.assertArrayEquals((byte[])na.getTargetAddress(), (byte[])TARGET_ADDRESS);
        Assert.assertThat((Object)na.getOptions().size(), (Matcher)Matchers.is((Object)1));
        NeighborDiscoveryOptions.Option option = (NeighborDiscoveryOptions.Option)na.getOptions().get(0);
        Assert.assertThat((Object)option.type(), (Matcher)Matchers.is((Object)2));
        Assert.assertArrayEquals((byte[])option.data(), (byte[])MAC_ADDRESS.toBytes());
    }

    @Test
    public void testEqual() {
        NeighborAdvertisement na1 = new NeighborAdvertisement();
        na1.setRouterFlag((byte)1);
        na1.setSolicitedFlag((byte)1);
        na1.setOverrideFlag((byte)1);
        na1.setTargetAddress(TARGET_ADDRESS);
        na1.addOption((byte)2, MAC_ADDRESS.toBytes());
        NeighborAdvertisement na2 = new NeighborAdvertisement();
        na2.setRouterFlag((byte)1);
        na2.setSolicitedFlag((byte)1);
        na2.setOverrideFlag((byte)0);
        na2.setTargetAddress(TARGET_ADDRESS);
        na2.addOption((byte)2, MAC_ADDRESS.toBytes());
        Assert.assertTrue((boolean)na1.equals((Object)na1));
        Assert.assertFalse((boolean)na1.equals((Object)na2));
    }

    @Test
    public void testToStringNA() throws Exception {
        NeighborAdvertisement na = (NeighborAdvertisement)this.deserializer.deserialize(bytePacket, 0, bytePacket.length);
        String str = na.toString();
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)"routerFlag=1"));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)"solicitedFlag=1"));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)"overrideFlag=1"));
    }
}

