/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import org.junit.Assert;
import org.junit.Test;
import org.onlab.junit.TestTools;
import org.onlab.util.Counter;

public class CounterTest {
    @Test
    public void basics() {
        Counter tt = new Counter();
        Assert.assertEquals((String)"incorrect number of bytes", (long)0L, (long)tt.total());
        Assert.assertEquals((String)"incorrect throughput", (double)0.0, (double)tt.throughput(), (double)1.0E-4);
        tt.add(1234567890L);
        Assert.assertEquals((String)"incorrect number of bytes", (long)1234567890L, (long)tt.total());
        Assert.assertTrue((String)"incorrect throughput", (1.23456789E9 < tt.throughput() ? 1 : 0) != 0);
        TestTools.delay((int)1500);
        tt.add(1L);
        Assert.assertEquals((String)"incorrect number of bytes", (long)1234567891L, (long)tt.total());
        Assert.assertTrue((String)"incorrect throughput", (1.234567891E9 > tt.throughput() ? 1 : 0) != 0);
        tt.reset();
        Assert.assertEquals((String)"incorrect number of bytes", (long)0L, (long)tt.total());
        Assert.assertEquals((String)"incorrect throughput", (double)0.0, (double)tt.throughput(), (double)1.0E-4);
    }

    @Test
    public void freeze() {
        long now = System.currentTimeMillis();
        Counter tt = new Counter(now, 123L, now + 1000L);
        tt.freeze();
        tt.add(123L);
        Assert.assertEquals((String)"incorrect number of bytes", (long)123L, (long)tt.total());
        double d = tt.duration();
        double t = tt.throughput();
        Assert.assertEquals((String)"incorrect duration", (double)d, (double)tt.duration(), (double)1.0E-4);
        Assert.assertEquals((String)"incorrect throughput", (double)t, (double)tt.throughput(), (double)1.0E-4);
        Assert.assertEquals((String)"incorrect number of bytes", (long)123L, (long)tt.total());
    }

    @Test
    public void reset() {
        Counter tt = new Counter();
        tt.add(123L);
        Assert.assertEquals((String)"incorrect number of bytes", (long)123L, (long)tt.total());
        double d = tt.duration();
        double t = tt.throughput();
        Assert.assertEquals((String)"incorrect duration", (double)d, (double)tt.duration(), (double)1.0E-4);
        Assert.assertEquals((String)"incorrect throughput", (double)t, (double)tt.throughput(), (double)1.0E-4);
        Assert.assertEquals((String)"incorrect number of bytes", (long)123L, (long)tt.total());
        tt.reset();
        Assert.assertEquals((String)"incorrect throughput", (double)0.0, (double)tt.throughput(), (double)1.0E-4);
        Assert.assertEquals((String)"incorrect number of bytes", (long)0L, (long)tt.total());
    }

    @Test
    public void syntheticTracker() {
        Counter tt = new Counter(5000L, 1000L, 6000L);
        Assert.assertEquals((String)"incorrect duration", (double)1.0, (double)tt.duration(), (double)0.1);
        Assert.assertEquals((String)"incorrect throughput", (double)1000.0, (double)tt.throughput(), (double)1.0);
    }
}

