/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import com.google.common.base.Preconditions;
import org.onlab.packet.DeserializationException;

public final class PacketUtils {
    private PacketUtils() {
    }

    public static void checkBufferLength(int byteLength, int offset, int length) throws DeserializationException {
        boolean ok = offset >= 0 && offset < byteLength;
        if (!(ok &= length >= 0 && offset + length <= byteLength)) {
            throw new DeserializationException("Unable to read " + length + " bytes from a " + byteLength + " byte array starting at offset " + offset);
        }
    }

    public static void checkHeaderLength(int givenLength, int requiredLength) throws DeserializationException {
        if (requiredLength > givenLength) {
            throw new DeserializationException(requiredLength + " bytes are needed to continue deserialization, however only " + givenLength + " remain in buffer");
        }
    }

    public static void checkInput(byte[] data, int offset, int length, int requiredLength) throws DeserializationException {
        Preconditions.checkNotNull((Object)data);
        PacketUtils.checkBufferLength(data.length, offset, length);
        PacketUtils.checkHeaderLength(length, requiredLength);
    }
}

