/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.graph;

import com.google.common.collect.ImmutableList;
import com.google.common.testing.EqualsTester;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.graph.DefaultMutablePath;
import org.onlab.graph.DefaultPath;
import org.onlab.graph.DefaultPathTest;
import org.onlab.graph.Edge;
import org.onlab.graph.Path;
import org.onlab.graph.TestDoubleWeight;
import org.onlab.graph.TestEdge;
import org.onlab.graph.TestVertex;
import org.onlab.graph.Weight;

public class DefaultMutablePathTest
extends DefaultPathTest {
    @Override
    @Test
    public void equality() {
        DefaultPath p1 = new DefaultPath((List)ImmutableList.of((Object)((Object)new TestEdge(A, B)), (Object)((Object)new TestEdge(B, C))), (Weight)new TestDoubleWeight(2.0));
        DefaultPath p2 = new DefaultPath((List)ImmutableList.of((Object)((Object)new TestEdge(A, B)), (Object)((Object)new TestEdge(B, D))), (Weight)new TestDoubleWeight(2.0));
        new EqualsTester().addEqualityGroup(new Object[]{new DefaultMutablePath((Path)p1), new DefaultMutablePath((Path)p1)}).addEqualityGroup(new Object[]{new DefaultMutablePath((Path)p2)}).testEquals();
    }

    @Test
    public void empty() {
        DefaultMutablePath p = new DefaultMutablePath();
        Assert.assertNull((String)"src should be null", (Object)p.src());
        Assert.assertNull((String)"dst should be null", (Object)p.dst());
        Assert.assertEquals((String)"incorrect edge count", (long)0L, (long)p.edges().size());
        Assert.assertEquals((String)"incorrect path cost", null, (Object)p.cost());
    }

    @Test
    public void pathCost() {
        DefaultMutablePath p = new DefaultMutablePath();
        TestDoubleWeight weight = new TestDoubleWeight(4.0);
        p.setCost((Weight)weight);
        Assert.assertEquals((String)"incorrect path cost", (Object)weight, (Object)p.cost());
    }

    private void validatePath(Path<TestVertex, TestEdge> p, TestVertex src, TestVertex dst, int length) {
        this.validatePath(p, src, dst, length, null);
    }

    @Test
    public void insertEdge() {
        DefaultMutablePath p = new DefaultMutablePath();
        p.insertEdge((Edge)new TestEdge(B, C));
        p.insertEdge((Edge)new TestEdge(A, B));
        this.validatePath((Path<TestVertex, TestEdge>)p, A, C, 2);
    }

    @Test
    public void appendEdge() {
        DefaultMutablePath p = new DefaultMutablePath();
        p.appendEdge((Edge)new TestEdge(A, B));
        p.appendEdge((Edge)new TestEdge(B, C));
        this.validatePath((Path<TestVertex, TestEdge>)p, A, C, 2);
    }

    @Test
    public void removeEdge() {
        DefaultMutablePath p = new DefaultMutablePath();
        p.appendEdge((Edge)new TestEdge(A, B));
        p.appendEdge((Edge)new TestEdge(B, C));
        p.appendEdge((Edge)new TestEdge(C, C));
        p.appendEdge((Edge)new TestEdge(C, D));
        this.validatePath((Path<TestVertex, TestEdge>)p, A, D, 4);
        p.removeEdge((Edge)new TestEdge(A, B));
        this.validatePath((Path<TestVertex, TestEdge>)p, B, D, 3);
        p.removeEdge((Edge)new TestEdge(C, C));
        this.validatePath((Path<TestVertex, TestEdge>)p, B, D, 2);
        p.removeEdge((Edge)new TestEdge(C, D));
        this.validatePath((Path<TestVertex, TestEdge>)p, B, C, 1);
    }

    @Test
    public void toImmutable() {
        DefaultMutablePath p = new DefaultMutablePath();
        p.appendEdge((Edge)new TestEdge(A, B));
        p.appendEdge((Edge)new TestEdge(B, C));
        this.validatePath((Path<TestVertex, TestEdge>)p, A, C, 2);
        Assert.assertEquals((String)"immutables should equal", (Object)p.toImmutable(), (Object)p.toImmutable());
        this.validatePath((Path<TestVertex, TestEdge>)p.toImmutable(), A, C, 2);
    }
}

