/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Deserializer;
import org.onlab.packet.Ethernet;
import org.onlab.packet.MacAddress;
import org.onlab.packet.PacketTestUtils;

public class EthernetTest {
    private MacAddress dstMac;
    private MacAddress srcMac;
    private short ethertype = (short)6;
    private short vlan = (short)5;
    private short qinqVlan = (short)55;
    private Deserializer<Ethernet> deserializer;
    private byte[] byteHeader;
    private byte[] vlanByteHeader;
    private byte[] qinq8100ByteHeader;
    private byte[] qinq88a8ByteHeader;
    private static byte[] qinqHeaderExpected = new byte[]{-120, -120, -120, -120, -120, -120, -86, -86, -86, -86, -86, -86, -120, -88, 0, 55, -127, 0, 0, 5, 0, 6};

    @Before
    public void setUp() {
        this.deserializer = Ethernet.deserializer();
        byte[] dstMacBytes = new byte[]{-120, -120, -120, -120, -120, -120};
        this.dstMac = MacAddress.valueOf((byte[])dstMacBytes);
        byte[] srcMacBytes = new byte[]{-86, -86, -86, -86, -86, -86};
        this.srcMac = MacAddress.valueOf((byte[])srcMacBytes);
        ByteBuffer bb = ByteBuffer.allocate(14);
        bb.put(dstMacBytes);
        bb.put(srcMacBytes);
        bb.putShort(this.ethertype);
        this.byteHeader = bb.array();
        bb = ByteBuffer.allocate(18);
        bb.put(dstMacBytes);
        bb.put(srcMacBytes);
        bb.putShort(Ethernet.TYPE_VLAN);
        bb.putShort(this.vlan);
        bb.putShort(this.ethertype);
        this.vlanByteHeader = bb.array();
        bb = ByteBuffer.allocate(22);
        bb.put(dstMacBytes);
        bb.put(srcMacBytes);
        bb.putShort(Ethernet.TYPE_VLAN);
        bb.putShort(this.vlan);
        bb.putShort(Ethernet.TYPE_VLAN);
        bb.putShort(this.vlan);
        bb.putShort(this.ethertype);
        this.qinq8100ByteHeader = bb.array();
        bb = ByteBuffer.allocate(22);
        bb.put(dstMacBytes);
        bb.put(srcMacBytes);
        bb.putShort(Ethernet.TYPE_QINQ);
        bb.putShort(this.qinqVlan);
        bb.putShort(Ethernet.TYPE_VLAN);
        bb.putShort(this.vlan);
        bb.putShort(this.ethertype);
        this.qinq88a8ByteHeader = bb.array();
    }

    @Test
    public void testDeserializeBadInput() throws Exception {
        PacketTestUtils.testDeserializeBadInput(this.deserializer);
    }

    @Test
    public void testDeserializeTruncated() throws DeserializationException {
        PacketTestUtils.testDeserializeTruncated(this.deserializer, this.vlanByteHeader);
    }

    @Test
    public void testDeserializeNoVlan() throws Exception {
        Ethernet eth = (Ethernet)this.deserializer.deserialize(this.byteHeader, 0, this.byteHeader.length);
        Assert.assertEquals((Object)this.dstMac, (Object)eth.getDestinationMAC());
        Assert.assertEquals((Object)this.srcMac, (Object)eth.getSourceMAC());
        Assert.assertEquals((long)-1L, (long)eth.getVlanID());
        Assert.assertEquals((long)this.ethertype, (long)eth.getEtherType());
    }

    @Test
    public void testDeserializeWithVlan() throws Exception {
        Ethernet eth = (Ethernet)this.deserializer.deserialize(this.vlanByteHeader, 0, this.vlanByteHeader.length);
        Assert.assertEquals((Object)this.dstMac, (Object)eth.getDestinationMAC());
        Assert.assertEquals((Object)this.srcMac, (Object)eth.getSourceMAC());
        Assert.assertEquals((long)this.vlan, (long)eth.getVlanID());
        Assert.assertEquals((long)this.ethertype, (long)eth.getEtherType());
    }

    @Test
    public void testDeserializeWithQinQ() throws Exception {
        Ethernet eth = (Ethernet)this.deserializer.deserialize(this.qinq8100ByteHeader, 0, this.qinq8100ByteHeader.length);
        Assert.assertEquals((Object)this.dstMac, (Object)eth.getDestinationMAC());
        Assert.assertEquals((Object)this.srcMac, (Object)eth.getSourceMAC());
        Assert.assertEquals((long)this.vlan, (long)eth.getVlanID());
        Assert.assertEquals((long)this.vlan, (long)eth.getQinQVID());
        Assert.assertEquals((long)this.ethertype, (long)eth.getEtherType());
        eth = (Ethernet)this.deserializer.deserialize(this.qinq88a8ByteHeader, 0, this.qinq88a8ByteHeader.length);
        Assert.assertEquals((Object)this.dstMac, (Object)eth.getDestinationMAC());
        Assert.assertEquals((Object)this.srcMac, (Object)eth.getSourceMAC());
        Assert.assertEquals((long)this.vlan, (long)eth.getVlanID());
        Assert.assertEquals((long)this.qinqVlan, (long)eth.getQinQVID());
        Assert.assertEquals((long)this.ethertype, (long)eth.getEtherType());
    }

    @Test
    public void testSerializeWithQinQ() throws Exception {
        Ethernet eth = new Ethernet();
        eth.setDestinationMACAddress(this.dstMac);
        eth.setSourceMACAddress(this.srcMac);
        eth.setVlanID(this.vlan);
        eth.setQinQVID(this.qinqVlan);
        eth.setEtherType(this.ethertype);
        byte[] encoded = eth.serialize();
        Assert.assertEquals((Object)Arrays.toString(encoded), (Object)Arrays.toString(qinqHeaderExpected));
    }
}

