/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.onlab.junit.TestTools;
import org.onlab.junit.TestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManuallyAdvancingTimer
extends Timer {
    private boolean staticsPopulated = false;
    private int virginState;
    private int scheduledState;
    private int executedState;
    private int cancelledState;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final TimerKeeper timerKeeper = new TimerKeeper();
    private final TaskQueue queue = new TaskQueue();
    private final boolean runLocally;

    public ManuallyAdvancingTimer(boolean runLocally) {
        this.runLocally = runLocally;
    }

    @Override
    public void schedule(TimerTask task, long delay) {
        if (!this.staticsPopulated) {
            this.populateStatics(task);
        }
        if (!this.submitTask(task, delay > 0L ? this.timerKeeper.currentTimeInMillis() + delay : this.timerKeeper.currentTimeInMillis() - delay, 0L)) {
            this.logger.error("Failed to submit task");
        }
    }

    @Override
    public void schedule(TimerTask task, Date time) {
        if (!this.staticsPopulated) {
            this.populateStatics(task);
        }
        if (!this.submitTask(task, time.getTime(), 0L)) {
            this.logger.error("Failed to submit task");
        }
    }

    @Override
    public void schedule(TimerTask task, long delay, long period) {
        if (!this.staticsPopulated) {
            this.populateStatics(task);
        }
        if (!this.submitTask(task, delay > 0L ? this.timerKeeper.currentTimeInMillis() + delay : this.timerKeeper.currentTimeInMillis() - delay, period)) {
            this.logger.error("Failed to submit task");
        }
    }

    @Override
    public void schedule(TimerTask task, Date firstTime, long period) {
        if (!this.staticsPopulated) {
            this.populateStatics(task);
        }
        if (!this.submitTask(task, firstTime.getTime(), period)) {
            this.logger.error("Failed to submit task");
        }
    }

    @Override
    public void scheduleAtFixedRate(TimerTask task, long delay, long period) {
        if (!this.staticsPopulated) {
            this.populateStatics(task);
        }
        if (!this.submitTask(task, delay > 0L ? this.timerKeeper.currentTimeInMillis() + delay : this.timerKeeper.currentTimeInMillis() - delay, period)) {
            this.logger.error("Failed to submit task");
        }
    }

    @Override
    public void scheduleAtFixedRate(TimerTask task, Date firstTime, long period) {
        if (!this.staticsPopulated) {
            this.populateStatics(task);
        }
        if (!this.submitTask(task, firstTime.getTime(), period)) {
            this.logger.error("Failed to submit task");
        }
    }

    @Override
    public void cancel() {
        this.executorService.shutdown();
        this.queue.clear();
    }

    @Override
    public int purge() {
        return this.queue.removeCancelled();
    }

    public long currentTimeInMillis() {
        return this.timerKeeper.currentTimeInMillis();
    }

    public long advanceTimeMillis(long millisToAdvance) {
        return this.timerKeeper.advanceTimeMillis(millisToAdvance);
    }

    public void advanceTimeMillis(long virtualTimeAdvance, int realTimeDelay) {
        this.timerKeeper.advanceTimeMillis(virtualTimeAdvance);
        if (!this.runLocally) {
            TestTools.delay((int)realTimeDelay);
        }
    }

    private boolean submitTask(TimerTask task, long runtime, long period) {
        Preconditions.checkNotNull((Object)task);
        try {
            TestUtils.setField((Object)task, (String)"state", (Object)this.scheduledState);
            TestUtils.setField((Object)task, (String)"nextExecutionTime", (Object)runtime);
            TestUtils.setField((Object)task, (String)"period", (Object)period);
        }
        catch (TestUtils.TestUtilsException e) {
            e.printStackTrace();
            return false;
        }
        this.queue.insertOrdered(task);
        return true;
    }

    private boolean executeTask(TimerTask task) {
        int currentState;
        Preconditions.checkNotNull((Object)task);
        try {
            currentState = (Integer)TestUtils.getField((Object)task, (String)"state");
        }
        catch (TestUtils.TestUtilsException e) {
            this.logger.error("Could not get state of task.");
            e.printStackTrace();
            return false;
        }
        if (currentState == this.executedState || currentState == this.cancelledState) {
            return false;
        }
        if (currentState == this.virginState) {
            this.logger.error("Task was set for execution without being scheduled.");
            return false;
        }
        if (currentState == this.scheduledState) {
            long period;
            try {
                period = (Long)TestUtils.getField((Object)task, (String)"period");
            }
            catch (TestUtils.TestUtilsException e) {
                this.logger.error("Could not read period of task.");
                e.printStackTrace();
                return false;
            }
            if (period == 0L) {
                try {
                    TestUtils.setField((Object)task, (String)"state", (Object)this.executedState);
                }
                catch (TestUtils.TestUtilsException e) {
                    this.logger.error("Could not set executed state.");
                    e.printStackTrace();
                    return false;
                }
                if (this.runLocally) {
                    task.run();
                } else {
                    this.executorService.execute(task);
                }
                return true;
            }
            long nextTime = period > 0L ? this.timerKeeper.currentTimeInMillis() + period : this.timerKeeper.currentTimeInMillis() - period;
            try {
                TestUtils.setField((Object)task, (String)"nextExecutionTime", (Object)nextTime);
            }
            catch (TestUtils.TestUtilsException e) {
                this.logger.error("Could not set next execution time.");
                e.printStackTrace();
                return false;
            }
            this.queue.insertOrdered(task);
            if (this.runLocally) {
                task.run();
            } else {
                this.executorService.execute(task);
            }
            return true;
        }
        this.logger.error("State property of {} is in an illegal state and did not execute.", (Object)task);
        return false;
    }

    private int executeEventsUpToPresent() {
        long currExecTime;
        int totalRun = 0;
        if (this.queue.isEmpty()) {
            return -1;
        }
        TimerTask currTask = this.queue.peek();
        try {
            currExecTime = (Long)TestUtils.getField((Object)currTask, (String)"nextExecutionTime");
        }
        catch (TestUtils.TestUtilsException e) {
            e.printStackTrace();
            throw new RuntimeException("Could not get nextExecutionTime");
        }
        while (currExecTime <= this.timerKeeper.currentTimeInMillis()) {
            if (this.executeTask(this.queue.pop())) {
                ++totalRun;
            }
            if (this.queue.isEmpty()) break;
            currTask = this.queue.peek();
            try {
                currExecTime = (Long)TestUtils.getField((Object)currTask, (String)"nextExecutionTime");
            }
            catch (TestUtils.TestUtilsException e) {
                e.printStackTrace();
                throw new RuntimeException("Could not get nextExecutionTime");
            }
        }
        return totalRun;
    }

    private void populateStatics(TimerTask task) {
        try {
            this.virginState = (Integer)TestUtils.getField((Object)task, (String)"VIRGIN");
            this.scheduledState = (Integer)TestUtils.getField((Object)task, (String)"SCHEDULED");
            this.executedState = (Integer)TestUtils.getField((Object)task, (String)"EXECUTED");
            this.cancelledState = (Integer)TestUtils.getField((Object)task, (String)"CANCELLED");
            this.staticsPopulated = true;
        }
        catch (TestUtils.TestUtilsException e) {
            e.printStackTrace();
        }
    }

    private class TaskQueue {
        private final LinkedList<TimerTask> taskList = Lists.newLinkedList();

        private TaskQueue() {
        }

        void insertOrdered(TimerTask task) {
            long insertTime;
            Preconditions.checkNotNull((Object)task);
            if (!ManuallyAdvancingTimer.this.staticsPopulated) {
                ManuallyAdvancingTimer.this.populateStatics(task);
            }
            try {
                insertTime = (Long)TestUtils.getField((Object)task, (String)"nextExecutionTime");
                TestUtils.setField((Object)task, (String)"state", (Object)ManuallyAdvancingTimer.this.scheduledState);
            }
            catch (TestUtils.TestUtilsException e) {
                e.printStackTrace();
                return;
            }
            if (insertTime <= ManuallyAdvancingTimer.this.timerKeeper.currentTimeInMillis()) {
                ManuallyAdvancingTimer.this.executeTask(task);
                return;
            }
            Iterator iter = this.taskList.iterator();
            int positionCounter = 0;
            while (iter.hasNext()) {
                long nextTaskTime;
                TimerTask currentTask = (TimerTask)iter.next();
                try {
                    nextTaskTime = (Long)TestUtils.getField((Object)currentTask, (String)"nextExecutionTime");
                }
                catch (TestUtils.TestUtilsException e) {
                    e.printStackTrace();
                    return;
                }
                if (insertTime < nextTaskTime) {
                    this.taskList.add(positionCounter, task);
                    return;
                }
                ++positionCounter;
            }
            this.taskList.addLast(task);
        }

        TimerTask peek() {
            if (this.taskList.isEmpty()) {
                return null;
            }
            return this.taskList.getFirst();
        }

        TimerTask pop() {
            if (this.taskList.isEmpty()) {
                return null;
            }
            return this.taskList.pop();
        }

        void sort() {
            if (this.taskList.isEmpty()) {
                return;
            }
            this.taskList.sort((o1, o2) -> {
                long executionTimeTwo;
                long executionTimeOne;
                Preconditions.checkNotNull((Object)o1);
                Preconditions.checkNotNull((Object)o2);
                try {
                    executionTimeOne = (Long)TestUtils.getField((Object)o1, (String)"nextExecutionTime");
                    executionTimeTwo = (Long)TestUtils.getField((Object)o2, (String)"nextExecutionTime");
                }
                catch (TestUtils.TestUtilsException e) {
                    e.printStackTrace();
                    throw new RuntimeException("Could not get next execution time.");
                }
                if (executionTimeOne == executionTimeTwo) {
                    return 0;
                }
                if (executionTimeOne < executionTimeTwo) {
                    return -1;
                }
                return 1;
            });
        }

        boolean isEmpty() {
            return this.taskList.isEmpty();
        }

        void clear() {
            this.taskList.clear();
        }

        int removeCancelled() {
            if (this.taskList.isEmpty()) {
                return -1;
            }
            int removedCount = 0;
            Iterator taskIterator = this.taskList.iterator();
            while (taskIterator.hasNext()) {
                int currState;
                TimerTask currTask = (TimerTask)taskIterator.next();
                try {
                    currState = (Integer)TestUtils.getField((Object)currTask, (String)"state");
                }
                catch (TestUtils.TestUtilsException e) {
                    ManuallyAdvancingTimer.this.logger.error("Could not get task state.");
                    e.printStackTrace();
                    return -1;
                }
                if (currState != ManuallyAdvancingTimer.this.cancelledState) continue;
                ++removedCount;
                taskIterator.remove();
            }
            return removedCount;
        }
    }

    private class TimerKeeper {
        private long currentTime = 0L;

        private TimerKeeper() {
        }

        long currentTimeInMillis() {
            return this.currentTime;
        }

        long advanceTimeMillis(long millisToAdvance) {
            long l = this.currentTime = millisToAdvance >= 0L ? this.currentTime + millisToAdvance : this.currentTime - millisToAdvance;
            if (millisToAdvance != 0L) {
                ManuallyAdvancingTimer.this.executeEventsUpToPresent();
            }
            return this.currentTime;
        }
    }
}

