/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.junit.TestTools;
import org.onlab.util.ManuallyAdvancingTimer;

public class ManuallyAdvancingTimerTest {
    private ManuallyAdvancingTimer timer;
    private AtomicInteger idGenerator;
    private ArrayList<TestTask> taskList;
    private AtomicInteger tasksRunCount;
    private static final int REAL_TIME_DELAY = 10;

    @Before
    public void setup() {
        this.timer = new ManuallyAdvancingTimer(true);
        this.idGenerator = new AtomicInteger(1);
        this.tasksRunCount = new AtomicInteger(0);
        this.taskList = Lists.newArrayList();
    }

    @Test
    public void testScheduleByDelay() throws Exception {
        int i;
        this.timer.schedule((TimerTask)new TestTask(), 10L);
        this.timer.advanceTimeMillis(5L);
        Assert.assertFalse((boolean)this.taskList.get(0).hasRun());
        this.timer.advanceTimeMillis(10L, 10);
        Assert.assertTrue((boolean)this.taskList.get(0).hasRun());
        this.timer.schedule((TimerTask)new TestTask(), -10L);
        this.timer.advanceTimeMillis(5L);
        Assert.assertFalse((boolean)this.taskList.get(1).hasRun());
        this.timer.advanceTimeMillis(10L, 10);
        Assert.assertTrue((boolean)this.taskList.get(1).hasRun());
        this.taskList.clear();
        this.idGenerator.set(1);
        this.tasksRunCount.set(0);
        for (i = 0; i < 50; ++i) {
            this.timer.schedule((TimerTask)new TestTask(), i);
        }
        Assert.assertEquals((String)"Only the first task should have run.", (long)1L, (long)this.tasksRunCount.get());
        for (i = 2; i <= 50; ++i) {
            this.timer.advanceTimeMillis(1L, 10);
            Assert.assertEquals((String)"One task should be executed per loop", (long)i, (long)this.tasksRunCount.get());
        }
        this.tasksRunCount.set(0);
        for (i = 0; i < 10; ++i) {
            this.timer.schedule((TimerTask)new TestTask(), 500L);
        }
        Assert.assertEquals((String)"No new tasks should have been run  since run count reset.", (long)0L, (long)this.tasksRunCount.get());
        this.timer.schedule((TimerTask)new TestTask(), 10L);
        Assert.assertEquals((String)"No new tasks should have been run  since run count reset.", (long)0L, (long)this.tasksRunCount.get());
        this.timer.advanceTimeMillis(10L, 10);
        Assert.assertEquals((String)"One new tasks should have been run  since run count reset.", (long)1L, (long)this.tasksRunCount.get());
        this.timer.advanceTimeMillis(510L, 10);
        Assert.assertEquals((String)"Eleven new tasks should have been run  since run count reset.", (long)11L, (long)this.tasksRunCount.get());
    }

    @Test
    public void testScheduleByDate() throws Exception {
        this.timer.schedule((TimerTask)new TestTask(), new Date(10L));
        this.timer.advanceTimeMillis(5L);
        Assert.assertFalse((boolean)this.taskList.get(0).hasRun());
        this.timer.advanceTimeMillis(10L, 10);
        Assert.assertTrue((boolean)this.taskList.get(0).hasRun());
        this.timer.schedule((TimerTask)new TestTask(), new Date(0L));
        TestTools.delay((int)10);
        Assert.assertTrue((boolean)this.taskList.get(1).hasRun());
        TestTask task = new TestTask();
        this.timer.schedule((TimerTask)task, new Date(this.timer.currentTimeInMillis() + 10L));
        task.cancel();
        this.timer.advanceTimeMillis(12L, 10);
        Assert.assertFalse((boolean)task.hasRun());
    }

    @Test
    public void testScheduleByDelayPeriodic() throws Exception {
        this.timer.schedule((TimerTask)new TestTask(), 0L, 10L);
        TestTools.delay((int)10);
        Assert.assertEquals((String)"Task should have run once when added.", (long)1L, (long)this.taskList.get(0).timesRun());
        this.timer.advanceTimeMillis(10L, 10);
        Assert.assertEquals((String)"Task should have run once when added.", (long)2L, (long)this.taskList.get(0).timesRun());
        this.taskList.get(0).cancel();
        this.timer.advanceTimeMillis(10L, 10);
        Assert.assertEquals((String)"The task should not have run another time.", (long)2L, (long)this.taskList.get(0).timesRun());
        TestTask task = new TestTask();
        this.timer.schedule((TimerTask)task, 0L, 10L);
        this.timer.advanceTimeMillis(100L, 10);
        Assert.assertEquals((String)"Should have run immeditaley and subsequently once during the larger skip", (long)task.timesRun(), (long)2L);
    }

    @Test
    public void testScheduleByDatePeriodic() throws Exception {
        this.timer.schedule((TimerTask)new TestTask(), new Date(this.timer.currentTimeInMillis()), 10L);
        TestTools.delay((int)10);
        Assert.assertEquals((String)"Task should have run once when added.", (long)1L, (long)this.taskList.get(0).timesRun());
        this.timer.advanceTimeMillis(10L, 10);
        Assert.assertEquals((String)"Task should have run once when added.", (long)2L, (long)this.taskList.get(0).timesRun());
        this.taskList.get(0).cancel();
        this.timer.advanceTimeMillis(10L, 10);
        Assert.assertEquals((String)"The task should not have run another time.", (long)2L, (long)this.taskList.get(0).timesRun());
        TestTask task = new TestTask();
        this.timer.schedule((TimerTask)task, new Date(this.timer.currentTimeInMillis()), 10L);
        this.timer.advanceTimeMillis(100L, 10);
        Assert.assertEquals((String)"Should have run immediately and subsequently once during the larger skip", (long)task.timesRun(), (long)2L);
    }

    private class TestTask
    extends TimerTask {
        private boolean hasRun;
        private int id;
        private int timesRun;

        public TestTask() {
            this.id = ManuallyAdvancingTimerTest.this.idGenerator.getAndIncrement();
            this.timesRun = 0;
            this.hasRun = false;
            ManuallyAdvancingTimerTest.this.taskList.add(this);
        }

        @Override
        public void run() {
            this.hasRun = true;
            ManuallyAdvancingTimerTest.this.tasksRunCount.incrementAndGet();
            ++this.timesRun;
        }

        public boolean hasRun() {
            return this.hasRun;
        }

        public int timesRun() {
            return this.timesRun;
        }

        public int getId() {
            return this.id;
        }
    }
}

