/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.onlab.metrics.MetricsComponent;
import org.onlab.metrics.MetricsFeature;
import org.onlab.metrics.MetricsReporter;
import org.onlab.metrics.MetricsService;

public class MetricsManager
implements MetricsService {
    private ConcurrentMap<String, MetricsComponent> componentsRegistry = new ConcurrentHashMap<String, MetricsComponent>();
    private MetricRegistry metricsRegistry = new MetricRegistry();
    private Set<MetricsReporter> reporters = Sets.newConcurrentHashSet();

    protected void clear() {
        this.componentsRegistry = new ConcurrentHashMap<String, MetricsComponent>();
        this.metricsRegistry = new MetricRegistry();
    }

    @Override
    public MetricsComponent registerComponent(String name) {
        MetricsComponent createdComponent;
        MetricsComponent component = (MetricsComponent)this.componentsRegistry.get(name);
        if (component == null && (component = this.componentsRegistry.putIfAbsent(name, createdComponent = new MetricsComponent(name))) == null) {
            component = createdComponent;
        }
        return component;
    }

    @Override
    public MetricRegistry getMetricRegistry() {
        return this.metricsRegistry;
    }

    private String generateName(MetricsComponent component, MetricsFeature feature, String metricName) {
        return MetricRegistry.name((String)component.getName(), (String[])new String[]{feature.getName(), metricName});
    }

    @Override
    public Counter createCounter(MetricsComponent component, MetricsFeature feature, String metricName) {
        String name = this.generateName(component, feature, metricName);
        return this.metricsRegistry.counter(name);
    }

    @Override
    public Histogram createHistogram(MetricsComponent component, MetricsFeature feature, String metricName) {
        String name = this.generateName(component, feature, metricName);
        return this.metricsRegistry.histogram(name);
    }

    @Override
    public Timer createTimer(MetricsComponent component, MetricsFeature feature, String metricName) {
        String name = this.generateName(component, feature, metricName);
        return this.metricsRegistry.timer(name);
    }

    @Override
    public Meter createMeter(MetricsComponent component, MetricsFeature feature, String metricName) {
        String name = this.generateName(component, feature, metricName);
        return this.metricsRegistry.meter(name);
    }

    @Override
    public <T extends Metric> T registerMetric(MetricsComponent component, MetricsFeature feature, String metricName, T metric) {
        String name = this.generateName(component, feature, metricName);
        this.metricsRegistry.register(name, metric);
        return metric;
    }

    @Override
    public void registerReporter(MetricsReporter reporter) {
        this.reporters.add(reporter);
    }

    @Override
    public void unregisterReporter(MetricsReporter reporter) {
        this.reporters.remove(reporter);
    }

    @Override
    public void notifyReporters() {
        this.reporters.forEach(MetricsReporter::notifyMetricsChange);
    }

    @Override
    public boolean removeMetric(MetricsComponent component, MetricsFeature feature, String metricName) {
        String name = this.generateName(component, feature, metricName);
        return this.metricsRegistry.remove(name);
    }

    @Override
    public Map<String, Timer> getTimers(MetricFilter filter) {
        return this.metricsRegistry.getTimers(filter);
    }

    @Override
    public Map<String, Gauge> getGauges(MetricFilter filter) {
        return this.metricsRegistry.getGauges(filter);
    }

    @Override
    public Map<String, Counter> getCounters(MetricFilter filter) {
        return this.metricsRegistry.getCounters(filter);
    }

    @Override
    public Map<String, Meter> getMeters(MetricFilter filter) {
        return this.metricsRegistry.getMeters(filter);
    }

    @Override
    public Map<String, Histogram> getHistograms(MetricFilter filter) {
        return this.metricsRegistry.getHistograms(filter);
    }

    @Override
    public void removeMatching(MetricFilter filter) {
        this.metricsRegistry.removeMatching(filter);
    }

    @Override
    public Map<String, Metric> getMetrics() {
        return this.metricsRegistry.getMetrics();
    }
}

