/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import com.google.common.base.MoreObjects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang3.concurrent.ConcurrentUtils;

public final class GroupedThreadFactory
implements ThreadFactory {
    public static final String DELIMITER = "/";
    private final ThreadGroup group;
    private static final ConcurrentHashMap<String, GroupedThreadFactory> FACTORIES = new ConcurrentHashMap();

    public static GroupedThreadFactory groupedThreadFactory(String groupName) {
        GroupedThreadFactory factory = FACTORIES.get(groupName);
        if (factory != null) {
            return factory;
        }
        int i = groupName.lastIndexOf(DELIMITER);
        if (i > 0) {
            String name = groupName.substring(0, i);
            ThreadGroup parentGroup = GroupedThreadFactory.groupedThreadFactory(name).threadGroup();
            factory = new GroupedThreadFactory(new ThreadGroup(parentGroup, groupName));
        } else {
            factory = new GroupedThreadFactory(new ThreadGroup(groupName));
        }
        return (GroupedThreadFactory)ConcurrentUtils.putIfAbsent(FACTORIES, (Object)groupName, (Object)factory);
    }

    private GroupedThreadFactory(ThreadGroup group) {
        this.group = group;
    }

    public ThreadGroup threadGroup() {
        return this.group;
    }

    @Override
    public Thread newThread(Runnable r) {
        return new Thread(this.group, r);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("group", (Object)this.group).toString();
    }
}

