/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import java.nio.ByteBuffer;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.IGMPGroup;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.IpAddress;
import org.onlab.packet.PacketUtils;

public class IGMPQuery
extends IGMPGroup {
    private byte resv = 0;
    private boolean sbit = false;
    private byte qrv = (byte)2;
    private byte qqic = (byte)125;

    public IGMPQuery(IpAddress gaddr, int auxInfo) {
        super(gaddr, auxInfo);
    }

    public IGMPQuery() {
    }

    public boolean isSbit() {
        return this.sbit;
    }

    public void setSbit(boolean sbit) {
        this.sbit = sbit;
    }

    public byte getQrv() {
        return this.qrv;
    }

    public void setQrv(byte qrv) {
        this.qrv = qrv;
    }

    public byte getResv() {
        return this.resv;
    }

    public void setResv(byte resv) {
        this.resv = resv;
    }

    @Override
    public byte[] serialize(ByteBuffer bb) {
        bb.put(this.gaddr.toOctets());
        byte fld = (byte)(7 & this.qrv);
        bb.put(fld);
        bb.put(this.qqic);
        bb.putShort((short)this.sources.size());
        for (IpAddress ipaddr : this.sources) {
            bb.put(ipaddr.toOctets());
        }
        return bb.array();
    }

    @Override
    public IGMPGroup deserialize(ByteBuffer bb) throws DeserializationException {
        short nsrcs;
        this.gaddr = Ip4Address.valueOf(bb.getInt());
        byte fld = bb.get();
        this.resv = 0;
        this.sbit = (fld & 8) == 8;
        this.qrv = (byte)(fld & 7);
        this.qqic = bb.get();
        int lengthNeeded = 4 * nsrcs;
        PacketUtils.checkHeaderLength(bb.remaining(), lengthNeeded);
        for (nsrcs = bb.getShort(); nsrcs > 0; nsrcs = (short)(nsrcs - 1)) {
            Ip4Address ipaddr = Ip4Address.valueOf(bb.getInt());
            this.sources.add(ipaddr);
        }
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IGMPQuery)) {
            return false;
        }
        IGMPQuery other = (IGMPQuery)obj;
        if (this.sbit != other.sbit) {
            return false;
        }
        if (this.qrv != other.qrv) {
            return false;
        }
        if (this.qqic != other.qqic) {
            return false;
        }
        if (this.sources.size() != other.sources.size()) {
            return false;
        }
        return this.sources.equals(other.sources);
    }

    public int hashCode() {
        int prime = 2521;
        int result = super.hashCode();
        result = 2521 * result + this.gaddr.hashCode();
        result = 2521 * result + this.qqic;
        result = 2521 * result + this.qrv;
        result = 2521 * result + this.sources.hashCode();
        return result;
    }
}

