/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.onlab.packet.BasePacket;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Deserializer;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IPacket;
import org.onlab.packet.LLDPOrganizationalTLV;
import org.onlab.packet.LLDPTLV;
import org.onlab.packet.PacketUtils;

public class LLDP
extends BasePacket {
    public static final byte CHASSIS_TLV_TYPE = 1;
    public static final short CHASSIS_TLV_SIZE = 7;
    public static final byte CHASSIS_TLV_SUBTYPE = 4;
    public static final byte PORT_TLV_TYPE = 2;
    public static final short PORT_TLV_SIZE = 5;
    public static final byte PORT_TLV_SUBTYPE = 2;
    public static final byte TTL_TLV_TYPE = 3;
    public static final short TTL_TLV_SIZE = 2;
    protected LLDPTLV chassisId;
    protected LLDPTLV portId;
    protected LLDPTLV ttl;
    protected List<LLDPTLV> optionalTLVList = new LinkedList<LLDPTLV>();
    protected short ethType = Ethernet.TYPE_LLDP;

    public LLDPTLV getChassisId() {
        return this.chassisId;
    }

    public LLDP setChassisId(LLDPTLV chassis) {
        this.chassisId = chassis;
        return this;
    }

    public LLDPTLV getPortId() {
        return this.portId;
    }

    public LLDP setPortId(LLDPTLV portId) {
        this.portId = portId;
        return this;
    }

    public LLDPTLV getTtl() {
        return this.ttl;
    }

    public LLDP setTtl(LLDPTLV ttl) {
        this.ttl = ttl;
        return this;
    }

    public List<LLDPTLV> getOptionalTLVList() {
        return this.optionalTLVList;
    }

    public LLDP setOptionalTLVList(List<LLDPTLV> optionalTLVList) {
        this.optionalTLVList = optionalTLVList;
        return this;
    }

    @Override
    public byte[] serialize() {
        int length = 2 + this.chassisId.getLength() + 2 + this.portId.getLength() + 2 + this.ttl.getLength() + 2;
        for (LLDPTLV tlv : this.optionalTLVList) {
            length += 2 + tlv.getLength();
        }
        byte[] data = new byte[length];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.put(this.chassisId.serialize());
        bb.put(this.portId.serialize());
        bb.put(this.ttl.serialize());
        for (LLDPTLV tlv : this.optionalTLVList) {
            bb.put(tlv.serialize());
        }
        bb.putShort((short)0);
        return data;
    }

    @Override
    public IPacket deserialize(byte[] data, int offset, int length) {
        LLDPTLV tlv;
        ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
        do {
            try {
                tlv = new LLDPOrganizationalTLV().deserialize(bb);
            }
            catch (DeserializationException e) {
                break;
            }
            if (tlv == null) break;
            switch (tlv.getType()) {
                case 0: {
                    break;
                }
                case 1: {
                    this.chassisId = tlv;
                    break;
                }
                case 2: {
                    this.portId = tlv;
                    break;
                }
                case 3: {
                    this.ttl = tlv;
                    break;
                }
                default: {
                    this.optionalTLVList.add(tlv);
                }
            }
        } while (tlv.getType() != 0 && bb.hasRemaining());
        return this;
    }

    @Override
    public int hashCode() {
        int prime = 883;
        int result = super.hashCode();
        result = 883 * result + (this.chassisId == null ? 0 : this.chassisId.hashCode());
        result = 883 * result + this.optionalTLVList.hashCode();
        result = 883 * result + (this.portId == null ? 0 : this.portId.hashCode());
        result = 883 * result + (this.ttl == null ? 0 : this.ttl.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof LLDP)) {
            return false;
        }
        LLDP other = (LLDP)obj;
        if (this.chassisId == null ? other.chassisId != null : !this.chassisId.equals(other.chassisId)) {
            return false;
        }
        if (!this.optionalTLVList.equals(other.optionalTLVList)) {
            return false;
        }
        if (this.portId == null ? other.portId != null : !this.portId.equals(other.portId)) {
            return false;
        }
        return !(this.ttl == null ? other.ttl != null : !this.ttl.equals(other.ttl));
    }

    public static Deserializer<LLDP> deserializer() {
        return (data, offset, length) -> {
            LLDPTLV tlv;
            PacketUtils.checkInput(data, offset, length, 0);
            LLDP lldp = new LLDP();
            int currentIndex = 0;
            ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
            do {
                PacketUtils.checkHeaderLength(length, currentIndex += 2);
                tlv = new LLDPOrganizationalTLV().deserialize(bb);
                if (tlv == null) break;
                switch (tlv.getType()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        lldp.chassisId = tlv;
                        break;
                    }
                    case 2: {
                        lldp.portId = tlv;
                        break;
                    }
                    case 3: {
                        lldp.ttl = tlv;
                        break;
                    }
                    default: {
                        lldp.optionalTLVList.add(tlv);
                    }
                }
                currentIndex += tlv.getLength();
            } while (tlv.getType() != 0);
            return lldp;
        };
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("chassisId", (Object)Arrays.toString(this.chassisId.getValue())).add("portId", (Object)Arrays.toString(this.portId.getValue())).add("ttl", (Object)Arrays.toString(this.ttl.getValue())).add("ethType", (Object)Short.toString(this.ethType)).toString();
    }
}

