/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Set;

public class MacAddress {
    public static final MacAddress ONOS;
    public static final MacAddress NONE;
    public static final MacAddress ONOS_LLDP;
    public static final MacAddress ZERO;
    public static final MacAddress BROADCAST;
    public static final MacAddress IPV4_MULTICAST;
    public static final MacAddress IPV4_MULTICAST_MASK;
    public static final Set<MacAddress> LLDP;
    public static final int MAC_ADDRESS_LENGTH = 6;
    private byte[] address = new byte[6];

    public MacAddress(byte[] address) {
        this.address = Arrays.copyOf(address, 6);
    }

    public static MacAddress valueOf(String address) {
        String[] elements = address.split(":");
        if (elements.length != 6) {
            throw new IllegalArgumentException("Specified MAC Address must contain 12 hex digits separated pairwise by :'s.");
        }
        byte[] addressInBytes = new byte[6];
        for (int i = 0; i < 6; ++i) {
            String element = elements[i];
            addressInBytes[i] = (byte)Integer.parseInt(element, 16);
        }
        return new MacAddress(addressInBytes);
    }

    public static MacAddress valueOf(byte[] address) {
        if (address.length != 6) {
            throw new IllegalArgumentException("the length is not 6");
        }
        return new MacAddress(address);
    }

    public static MacAddress valueOf(long address) {
        byte[] addressInBytes = new byte[]{(byte)(address >> 40 & 0xFFL), (byte)(address >> 32 & 0xFFL), (byte)(address >> 24 & 0xFFL), (byte)(address >> 16 & 0xFFL), (byte)(address >> 8 & 0xFFL), (byte)(address >> 0 & 0xFFL)};
        return new MacAddress(addressInBytes);
    }

    public int length() {
        return this.address.length;
    }

    public byte[] toBytes() {
        return Arrays.copyOf(this.address, this.address.length);
    }

    public long toLong() {
        long mac = 0L;
        for (int i = 0; i < 6; ++i) {
            long t = ((long)this.address[i] & 0xFFL) << (5 - i) * 8;
            mac |= t;
        }
        return mac;
    }

    public boolean isBroadcast() {
        for (byte b : this.address) {
            if (b == -1) continue;
            return false;
        }
        return true;
    }

    public boolean isMulticast() {
        if (this.isBroadcast()) {
            return false;
        }
        return (this.address[0] & 1) != 0;
    }

    @Deprecated
    public boolean isLinkLocal() {
        return this.isLldp();
    }

    public boolean isLldp() {
        return LLDP.contains(this);
    }

    public boolean isOnos() {
        return Arrays.equals(this.oui(), ONOS.oui());
    }

    public byte[] oui() {
        return Arrays.copyOfRange(this.address, 0, 3);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MacAddress)) {
            return false;
        }
        MacAddress other = (MacAddress)o;
        return Arrays.equals(this.address, other.address);
    }

    public int hashCode() {
        return Long.hashCode(this.toLong());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (byte b : this.address) {
            if (builder.length() > 0) {
                builder.append(":");
            }
            builder.append(String.format("%02X", b & 0xFF));
        }
        return builder.toString();
    }

    public String toStringNoColon() {
        StringBuilder builder = new StringBuilder();
        for (byte b : this.address) {
            builder.append(String.format("%02X", b & 0xFF));
        }
        return builder.toString();
    }

    static {
        NONE = ONOS = MacAddress.valueOf("a4:23:05:00:00:00");
        ONOS_LLDP = MacAddress.valueOf("a5:23:05:00:00:01");
        ZERO = MacAddress.valueOf("00:00:00:00:00:00");
        BROADCAST = MacAddress.valueOf("ff:ff:ff:ff:ff:ff");
        IPV4_MULTICAST = MacAddress.valueOf("01:00:5e:00:00:00");
        IPV4_MULTICAST_MASK = MacAddress.valueOf("ff:ff:ff:80:00:00");
        LLDP = Sets.newHashSet((Object[])new MacAddress[]{MacAddress.valueOf("01:80:c2:00:00:00"), MacAddress.valueOf("01:80:c2:00:00:03"), MacAddress.valueOf("01:80:c2:00:00:0e")});
    }
}

