/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.ndp;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.onlab.packet.BasePacket;
import org.onlab.packet.Deserializer;
import org.onlab.packet.Ethernet;
import org.onlab.packet.ICMP6;
import org.onlab.packet.IPacket;
import org.onlab.packet.IPv6;
import org.onlab.packet.PacketUtils;
import org.onlab.packet.VlanId;
import org.onlab.packet.ndp.NeighborDiscoveryOptions;

public class NeighborSolicitation
extends BasePacket {
    public static final byte HEADER_LENGTH = 20;
    protected byte[] targetAddress = new byte[16];
    private final NeighborDiscoveryOptions options = new NeighborDiscoveryOptions();

    public byte[] getTargetAddress() {
        return this.targetAddress;
    }

    public NeighborSolicitation setTargetAddress(byte[] targetAddress) {
        this.targetAddress = Arrays.copyOfRange(targetAddress, 0, 16);
        return this;
    }

    public List<NeighborDiscoveryOptions.Option> getOptions() {
        return this.options.options();
    }

    public NeighborSolicitation addOption(byte type, byte[] data) {
        this.options.addOption(type, data);
        return this;
    }

    @Override
    public byte[] serialize() {
        byte[] optionsData = null;
        if (this.options.hasOptions()) {
            optionsData = this.options.serialize();
        }
        int optionsLength = 0;
        if (optionsData != null) {
            optionsLength = optionsData.length;
        }
        byte[] data = new byte[20 + optionsLength];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.putInt(0);
        bb.put(this.targetAddress, 0, 16);
        if (optionsData != null) {
            bb.put(optionsData);
        }
        return data;
    }

    @Override
    public IPacket deserialize(byte[] data, int offset, int length) {
        ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
        bb.getInt();
        bb.get(this.targetAddress, 0, 16);
        this.options.deserialize(data, bb.position(), bb.limit() - bb.position());
        return this;
    }

    @Override
    public int hashCode() {
        int prime = 5807;
        int result = super.hashCode();
        ByteBuffer bb = ByteBuffer.wrap(this.targetAddress);
        for (int i = 0; i < this.targetAddress.length / 4; ++i) {
            result = 5807 * result + bb.getInt();
        }
        result = 5807 * result + this.options.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof NeighborSolicitation)) {
            return false;
        }
        NeighborSolicitation other = (NeighborSolicitation)obj;
        if (!Arrays.equals(this.targetAddress, other.targetAddress)) {
            return false;
        }
        return this.options.equals(other.options);
    }

    public static Deserializer<NeighborSolicitation> deserializer() {
        return (data, offset, length) -> {
            PacketUtils.checkInput(data, offset, length, 20);
            NeighborSolicitation neighborSolicitation = new NeighborSolicitation();
            ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
            bb.getInt();
            bb.get(neighborSolicitation.targetAddress, 0, 16);
            if (bb.limit() - bb.position() > 0) {
                NeighborDiscoveryOptions options = NeighborDiscoveryOptions.deserializer().deserialize(data, bb.position(), bb.limit() - bb.position());
                for (NeighborDiscoveryOptions.Option option : options.options()) {
                    neighborSolicitation.addOption(option.type(), option.data());
                }
            }
            return neighborSolicitation;
        };
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("targetAddress", (Object)Arrays.toString(this.targetAddress)).toString();
    }

    public static Ethernet buildNdpSolicit(byte[] targetIp, byte[] sourceIp, byte[] destinationIp, byte[] sourceMac, byte[] destinationMac, VlanId vlan) {
        if (targetIp.length != 16 || sourceIp.length != 16 || destinationIp.length != 16 || sourceMac.length != 6 || destinationMac.length != 6) {
            return null;
        }
        Ethernet ethernet = new Ethernet();
        ethernet.setEtherType(Ethernet.TYPE_IPV6).setDestinationMACAddress(destinationMac).setSourceMACAddress(sourceMac);
        ethernet.setVlanID((Short)vlan.id());
        IPv6 ipv6 = new IPv6();
        ipv6.setSourceAddress(sourceIp);
        ipv6.setDestinationAddress(destinationIp);
        ipv6.setHopLimit((byte)-1);
        ICMP6 icmp6 = new ICMP6();
        icmp6.setIcmpType((byte)-121);
        icmp6.setIcmpCode((byte)0);
        NeighborSolicitation ns = new NeighborSolicitation();
        ns.setTargetAddress(targetIp);
        ns.addOption((byte)1, sourceMac);
        icmp6.setPayload(ns);
        ipv6.setPayload(icmp6);
        ethernet.setPayload(ipv6);
        return ethernet;
    }
}

