/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.onlab.graph.GAOrganism;

class GAPopulation<Organism extends GAOrganism>
extends ArrayList<Organism> {
    Random r = new Random();

    GAPopulation() {
    }

    void step() {
        GAOrganism org12;
        Collections.sort(this, (org1, org2) -> org1.fitness().compareTo(org2.fitness()));
        int maxSize = this.size();
        for (int i = this.size() - 1; i > maxSize / 4; --i) {
            this.remove(i);
        }
        for (GAOrganism org : this) {
            if (!this.r.nextBoolean()) continue;
            org.mutate();
        }
        while (this.size() < maxSize * 4 / 5) {
            org12 = (GAOrganism)this.get(this.r.nextInt(this.size()));
            GAOrganism org22 = (GAOrganism)this.get(this.r.nextInt(this.size()));
            this.add(org12.crossWith(org22));
        }
        while (this.size() < maxSize) {
            org12 = (GAOrganism)this.get(this.r.nextInt(this.size()));
            this.add(org12.random());
        }
    }

    List<Organism> runGA(int generations, int populationSize, int sample, Organism template) {
        int i;
        for (i = 0; i < populationSize; ++i) {
            this.add(template.random());
        }
        for (i = 0; i < generations; ++i) {
            this.step();
        }
        for (i = this.size() - 1; i >= sample; --i) {
            this.remove(i);
        }
        return new ArrayList(this);
    }
}

