/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import org.junit.Assert;
import org.junit.Test;
import org.onlab.util.PositionalParameterStringFormatter;

public class PositionalParameterStringFormatterTest {
    @Test
    public void testFormat0() {
        String fmt = "Some string 1 2 3";
        Assert.assertEquals((Object)"Some string 1 2 3", (Object)PositionalParameterStringFormatter.format((String)fmt, (Object[])new Object[0]));
    }

    @Test
    public void testFormat1() {
        String fmt = "Some string {} 2 3";
        Assert.assertEquals((Object)"Some string 1 2 3", (Object)PositionalParameterStringFormatter.format((String)fmt, (Object[])new Object[]{1}));
    }

    @Test
    public void testFormat2() {
        String fmt = "Some string {} 2 {}";
        Assert.assertEquals((Object)"Some string 1 2 3", (Object)PositionalParameterStringFormatter.format((String)fmt, (Object[])new Object[]{1, "3"}));
    }

    @Test
    public void testFormatNull() {
        String fmt = "Some string {} 2 {}";
        Assert.assertEquals((Object)"Some string 1 2 null", (Object)PositionalParameterStringFormatter.format((String)fmt, (Object[])new Object[]{1, null}));
    }

    @Test
    public void testFormatExtraBracket() {
        String fmt = "Some string {} 2 {}";
        Assert.assertEquals((Object)"Some string 1 2 {}", (Object)PositionalParameterStringFormatter.format((String)fmt, (Object[])new Object[]{1}));
    }

    @Test
    public void testFormatMissingBracket() {
        String fmt = "Some string 1 2 3";
        Assert.assertEquals((Object)"Some string 1 2 3", (Object)PositionalParameterStringFormatter.format((String)fmt, (Object[])new Object[]{7}));
    }
}

