/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public class BlockingBoolean
extends AbstractQueuedSynchronizer {
    private static final int TRUE = 1;
    private static final int FALSE = 0;

    public BlockingBoolean(boolean value) {
        this.setState(value ? 1 : 0);
    }

    public void await(boolean value) throws InterruptedException {
        this.acquireSharedInterruptibly(value ? 1 : 0);
    }

    public boolean await(boolean value, long timeout, TimeUnit unit) throws InterruptedException {
        return this.tryAcquireSharedNanos(value ? 1 : 0, unit.toNanos(timeout));
    }

    @Override
    protected int tryAcquireShared(int acquires) {
        return this.getState() == acquires ? 1 : -1;
    }

    public void set(boolean value) {
        this.releaseShared(value ? 1 : 0);
    }

    public boolean get() {
        return this.getState() == 1;
    }

    @Override
    protected boolean tryReleaseShared(int releases) {
        int state = this.getState();
        if (state == releases) {
            return false;
        }
        return this.compareAndSetState(state, releases);
    }
}

