/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.util.ExtendedSet;

public class ExtendedSetTest {
    @Test
    public void testGet() {
        ExtendedSet set = new ExtendedSet((Map)Maps.newConcurrentMap());
        TestValue e1 = new TestValue("foo", 1);
        set.add((Object)e1);
        TestValue lookupValue = new TestValue("foo", 2);
        TestValue setEntry = (TestValue)set.get((Object)lookupValue);
        Assert.assertEquals((Object)e1, (Object)setEntry);
    }

    @Test
    public void testInsertOrReplace() {
        ExtendedSet set = new ExtendedSet((Map)Maps.newConcurrentMap());
        TestValue small = new TestValue("foo", 1);
        TestValue medium = new TestValue("foo", 2);
        TestValue large = new TestValue("foo", 3);
        Assert.assertTrue((boolean)set.insertOrReplace((Object)small, existing -> existing.value2() < small.value2()));
        Assert.assertTrue((boolean)set.insertOrReplace((Object)large, existing -> existing.value2() < large.value2()));
        Assert.assertFalse((boolean)set.insertOrReplace((Object)medium, existing -> existing.value2() < medium.value2()));
        Assert.assertTrue((boolean)set.contains((Object)small));
        Assert.assertTrue((boolean)set.contains((Object)medium));
        Assert.assertTrue((boolean)set.contains((Object)large));
    }

    @Test
    public void testConditionalRemove() {
        ExtendedSet set = new ExtendedSet((Map)Maps.newConcurrentMap());
        TestValue small = new TestValue("foo", 1);
        TestValue medium = new TestValue("foo", 2);
        Assert.assertTrue((boolean)set.add((Object)small));
        set.conditionalRemove((Object)medium, existing -> existing.value2() < medium.value2);
        Assert.assertFalse((boolean)set.contains((Object)small));
    }

    private class TestValue {
        private String value1;
        private int value2;

        public TestValue(String v1, int v2) {
            this.value1 = v1;
            this.value2 = v2;
        }

        public String value1() {
            return this.value1;
        }

        public int value2() {
            return this.value2;
        }

        public boolean equals(Object other) {
            if (other instanceof TestValue) {
                TestValue that = (TestValue)other;
                return Objects.equals(this.value1, that.value1);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.value1);
        }
    }
}

